/*
 * Decompiled with CFR 0.152.
 */
package org.mm.hero_reborn.entity.client.goal;

import java.util.List;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.mm.hero_reborn.entity.custom.MossGolem;

public class HealEntity<T extends LivingEntity>
extends TargetGoal {
    private final Class<T> targetEntity;
    private T target;
    private final MossGolem entity;
    private final float range;
    private static final float HEAL_THRESHOLD = 0.5f;
    private static final float HEAL_AMOUNT = 1.0f;

    public HealEntity(MossGolem mossGolem, Class<T> entityClass, float range) {
        super((Mob)mossGolem, true, false);
        this.entity = mossGolem;
        this.targetEntity = entityClass;
        this.range = range;
    }

    public boolean m_8036_() {
        AABB aabb;
        Level level = this.entity.m_9236_();
        List list = level.m_45976_(this.targetEntity, aabb = this.getTargetSearchArea());
        if (list.isEmpty()) {
            return false;
        }
        this.target = list.stream().filter(LivingEntity::m_6084_).filter(this::isBelowHealThreshold).min((a, b) -> Float.compare(a.m_21223_(), b.m_21223_())).orElse(null);
        return this.target != null;
    }

    private boolean isBelowHealThreshold(LivingEntity entity) {
        return entity.m_21223_() < entity.m_21233_() * 0.5f;
    }

    public void m_8056_() {
        this.f_26135_.m_6710_(this.target);
        super.m_8056_();
    }

    public void m_8037_() {
        if (this.target != null && this.target.m_6084_() && this.isBelowHealThreshold((LivingEntity)this.target)) {
            this.target.m_5634_(1.0f);
        } else {
            this.m_8041_();
        }
    }

    public void m_8041_() {
        this.target = null;
        this.f_26135_.m_6710_(null);
        super.m_8041_();
    }

    protected AABB getTargetSearchArea() {
        return this.entity.m_20191_().m_82377_((double)this.range, 1.0, (double)this.range);
    }
}

