/*
 * Decompiled with CFR 0.152.
 */
package net.yukulab.robandpeace.mixin.spiderwalker;

import com.mojang.logging.LogUtils;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1656;
import net.minecraft.class_1657;
import net.minecraft.class_1702;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5134;
import net.minecraft.class_5635;
import net.yukulab.robandpeace.config.RapServerConfig;
import net.yukulab.robandpeace.extension.CustomClimbingStateHolder;
import net.yukulab.robandpeace.extension.MovementPayloadHolder;
import net.yukulab.robandpeace.item.RapItems;
import net.yukulab.robandpeace.network.payload.PlayerMovementPayload;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1657.class})
public abstract class PlayerEntityMixin
extends class_1309
implements MovementPayloadHolder,
CustomClimbingStateHolder {
    @Unique
    private static final Logger logger = LogUtils.getLogger();
    @Unique
    private static final class_2960 SPRINTING_SPEED = class_2960.method_60655((String)"robandpeace", (String)"sprinting_speed");
    @Unique
    private static final class_2960 STEP_HEIGHT = class_2960.method_60655((String)"robandpeace", (String)"step_height");
    @Unique
    private static final class_2960 MOVEMENT_SPEED = class_2960.method_60655((String)"robandpeace", (String)"movement_speed");
    @Unique
    private static final float DEFAULT_STEP_HEIGHT = 0.6f;
    @Unique
    private static class_2940<Boolean> ROBANDPEACE_IS_CLIMBING;
    @Shadow
    @Final
    private static Map<class_4050, class_4048> field_18134;
    @Shadow
    @Final
    public static class_4048 field_18135;
    @Unique
    private Optional<class_2338> slidingPos = Optional.empty();

    protected PlayerEntityMixin(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Shadow
    public abstract class_1656 method_31549();

    @Shadow
    public abstract class_1702 method_7344();

    @Shadow
    protected abstract float method_49484();

    @Unique
    private boolean canStartSprinting() {
        return !this.method_5624() && this.isWalking() && this.canSprint() && !this.method_6115() && !this.method_6059(class_1294.field_5919) && (!this.method_5765() || this.canVehicleSprint(this.method_5854())) && !this.method_6128();
    }

    @Unique
    private boolean canVehicleSprint(class_1297 entity) {
        return entity.method_48155() && entity.method_5787();
    }

    @Unique
    private boolean isWalking() {
        PlayerMovementPayload payload = this.robandpeace$getPlayerMovementPayload();
        boolean hasForwardMovement = payload.getHasForwardMovement();
        float movementForward = payload.getMovementForward();
        return this.method_5869() ? hasForwardMovement : (double)movementForward >= 0.8;
    }

    @Unique
    private boolean canSprint() {
        return this.method_5765() || (float)this.method_7344().method_7586() > 6.0f || this.method_31549().field_7478;
    }

    @Inject(method={"<clinit>"}, at={@At(value="RETURN")})
    private static void addClimbingDataTrackerEntry(CallbackInfo ci) {
        ROBANDPEACE_IS_CLIMBING = class_2945.method_12791(class_1657.class, (class_2941)class_2943.field_13323);
    }

    @Inject(method={"initDataTracker"}, at={@At(value="RETURN")})
    private void initDataTracker(class_2945.class_9222 builder, CallbackInfo ci) {
        builder.method_56912(ROBANDPEACE_IS_CLIMBING, (Object)false);
    }

    @Inject(method={"travel"}, at={@At(value="HEAD")})
    public void travelHead(class_243 movementInput, CallbackInfo ci) {
        RapServerConfig config = (RapServerConfig)this.robandpeace$getServerConfigSupplier().get();
        boolean alwaysSprint = config.spiderWalkerSettings.walking.alwaysSprint;
        float stepHeight = config.spiderWalkerSettings.walking.stepHeight;
        this.field_5976 = false;
        if (this.canStartSprinting()) {
            this.method_5728(alwaysSprint || this.method_5624());
        }
    }

    @Unique
    private void setStepHeight(float stepHeight) {
        class_1324 instance = this.method_6127().method_45329(class_5134.field_47761);
        if (instance == null) {
            logger.warn("Failed to get step height attribute.");
            return;
        }
        class_1322 modifier = new class_1322(STEP_HEIGHT, (double)(0.6f - stepHeight), class_1322.class_1323.field_6330);
        instance.method_6200(STEP_HEIGHT);
        instance.method_26835(modifier);
    }

    @Unique
    private void resetStepHeight() {
        class_1324 instance = this.method_5996(class_5134.field_47761);
        if (instance == null) {
            logger.warn("Failed to get step height attribute.");
            return;
        }
        instance.method_6200(STEP_HEIGHT);
    }

    public class_243 method_26318(class_243 movementInput, float slipperiness) {
        this.method_5724(this.getMovementSpeed(slipperiness), movementInput);
        RapServerConfig config = (RapServerConfig)this.robandpeace$getServerConfigSupplier().get();
        boolean wallMovement = config.spiderWalkerSettings.wall.wallMovement;
        if (super.method_6101()) {
            this.method_18799(this.applyClimbingSpeed(this.method_18798()));
        } else if (wallMovement && !this.method_7325()) {
            this.method_18799(this.applyWallMovement(this.method_18798()));
        }
        this.method_5784(class_1313.field_6308, this.method_18798());
        class_243 vec3d = this.method_18798();
        if ((this.field_5976 || this.field_6282) && (this.method_6101() || this.method_55667().method_27852(class_2246.field_27879) && class_5635.method_32355((class_1297)this))) {
            vec3d = new class_243(vec3d.field_1352, 0.2, vec3d.field_1350);
        }
        return vec3d;
    }

    @Unique
    private float getMovementSpeed(float slipperiness) {
        return this.method_24828() ? this.method_6029() * (0.21600002f / (slipperiness * slipperiness * slipperiness)) : this.method_49484();
    }

    @Override
    public boolean robandpeace$isClimbing() {
        return (Boolean)this.field_6011.method_12789(ROBANDPEACE_IS_CLIMBING);
    }

    @Override
    public void robandpeace$setClimbing(boolean wallClimbing) {
        this.field_6011.method_12778(ROBANDPEACE_IS_CLIMBING, (Object)wallClimbing);
    }

    @Unique
    private class_243 applyWallMovement(class_243 motion) {
        if (this.method_24828()) {
            this.robandpeace$setClimbing(false);
            return motion;
        }
        if (!this.canClimbing()) {
            return motion;
        }
        class_1657 player = (class_1657)this;
        PlayerEntityMixin injector = this;
        RapServerConfig config = injector.robandpeace$getServerConfigSupplier().get();
        float wallDistance = config.spiderWalkerSettings.wall.wallDistance;
        float minimumYawToJump = config.spiderWalkerSettings.wall.minimumYawToJump;
        boolean jumpOnLeavingWall = config.spiderWalkerSettings.wall.jumpOnLeavingWall;
        float wallJumpVelocityMultiplier = config.spiderWalkerSettings.wall.wallJumpVelocityMultiplier;
        float wallJumpHeight = config.spiderWalkerSettings.wall.wallJumpHeight;
        boolean wallRunning = config.spiderWalkerSettings.wall.wallRunning;
        float yawToRun = config.spiderWalkerSettings.wall.yawToRun;
        float minimumWallRunSpeed = config.spiderWalkerSettings.wall.minimumWallRunSpeed;
        float wallRunSlidingSpeed = config.spiderWalkerSettings.wall.wallRunSlidingSpeed;
        float wallRunSpeedBonus = config.spiderWalkerSettings.wall.wallRunSpeedBonus;
        boolean wallClimbing = config.spiderWalkerSettings.wall.wallClimbing;
        float pitchToClimb = config.spiderWalkerSettings.wall.pitchToClimb;
        float climbingSpeed = config.spiderWalkerSettings.wall.climbingSpeed;
        boolean wallSticking = config.spiderWalkerSettings.wall.wallSticking;
        boolean wallSliding = config.spiderWalkerSettings.wall.wallSliding;
        float slidingSpeed = config.spiderWalkerSettings.wall.slidingSpeed;
        boolean stickyMovement = config.spiderWalkerSettings.wall.stickyMovement;
        boolean wallJumping = config.spiderWalkerSettings.wall.wallJumping;
        PlayerMovementPayload payload = this.robandpeace$getPlayerMovementPayload();
        if (payload == null) {
            payload = DEFAULT_PAYLOAD;
        }
        boolean hasForwardMovement = payload.getHasForwardMovement();
        boolean inputJumping = payload.isJumping();
        class_2338 blockPos = this.method_24515().method_10084();
        class_1937 world = this.method_37908();
        double dx = (double)blockPos.method_10263() + 0.5 - this.method_23317();
        double dz = (double)blockPos.method_10260() + 0.5 - this.method_23321();
        double threshold = (double)(this.method_17681() / 2.0f) - (double)0.1f - (double)wallDistance - 1.0E-7;
        boolean east = world.method_24368(blockPos.method_10078(), (class_1297)this, class_2350.field_11039) && -dx > threshold;
        boolean west = world.method_24368(blockPos.method_10067(), (class_1297)this, class_2350.field_11034) && dx > threshold;
        boolean north = world.method_24368(blockPos.method_10095(), (class_1297)this, class_2350.field_11035) && dz > threshold;
        boolean south = world.method_24368(blockPos.method_10072(), (class_1297)this, class_2350.field_11043) && -dz > threshold;
        int wallsTouching = (east ? 1 : 0) + (west ? 1 : 0) + (north ? 1 : 0) + (south ? 1 : 0);
        boolean isWalling = this.robandpeace$isClimbing();
        if (wallsTouching == 0 && isWalling) {
            blockPos = this.method_24515();
            east = world.method_24368(blockPos.method_10078(), (class_1297)this, class_2350.field_11039) && -dx > threshold;
            west = world.method_24368(blockPos.method_10067(), (class_1297)this, class_2350.field_11034) && dx > threshold;
            north = world.method_24368(blockPos.method_10095(), (class_1297)this, class_2350.field_11035) && dz > threshold;
            south = world.method_24368(blockPos.method_10072(), (class_1297)this, class_2350.field_11043) && -dz > threshold;
            wallsTouching = (east ? 1 : 0) + (west ? 1 : 0) + (north ? 1 : 0) + (south ? 1 : 0);
        }
        float yaw = this.method_36454();
        float pitch = this.method_36455() * -1.0f;
        yaw += 90.0f * (float)((east ? 1 : 0) - (west ? 1 : 0) + (north ? (east ? 2 : -2) : 0)) / (float)wallsTouching;
        yaw = class_3532.method_15393((float)yaw);
        yaw = Math.abs(yaw);
        double motionX = motion.field_1352;
        double motionZ = motion.field_1350;
        double motionY = motion.field_1351;
        if (isWalling && (wallJumping && !inputJumping && yaw > minimumYawToJump || jumpOnLeavingWall && wallsTouching == 0)) {
            float f = this.method_36454() * ((float)Math.PI / 180);
            this.robandpeace$setClimbing(false);
            this.slidingPos = Optional.of(this.method_24515());
            this.method_38785();
            return new class_243(motionX += (double)(-class_3532.method_15374((float)f) * wallJumpVelocityMultiplier), motionY += (double)(wallJumpHeight * this.method_23313() + this.method_37416()), motionZ += (double)(class_3532.method_15362((float)f) * wallJumpVelocityMultiplier));
        }
        if (wallsTouching == 0 || !inputJumping || yaw > 90.0f && !isWalling) {
            this.robandpeace$setClimbing(false);
            return motion;
        }
        this.robandpeace$setClimbing(true);
        if (wallRunning && hasForwardMovement && yaw > yawToRun && (Math.abs(motionX) > (double)minimumWallRunSpeed || Math.abs(motionZ) > (double)minimumWallRunSpeed)) {
            motionY = Math.max(motion.field_1351, (double)(-wallRunSlidingSpeed));
            motionX = motion.field_1352 * (double)(1.0f + wallRunSpeedBonus);
            motionZ = motion.field_1350 * (double)(1.0f + wallRunSpeedBonus);
        } else if (wallClimbing && yaw < 90.0f && hasForwardMovement) {
            motionY = climbingSpeed;
            motionX = class_3532.method_15350((double)motionX, (double)(-climbingSpeed), (double)climbingSpeed);
            motionZ = class_3532.method_15350((double)motionZ, (double)(-climbingSpeed), (double)climbingSpeed);
        } else if (wallSticking && motionY < 0.0 && this.method_21754()) {
            motionY = 0.0;
            motionX = class_3532.method_15350((double)motionX, (double)(-climbingSpeed), (double)climbingSpeed);
            motionZ = class_3532.method_15350((double)motionZ, (double)(-climbingSpeed), (double)climbingSpeed);
        } else if (wallSliding) {
            motionY = Math.max(motion.field_1351, (double)(-slidingSpeed));
            motionX = class_3532.method_15350((double)motionX, (double)(-climbingSpeed), (double)climbingSpeed);
            motionZ = class_3532.method_15350((double)motionZ, (double)(-climbingSpeed), (double)climbingSpeed);
        } else {
            this.robandpeace$setClimbing(false);
            return motion;
        }
        if (this.method_5715()) {
            player.method_18382();
        }
        if (stickyMovement) {
            motionX *= (double)((north ? 1 : 0) + (south ? 1 : 0));
            motionZ *= (double)((east ? 1 : 0) + (west ? 1 : 0));
        }
        this.slidingPos = Optional.of(this.method_24515());
        this.method_38785();
        return new class_243(motionX, motionY, motionZ);
    }

    @Unique
    private class_243 applyClimbingSpeed(class_243 motion) {
        this.method_38785();
        float climbingSpeed = 0.15f;
        double d = class_3532.method_15350((double)motion.field_1352, (double)(-climbingSpeed), (double)climbingSpeed);
        double e = class_3532.method_15350((double)motion.field_1350, (double)(-climbingSpeed), (double)climbingSpeed);
        double g = Math.max(motion.field_1351, (double)(-climbingSpeed));
        if ((this.field_5976 || this.field_6282) && (this.method_6101() || this.method_55667().method_27852(class_2246.field_27879) && class_5635.method_32355((class_1297)this))) {
            g = 0.2;
        } else if (g < 0.0 && !this.method_55667().method_27852(class_2246.field_16492) && this.method_21754()) {
            g = 0.0;
        }
        motion = new class_243(d, g, e);
        return motion;
    }

    public Optional<class_2338> method_24832() {
        if (this.slidingPos.isEmpty() || !this.canClimbing()) {
            return super.method_24832();
        }
        return this.slidingPos;
    }

    public boolean method_6101() {
        return super.method_6101() || this.robandpeace$isClimbing();
    }

    @Unique
    private boolean canClimbing() {
        return this.method_5998(class_1268.field_5808).method_7909() == RapItems.INSTANCE.getSPIDER_WALKER() || this.method_5998(class_1268.field_5810).method_7909() == RapItems.INSTANCE.getSPIDER_WALKER();
    }

    @ModifyArg(method={"updatePose"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;setPose(Lnet/minecraft/entity/EntityPose;)V"))
    private class_4050 fixClimbingPose(class_4050 par1) {
        PlayerMovementPayload payload;
        if (this.canClimbing() && this.method_6101() && ((payload = this.robandpeace$getPlayerMovementPayload()) == null || !payload.isSneaking())) {
            this.method_5660(false);
            return class_4050.field_18076;
        }
        return par1;
    }

    @Inject(method={"jump"}, at={@At(value="RETURN")})
    private void expandDimensionsWhenJumping(CallbackInfo ci) {
        class_1657 player = (class_1657)this;
        player.method_18382();
    }

    @Inject(method={"getBaseDimensions"}, at={@At(value="HEAD")}, cancellable=true)
    private void keepStandingDimensionsIfPlayerClimbingOrJumpingWithCrouching(class_4050 pose, CallbackInfoReturnable<class_4048> cir) {
        if (pose == class_4050.field_18081 && this.canClimbing() && this.method_6101() || this.field_6282 && this.method_37908().method_8320(this.method_24515().method_10084()).method_26215()) {
            cir.setReturnValue((Object)field_18134.getOrDefault(class_4050.field_18076, field_18135));
        }
    }
}

