/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.blocks;

import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import net.asestefan.utils.ParticleUtils;
import net.asestefan.utils.SoundUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.teamabyssalofficial.registry.SoundRegistry;
import org.jetbrains.annotations.Nullable;

public class HealthPackBlock
extends Block
implements SimpleWaterloggedBlock,
SoundUtils {
    private static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape SHAPE_N = Stream.of(Block.m_49796_((double)3.16789, (double)0.025, (double)10.98284, (double)6.01789, (double)1.975, (double)12.98284), Block.m_49796_((double)5.0, (double)0.0, (double)2.0, (double)11.0, (double)2.0, (double)14.0), Block.m_49796_((double)3.0, (double)0.0, (double)4.0, (double)13.0, (double)1.99, (double)12.0), Block.m_49796_((double)4.0, (double)0.025, (double)1.575, (double)6.0, (double)1.975, (double)4.425), Block.m_49796_((double)10.29289, (double)0.025, (double)2.28211, (double)12.29289, (double)1.975, (double)5.13211), Block.m_49796_((double)9.99289, (double)0.025, (double)10.98211, (double)11.99289, (double)1.975, (double)13.83211)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape SHAPE_W = Stream.of(Block.m_49796_((double)7.167890000000001, (double)0.025, (double)11.639694249492383, (double)10.017890000000001, (double)1.975, (double)13.639694249492381), Block.m_49796_((double)2.0100499999999997, (double)0.0, (double)4.57573, (double)14.01005, (double)2.0, (double)10.57573), Block.m_49796_((double)4.01005, (double)0.0, (double)2.57573, (double)12.01005, (double)1.99, (double)12.57573), Block.m_49796_((double)1.521826382188539, (double)0.025, (double)5.157839641964376, (double)3.5218263821885376, (double)1.975, (double)8.007839641964376), Block.m_49796_((double)5.75368063168092, (double)0.025, (double)0.9259899445616364, (double)8.603680631680922, (double)1.975, (double)2.925989944561637), Block.m_49796_((double)12.242641662359851, (double)0.025, (double)6.564950975240565, (double)14.242641662359851, (double)1.975, (double)9.414950975240565)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape SHAPE_S = Stream.of(Block.m_49796_((double)12.649744249492382, (double)0.025, (double)5.557839999999999, (double)14.64974424949238, (double)1.975, (double)8.40784), Block.m_49796_((double)5.58578, (double)0.0, (double)1.5656800000000004, (double)11.58578, (double)2.0, (double)13.56568), Block.m_49796_((double)3.5857799999999997, (double)0.0, (double)3.5656800000000004, (double)13.58578, (double)1.99, (double)11.56568), Block.m_49796_((double)6.167889641964376, (double)0.025, (double)12.053903617811462, (double)9.017889641964375, (double)1.975, (double)14.05390361781146), Block.m_49796_((double)1.9360399445616352, (double)0.025, (double)6.9720493683190785, (double)3.936039944561637, (double)1.975, (double)9.82204936831908), Block.m_49796_((double)7.575000975240565, (double)0.025, (double)1.3330883376401488, (double)10.425000975240565, (double)1.975, (double)3.333088337640149)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape SHAPE_E = Stream.of(Block.m_49796_((double)6.5678899999999985, (double)0.025, (double)0.9259857505076194, (double)9.41789, (double)1.975, (double)2.9259857505076177), Block.m_49796_((double)2.57573, (double)0.0, (double)3.9899500000000003, (double)14.57573, (double)2.0, (double)9.98995), Block.m_49796_((double)4.57573, (double)0.0, (double)1.9899500000000003, (double)12.57573, (double)1.99, (double)11.98995), Block.m_49796_((double)13.063953617811462, (double)0.025, (double)6.557840358035625, (double)15.06395361781146, (double)1.975, (double)9.407840358035624), Block.m_49796_((double)7.982099368319078, (double)0.025, (double)11.639690055438363, (double)10.83209936831908, (double)1.975, (double)13.639690055438365), Block.m_49796_((double)2.3431383376401484, (double)0.025, (double)5.1507290247594355, (double)4.3431383376401484, (double)1.975, (double)8.000729024759435)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();

    public HealthPackBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties.m_60918_(SoundType.f_56742_).m_155954_(0.8f).m_60978_(0.8f).m_155956_(2.0f).m_60999_());
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    public void m_7892_(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
        if (pEntity instanceof Player) {
            Player pPlayer = (Player)pEntity;
            pPlayer.m_21153_(pPlayer.m_21233_());
            pPlayer.m_9236_().m_5594_(null, pPlayer.m_20183_(), (SoundEvent)SoundRegistry.HEALTH_PICKUP.get(), SoundSource.BLOCKS, this.getVolume() + 0.75f, this.getPitch(pPlayer.m_217043_()));
            if (pLevel instanceof ServerLevel) {
                ServerLevel world = (ServerLevel)pLevel;
                world.m_8767_((ParticleOptions)ParticleTypes.f_123750_, (double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_(), 9, 0.1, 0.2, 0.1, ParticleUtils.getDownwardsSmallSpread((RandomSource)pPlayer.m_217043_()));
            }
            pLevel.m_46961_(pPos, false);
        }
        super.m_7892_(pState, pLevel, pPos, pEntity);
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter world, BlockPos pos, Player player) {
        Item item = player.m_150109_().m_36056_().m_41720_();
        if (item instanceof PickaxeItem) {
            PickaxeItem tieredItem = (PickaxeItem)item;
            return tieredItem.m_43314_().m_6604_() >= 0;
        }
        return false;
    }

    public List<ItemStack> m_49635_(BlockState pState, LootParams.Builder pParams) {
        List dropsOriginal = super.m_49635_(pState, pParams);
        if (!dropsOriginal.isEmpty()) {
            return dropsOriginal;
        }
        return Collections.singletonList(new ItemStack((ItemLike)this, 1));
    }

    public BlockState m_7417_(BlockState value, Direction pDirection, BlockState blockState, LevelAccessor aVoid, BlockPos blockPos, BlockPos blockPos1) {
        if (pDirection.m_122424_() == value.m_61143_((Property)FACING) && !value.m_60710_((LevelReader)aVoid, blockPos)) {
            return Blocks.f_50016_.m_49966_();
        }
        if (((Boolean)value.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            aVoid.m_186469_(blockPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)aVoid));
        }
        return super.m_7417_(value, pDirection, blockState, aVoid, blockPos, blockPos1);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter p_54373_, BlockPos p_54374_, CollisionContext p_54375_) {
        switch ((Direction)state.m_61143_((Property)FACING)) {
            case NORTH: {
                return SHAPE_N;
            }
            case SOUTH: {
                return SHAPE_S;
            }
            case WEST: {
                return SHAPE_W;
            }
        }
        return SHAPE_E;
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext clickedFace) {
        return (BlockState)super.m_5573_(clickedFace).m_61124_((Property)FACING, (Comparable)clickedFace.m_8125_());
    }

    public BlockState m_6843_(BlockState pState, Rotation rotation) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING, WATERLOGGED});
    }

    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }
}

