/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.blocks.blockentity;

import java.util.List;
import mod.chloeprime.aaaparticles.api.common.AAALevel;
import mod.chloeprime.aaaparticles.api.common.ParticleEmitterInfo;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.teamabyssalofficial.blocks.scratch.TickableBlockEntity;
import net.teamabyssalofficial.entity.custom.PodInfectorEntity;
import net.teamabyssalofficial.registry.BlockEntityRegistry;
import net.teamabyssalofficial.registry.EffectRegistry;
import net.teamabyssalofficial.registry.EntityRegistry;
import net.teamabyssalofficial.registry.ParticleResourceRegistry;
import net.teamabyssalofficial.registry.SoundRegistry;
import net.teamabyssalofficial.util.PerformanceEngine;

public class FloodBigEggBlockEntity
extends BlockEntity
implements TickableBlockEntity {
    public boolean asReturn = false;

    public FloodBigEggBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegistry.FLOOD_BIG_EGG.get(), pos, state);
    }

    @Override
    public void tick() {
        if (this.f_58857_ == null || this.f_58857_.m_5776_()) {
            return;
        }
        if (this.asReturn) {
            this.f_58859_ = true;
            return;
        }
        if (!this.entitiesInRange().isEmpty()) {
            this.search();
        }
    }

    public List<LivingEntity> entitiesInRange() {
        if (this.f_58857_ == null) {
            return null;
        }
        float min = 2.0f;
        float max = 1.0f + min;
        double minSize = Mth.m_14154_((float)(min - 1.0f));
        double maxSize = Mth.m_14154_((float)(max + 1.0f));
        double areaSize = maxSize / minSize;
        double x = this.f_58858_.m_123341_();
        double y = this.f_58858_.m_123342_();
        double z = this.f_58858_.m_123343_();
        int minX = Mth.m_14107_((double)(x - areaSize - 1.0));
        int maxX = Mth.m_14107_((double)(x + areaSize + 1.0));
        int minY = Mth.m_14107_((double)(y - areaSize - 1.0));
        int maxY = Mth.m_14107_((double)(y + areaSize + 1.0));
        int minZ = Mth.m_14107_((double)(z - areaSize - 1.0));
        int maxZ = Mth.m_14107_((double)(z + areaSize + 1.0));
        AABB box = new AABB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
        List entities = this.f_58857_.m_45976_(LivingEntity.class, box);
        return entities;
    }

    public void search() {
        if (this.f_58857_ == null) {
            return;
        }
        List<LivingEntity> list = this.entitiesInRange();
        if (!list.isEmpty()) {
            for (LivingEntity living : list) {
                double dist;
                Player player;
                if (living instanceof Player && (player = (Player)living).m_7500_()) {
                    return;
                }
                if (EntityRegistry.FLOOD_FORMS.contains(living) || !((dist = Math.sqrt(living.m_20238_(this.f_58858_.m_252807_()))) <= (double)2.8f)) continue;
                this.releasePods(living);
            }
        }
    }

    public void releasePods(LivingEntity target) {
        if (this.f_58857_ == null) {
            return;
        }
        this.asReturn = true;
        this.f_58857_.m_46747_(this.f_58858_);
        this.f_58857_.m_7471_(this.f_58858_, false);
        RandomSource randomSource = this.f_58857_.m_213780_();
        int j = 1 + randomSource.m_188503_(3);
        for (int i = 0; i < j; ++i) {
            this.summonPod(target);
        }
        this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)SoundRegistry.HIVE_BLOCK_DESTROY.get(), SoundSource.BLOCKS, 1.6f, 1.0f);
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            if (!PerformanceEngine.hasPerformanceModeOn()) {
                double x = this.f_58858_.m_123341_();
                double y = this.f_58858_.m_123342_();
                double z = this.f_58858_.m_123343_();
                AAALevel.addParticle((Level)world, (boolean)true, (ParticleEmitterInfo)ParticleResourceRegistry.getTemporaryFloodSmoke().clone().scale(0.1f).position(x, y, z));
            }
        }
    }

    public void summonPod(LivingEntity target) {
        if (this.f_58857_ == null) {
            return;
        }
        PodInfectorEntity podInfectorEntity = new PodInfectorEntity((EntityType<? extends Monster>)((EntityType)EntityRegistry.POD_INFECTOR.get()), this.f_58857_);
        podInfectorEntity.m_20219_(this.f_58858_.m_252807_());
        this.f_58857_.m_7967_((Entity)podInfectorEntity);
        podInfectorEntity.m_5997_(this.f_58857_.f_46441_.m_188583_() * 0.25, 0.15f, this.f_58857_.f_46441_.m_188583_() * 0.25);
        podInfectorEntity.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.FROM_THE_SOURCE.get(), 200, 0));
        podInfectorEntity.m_6710_(target);
    }
}

