/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.client;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.teamabyssalofficial.client.special.model.ModelGeckoPlayerThirdPerson;
import net.teamabyssalofficial.client.special.player.GeckoPlayer;
import net.teamabyssalofficial.client.special.player.GeckoRenderPlayer;
import net.teamabyssalofficial.dotf.config.DawnOfTheFloodConfig;
import net.teamabyssalofficial.dotf.playerlib.AnimationAbilityCapability;
import net.teamabyssalofficial.dotf.playerlib.AnimationAbilityHandler;
import net.teamabyssalofficial.dotf.playerlib.AnimationCapabilityHandler;
import net.teamabyssalofficial.dotf.playerlib.PlayerAnimationCapability;

@OnlyIn(value=Dist.CLIENT)
public enum ClientEventInterface {
    INSTANCE;


    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void renderLivingEvent(RenderLivingEvent.Pre<? extends LivingEntity, ? extends EntityModel<? extends LivingEntity>> event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            GeckoPlayer.GeckoPlayerThirdPerson geckoPlayer;
            PlayerAnimationCapability.IPlayerCapability playerCapability;
            Player player = (Player)livingEntity;
            if (!((Boolean)DawnOfTheFloodConfig.SERVER.hasPlayerCustomAnimations.get()).booleanValue()) {
                return;
            }
            float delta = event.getPartialTick();
            AnimationAbilityCapability.IAbilityCapability abilityCapability = AnimationAbilityHandler.INSTANCE.getAbilityCapability((LivingEntity)player);
            if (abilityCapability != null && abilityCapability.getActiveAbility() != null && (playerCapability = AnimationCapabilityHandler.getCapability((Entity)event.getEntity(), AnimationCapabilityHandler.PLAYER_CAPABILITY)) != null && (geckoPlayer = playerCapability.getGeckoPlayer()) != null) {
                ModelGeckoPlayerThirdPerson geckoPlayerModel = (ModelGeckoPlayerThirdPerson)geckoPlayer.getModel();
                GeckoRenderPlayer animatedPlayerRenderer = (GeckoRenderPlayer)geckoPlayer.getPlayerRenderer();
                if (geckoPlayerModel != null && animatedPlayerRenderer != null) {
                    event.setCanceled(true);
                    if (event.isCanceled()) {
                        animatedPlayerRenderer.render((AbstractClientPlayer)event.getEntity(), event.getEntity().m_146908_(), delta, event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight(), geckoPlayer);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        GeckoPlayer.GeckoPlayerThirdPerson geckoPlayer;
        Player player;
        PlayerAnimationCapability.IPlayerCapability playerCapability;
        if (event.phase != TickEvent.Phase.START && event.player != null && (playerCapability = AnimationCapabilityHandler.getCapability((Entity)(player = event.player), AnimationCapabilityHandler.PLAYER_CAPABILITY)) != null && event.side == LogicalSide.CLIENT && (geckoPlayer = playerCapability.getGeckoPlayer()) != null) {
            geckoPlayer.tick();
        }
    }
}

