/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.client.layer;

import java.util.HashMap;
import javax.annotation.Nonnull;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.ItemArmorGeoLayer;

public class GeckoHumanoidArmorLayer<T extends LivingEntity>
extends ItemArmorGeoLayer<T> {
    private static final String armorHelmet = "ArmorHelmet";
    private static final String armorChestplate = "ArmorChestplate";
    private static final String armorLeftLeg = "ArmorLeftLeg";
    private static final String armorRightLeg = "ArmorRightLeg";
    private static final String armorLeftFoot = "ArmorLeftFoot";
    private static final String armorRightFoot = "ArmorRightFoot";
    public static final HashMap<String, Integer> geckoArmorPieces = new HashMap();

    public GeckoHumanoidArmorLayer(GeoRenderer<T> geoRenderer) {
        super(geoRenderer);
        geckoArmorPieces.put(armorHelmet, 3);
        geckoArmorPieces.put(armorChestplate, 2);
        geckoArmorPieces.put(armorLeftLeg, 1);
        geckoArmorPieces.put(armorRightLeg, 1);
        geckoArmorPieces.put(armorLeftFoot, 0);
        geckoArmorPieces.put(armorRightFoot, 0);
    }

    @Nullable
    protected ItemStack getArmorItemForBone(GeoBone bone, T animatable) {
        return switch (bone.getName()) {
            case armorLeftFoot, armorRightFoot -> this.bootsStack;
            case armorLeftLeg, armorRightLeg -> this.leggingsStack;
            case armorChestplate -> this.chestplateStack;
            case armorHelmet -> this.helmetStack;
            default -> null;
        };
    }

    @Nonnull
    protected EquipmentSlot getEquipmentSlotForBone(GeoBone bone, ItemStack stack, T animatable) {
        return switch (bone.getName()) {
            case armorLeftFoot, armorRightFoot -> EquipmentSlot.FEET;
            case armorLeftLeg, armorRightLeg -> EquipmentSlot.LEGS;
            case armorChestplate -> EquipmentSlot.CHEST;
            case armorHelmet -> EquipmentSlot.HEAD;
            default -> super.getEquipmentSlotForBone(bone, stack, animatable);
        };
    }

    @Nonnull
    protected ModelPart getModelPartForBone(GeoBone bone, EquipmentSlot slot, ItemStack stack, T animatable, HumanoidModel<?> baseModel) {
        return switch (bone.getName()) {
            case armorLeftFoot, armorLeftLeg -> baseModel.f_102814_;
            case armorRightFoot, armorRightLeg -> baseModel.f_102813_;
            case armorChestplate -> baseModel.f_102810_;
            case armorHelmet -> baseModel.f_102808_;
            default -> super.getModelPartForBone(bone, slot, stack, animatable, baseModel);
        };
    }

    protected Integer getArmorForSlot(String string) {
        return geckoArmorPieces.get(string);
    }
}

