/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.client.special.misc.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.teamabyssalofficial.client.ClientShaders;
import net.teamabyssalofficial.client.special.GeckoBedrockCurves;
import net.teamabyssalofficial.client.special.GeckoEasingCurves;
import net.teamabyssalofficial.client.special.GeckoRenderTypes;
import net.teamabyssalofficial.client.special.misc.model.TyrantProjectileModel;
import net.teamabyssalofficial.dotf.ClientProxy;
import net.teamabyssalofficial.entity.custom.special.TyrantProjectileEntity;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class TyrantProjectileRenderer
extends GeoEntityRenderer<TyrantProjectileEntity> {
    public TyrantProjectileRenderer(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn, (GeoModel)new TyrantProjectileModel());
        this.addRenderLayer(new TyrantProjectileLayerRenderer((GeoRenderer<TyrantProjectileEntity>)this));
        this.f_114477_ = 0.0f;
    }

    public void render(TyrantProjectileEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn) {
        poseStack.m_85836_();
        poseStack.m_85841_(2.8f, 2.8f, 2.8f);
        float YCurve = (float)GeckoEasingCurves.easeInSine(entity.f_19859_, entity.m_146908_(), partialTicks);
        float XCurve = (float)GeckoBedrockCurves.bezier(entity.f_19860_, entity.m_146909_(), partialTicks);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(YCurve - 90.0f));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(XCurve));
        super.m_7392_((Entity)entity, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
        poseStack.m_85849_();
    }

    public class TyrantProjectileLayerRenderer
    extends GeoRenderLayer<TyrantProjectileEntity> {
        private static final ResourceLocation TYRANT_PROJECTILE_GLOWY_PARTS = new ResourceLocation("dotf", "textures/mob/layer/tyrant_projectile_layer.png");

        public TyrantProjectileLayerRenderer(GeoRenderer<TyrantProjectileEntity> entityRendererIn) {
            super(entityRendererIn);
        }

        public ResourceLocation getLayer() {
            return TYRANT_PROJECTILE_GLOWY_PARTS;
        }

        public void render(PoseStack poseStack, TyrantProjectileEntity animatable, BakedGeoModel bakedModel, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
            ClientShaders.renderEffectForNextTick(ClientProxy.FLOOD_SHADER);
            RenderType type = GeckoRenderTypes.getFloodEmissive(this.getLayer());
            this.completeRendering(animatable, poseStack, bufferSource, renderType, type, partialTick, packedLight);
        }

        public void completeRendering(TyrantProjectileEntity animatable, PoseStack poseStack, MultiBufferSource bufferSource, RenderType renderType, RenderType customType, float partialTick, int packedLight) {
            this.getRenderer().reRender(this.getDefaultBakedModel((GeoAnimatable)animatable), poseStack, bufferSource, (GeoAnimatable)animatable, renderType, bufferSource.m_6299_(customType), partialTick, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }
}

