/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.teamabyssalofficial.dotf.config.DawnOfTheFloodConfig;
import net.teamabyssalofficial.entity.categories.BaseForm;
import net.teamabyssalofficial.registry.EntityRegistry;
import net.teamabyssalofficial.util.WorldDataUtils;

public class SpawnHordeCommand {
    public static void init() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> commandDispatcher) {
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"horde").requires(permission -> permission.m_6761_(3))).then(Commands.m_82127_((String)"spawn").executes(context -> SpawnHordeCommand.executeSpawn((CommandSourceStack)context.getSource()))));
    }

    public static int executeSpawn(CommandSourceStack source) {
        source.m_288197_(() -> Component.m_237113_((String)"Spawned a flood horde."), false);
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos(source.m_81371_().f_82479_, source.m_81371_().f_82480_, source.m_81371_().f_82481_);
        ServerLevel level = source.m_81372_();
        RandomSource random = source.m_81372_().m_213780_();
        int currentWave = WorldDataUtils.getWorldDataRegistry(level).getWave();
        int k1 = (Integer)DawnOfTheFloodConfig.SERVER.mobSpawnAttempts.get() + (Integer)DawnOfTheFloodConfig.SERVER.additionalHordeMobs.get() * ((currentWave - 1) / 2);
        for (int l1 = 0; l1 < k1; ++l1) {
            mutable.m_142448_(level.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (BlockPos)mutable).m_123342_());
            if (l1 == 0) {
                if (!SpawnHordeCommand.spawnHordeEntity((Level)level, (BlockPos)mutable, random, true)) {
                    break;
                }
            } else {
                SpawnHordeCommand.spawnHordeEntity((Level)level, (BlockPos)mutable, random, false);
            }
            mutable.m_142451_(mutable.m_123341_() + random.m_188503_(5) - random.m_188503_(5));
            mutable.m_142443_(mutable.m_123343_() + random.m_188503_(5) - random.m_188503_(5));
        }
        return 1;
    }

    private static boolean spawnHordeEntity(Level level, BlockPos blockPos, RandomSource randomSource, boolean b) {
        WorldDataUtils worldDataUtils = WorldDataUtils.getWorldDataRegistry((ServerLevel)level);
        BaseForm hordeEntity = switch (worldDataUtils.getWave()) {
            case 4, 5, 6 -> {
                int rand = randomSource.m_188503_(18);
                switch (rand) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        yield (BaseForm)((EntityType)EntityRegistry.HUMAN_FORM.get()).m_20615_(level);
                    }
                    case 5: 
                    case 6: 
                    case 7: {
                        yield (BaseForm)((EntityType)EntityRegistry.PLAYER_FORM.get()).m_20615_(level);
                    }
                    case 8: {
                        yield (BaseForm)((EntityType)EntityRegistry.SANGHEILI_FORM.get()).m_20615_(level);
                    }
                    case 9: 
                    case 10: {
                        yield (BaseForm)((EntityType)EntityRegistry.PILLAGER_FORM.get()).m_20615_(level);
                    }
                    case 11: 
                    case 12: {
                        yield (BaseForm)((EntityType)EntityRegistry.VINDICATOR_FORM.get()).m_20615_(level);
                    }
                    case 13: {
                        yield (BaseForm)((EntityType)EntityRegistry.EVOKER_FORM.get()).m_20615_(level);
                    }
                    case 14: 
                    case 15: {
                        yield (BaseForm)((EntityType)EntityRegistry.MARINE_FORM.get()).m_20615_(level);
                    }
                }
                yield (BaseForm)((EntityType)EntityRegistry.VILLAGER_FORM.get()).m_20615_(level);
            }
            default -> {
                int rand = randomSource.m_188503_(15);
                switch (rand) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        yield (BaseForm)((EntityType)EntityRegistry.HUMAN_FORM.get()).m_20615_(level);
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        yield (BaseForm)((EntityType)EntityRegistry.PLAYER_FORM.get()).m_20615_(level);
                    }
                    case 7: 
                    case 8: {
                        yield (BaseForm)((EntityType)EntityRegistry.PILLAGER_FORM.get()).m_20615_(level);
                    }
                    case 9: 
                    case 10: {
                        yield (BaseForm)((EntityType)EntityRegistry.VINDICATOR_FORM.get()).m_20615_(level);
                    }
                    case 11: {
                        yield (BaseForm)((EntityType)EntityRegistry.EVOKER_FORM.get()).m_20615_(level);
                    }
                    case 12: {
                        yield (BaseForm)((EntityType)EntityRegistry.MARINE_FORM.get()).m_20615_(level);
                    }
                }
                yield (BaseForm)((EntityType)EntityRegistry.VILLAGER_FORM.get()).m_20615_(level);
            }
        };
        if (hordeEntity != null) {
            if (b) {
                hordeEntity.setPatrolLeader(true);
                hordeEntity.findPatrolTarget();
            }
            hordeEntity.m_6034_(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_());
            hordeEntity.m_6518_((ServerLevelAccessor)((ServerLevel)level), level.m_6436_(blockPos), MobSpawnType.PATROL, null, null);
            ((ServerLevel)level).m_47205_((Entity)hordeEntity);
            return true;
        }
        return false;
    }
}

