/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.dotf;

import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.inventory.MenuType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.teamabyssalofficial.client.special.GeckoDawnFactory;
import net.teamabyssalofficial.crafting.WorkbenchIngredient;
import net.teamabyssalofficial.dotf.BiomeModification;
import net.teamabyssalofficial.dotf.ClientProxy;
import net.teamabyssalofficial.dotf.CommonProxy;
import net.teamabyssalofficial.dotf.LoadingPacket;
import net.teamabyssalofficial.dotf.StructureModification;
import net.teamabyssalofficial.dotf.config.DawnOfTheFloodConfig;
import net.teamabyssalofficial.dotf.playerlib.AnimationAbilityFactory;
import net.teamabyssalofficial.dotf.playerlib.AnimationCapabilityHandler;
import net.teamabyssalofficial.event.SpawnPlacementEvent;
import net.teamabyssalofficial.guns.gun.GunRegistry;
import net.teamabyssalofficial.guns.helper.KeybindHelper;
import net.teamabyssalofficial.network.ClientNetworkHandler;
import net.teamabyssalofficial.network.ServerNetworkHandler;
import net.teamabyssalofficial.registry.BannerPatternRegistry;
import net.teamabyssalofficial.registry.BlockEntityRegistry;
import net.teamabyssalofficial.registry.BlockRegistry;
import net.teamabyssalofficial.registry.ContainerRegistry;
import net.teamabyssalofficial.registry.CreativeTabRegistry;
import net.teamabyssalofficial.registry.EffectRegistry;
import net.teamabyssalofficial.registry.EntityRegistry;
import net.teamabyssalofficial.registry.ItemRegistry;
import net.teamabyssalofficial.registry.PaintingRegistry;
import net.teamabyssalofficial.registry.ParticleRegistry;
import net.teamabyssalofficial.registry.RecipeRegistry;
import net.teamabyssalofficial.registry.RecipeSerializersRegistry;
import net.teamabyssalofficial.registry.SoundRegistry;
import net.teamabyssalofficial.util.WorkbenchScreen;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import software.bernie.geckolib.GeckoLib;
import software.bernie.geckolib.loading.object.BakedModelFactory;
import software.bernie.geckolib.util.GeckoLibUtil;

@Mod(value="dotf")
public class DawnOfTheFlood {
    public static final String MODID = "dotf";
    public static final Logger LOGGER = LogManager.getLogger((String)"dotf");
    public static boolean isGeckoLibLoaded = false;
    public static boolean isClockworkLibLoaded = false;
    public static boolean isFabridgeLoaded = false;
    public static boolean isAAAParticlesLoaded = false;
    public static CommonProxy PROXY;

    public DawnOfTheFlood() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)DawnOfTheFloodConfig.DATAGEN_SPEC, "dotf_data.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)DawnOfTheFloodConfig.SERVER_SPEC, "dotf_config.toml");
        DawnOfTheFloodConfig.loadConfig(DawnOfTheFloodConfig.SERVER_SPEC, FMLPaths.CONFIGDIR.get().resolve("dotf_config.toml").toString());
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        MinecraftForge.EVENT_BUS.register((Object)this);
        ServerNetworkHandler.registerServerNetwork();
        GeckoLibUtil.addCustomBakedModelFactory((String)MODID, (BakedModelFactory)new GeckoDawnFactory());
        GeckoLib.initialize();
        PROXY = (CommonProxy)DistExecutor.unsafeRunForDist(() -> ClientProxy::new, () -> CommonProxy::new);
        PROXY.init(modEventBus);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(SpawnPlacementEvent::SpawnPlacement);
        modEventBus.addListener(AnimationCapabilityHandler::registerCapabilities);
        MinecraftForge.EVENT_BUS.register((Object)new AnimationAbilityFactory());
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.addGenericListener(Entity.class, AnimationCapabilityHandler::attachEntityCapability);
        EntityRegistry.register(modEventBus);
        ItemRegistry.register(modEventBus);
        GunRegistry.registerGuns(modEventBus);
        BlockRegistry.register(modEventBus);
        BlockEntityRegistry.register(modEventBus);
        SoundRegistry.register(modEventBus);
        EffectRegistry.register(modEventBus);
        ParticleRegistry.register(modEventBus);
        PaintingRegistry.register(modEventBus);
        CreativeTabRegistry.register(modEventBus);
        BannerPatternRegistry.register(modEventBus);
        ContainerRegistry.register(modEventBus);
        RecipeRegistry.register(modEventBus);
        RecipeSerializersRegistry.register(modEventBus);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> modEventBus.addListener(KeybindHelper::registerKeyMappings));
        DeferredRegister biomeModifiers = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)MODID);
        biomeModifiers.register(modEventBus);
        biomeModifiers.register("dotf_spawns", BiomeModification::makeCodec);
        DeferredRegister structureModifiers = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.STRUCTURE_MODIFIER_SERIALIZERS, (String)MODID);
        structureModifiers.register(modEventBus);
        structureModifiers.register("dotf_structure_spawns", StructureModification::makeCodec);
        isGeckoLibLoaded = ModList.get().isLoaded("geckolib");
        isClockworkLibLoaded = ModList.get().isLoaded("clockwork");
        isFabridgeLoaded = ModList.get().isLoaded("fabridge");
        isAAAParticlesLoaded = ModList.get().isLoaded("aaa_particles");
        new LoadingPacket().onInitialize();
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> CraftingHelper.register((ResourceLocation)new ResourceLocation(MODID, "workbench_ingredient"), (IIngredientSerializer)WorkbenchIngredient.Serializer.INSTANCE));
    }

    @Mod.EventBusSubscriber(modid="dotf", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            ClientNetworkHandler.registerClientNetwork();
            IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
            MenuScreens.m_96206_((MenuType)((MenuType)ContainerRegistry.GUN_WORKBENCH.get()), WorkbenchScreen::new);
        }
    }
}

