/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.dotf.playerlib;

import java.io.PrintStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.teamabyssalofficial.client.special.player.GeckoPlayer;
import net.teamabyssalofficial.dotf.playerlib.AnimationAbilityHandler;
import net.teamabyssalofficial.dotf.playerlib.AnimationAbilityType;
import net.teamabyssalofficial.dotf.playerlib.AnimationCapabilityHandler;
import net.teamabyssalofficial.dotf.playerlib.DOTFAbility;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.object.PlayState;

public class AnimationAbilityCapability {
    public static ResourceLocation ID = new ResourceLocation("dotf", "ability_cap");

    public static interface IAbilityCapability
    extends INBTSerializable<CompoundTag> {
        public void activateAbility(LivingEntity var1, AnimationAbilityType<?, ?> var2);

        public void instanceAbilities(LivingEntity var1);

        public void tick(LivingEntity var1);

        public AnimationAbilityType<?, ?>[] getAbilityTypesOnEntity(LivingEntity var1);

        public Map<AnimationAbilityType<?, ?>, DOTFAbility> getAbilityMap();

        public DOTFAbility getAbilityFromType(AnimationAbilityType<?, ?> var1);

        public Collection<DOTFAbility> getAbilities();

        public DOTFAbility getActiveAbility();

        public void setActiveAbility(DOTFAbility var1);

        public boolean attackingPrevented();

        public boolean blockBreakingBuildingPrevented();

        public boolean interactingPrevented();

        public boolean itemUsePrevented(ItemStack var1);

        public <E extends GeoEntity> PlayState animationPredicate(AnimationState<E> var1, GeckoPlayer.Perspective var2);

        public void codeAnimations(GeckoPlayer var1, float var2);
    }

    public static class AbilityCapabilityImp
    implements IAbilityCapability {
        SortedMap<AnimationAbilityType<?, ?>, DOTFAbility> abilityInstances = new TreeMap();
        DOTFAbility activeDOTFAbility = null;
        Map<String, Tag> nbtMap = new HashMap<String, Tag>();

        @Override
        public void instanceAbilities(LivingEntity entity) {
            this.setActiveAbility(null);
            for (AnimationAbilityType<?, ?> animationAbilityType : this.getAbilityTypesOnEntity(entity)) {
                Object DOTFAbility2 = animationAbilityType.makeInstance(entity);
                this.abilityInstances.put(animationAbilityType, (DOTFAbility)DOTFAbility2);
                if (!this.nbtMap.containsKey(animationAbilityType.getName())) continue;
                ((DOTFAbility)DOTFAbility2).readNBT(this.nbtMap.get(animationAbilityType.getName()));
            }
        }

        @Override
        public void activateAbility(LivingEntity entity, AnimationAbilityType<?, ?> animationAbilityType) {
            DOTFAbility DOTFAbility2 = (DOTFAbility)this.abilityInstances.get(animationAbilityType);
            if (DOTFAbility2 != null) {
                boolean tryResult = DOTFAbility2.tryAbility();
                if (tryResult) {
                    DOTFAbility2.start();
                }
            } else {
                PrintStream var10000 = System.out;
                String var10001 = animationAbilityType.toString();
                var10000.println("Ability " + var10001 + " does not exist on mob " + entity.getClass().getSimpleName());
            }
        }

        @Override
        public void tick(LivingEntity entity) {
            for (DOTFAbility DOTFAbility2 : this.abilityInstances.values()) {
                DOTFAbility2.tick();
            }
        }

        @Override
        public AnimationAbilityType<?, ?>[] getAbilityTypesOnEntity(LivingEntity entity) {
            return AnimationAbilityHandler.PLAYER_ABILITIES;
        }

        @Override
        public Map<AnimationAbilityType<?, ?>, DOTFAbility> getAbilityMap() {
            return this.abilityInstances;
        }

        @Override
        public DOTFAbility getAbilityFromType(AnimationAbilityType<?, ?> animationAbilityType) {
            return (DOTFAbility)this.abilityInstances.get(animationAbilityType);
        }

        @Override
        public DOTFAbility getActiveAbility() {
            return this.activeDOTFAbility;
        }

        @Override
        public void setActiveAbility(DOTFAbility activeDOTFAbility) {
            if (this.getActiveAbility() != null && this.getActiveAbility().isUsing()) {
                this.getActiveAbility().interrupt();
            }
            this.activeDOTFAbility = activeDOTFAbility;
        }

        @Override
        public Collection<DOTFAbility> getAbilities() {
            return this.abilityInstances.values();
        }

        @Override
        public boolean attackingPrevented() {
            return this.getActiveAbility() != null && this.getActiveAbility().preventsAttacking();
        }

        @Override
        public boolean blockBreakingBuildingPrevented() {
            return this.getActiveAbility() != null && this.getActiveAbility().preventsBlockBreakingBuilding();
        }

        @Override
        public boolean interactingPrevented() {
            return this.getActiveAbility() != null && this.getActiveAbility().preventsInteracting();
        }

        @Override
        public boolean itemUsePrevented(ItemStack itemStack) {
            return this.getActiveAbility() != null && this.getActiveAbility().preventsItemUse(itemStack);
        }

        @Override
        public <E extends GeoEntity> PlayState animationPredicate(AnimationState<E> e, GeckoPlayer.Perspective perspective) {
            return this.getActiveAbility().animationPredicate(e, perspective);
        }

        @Override
        public void codeAnimations(GeckoPlayer model, float partialTick) {
            this.getActiveAbility().codeAnimations(model, partialTick);
        }

        public CompoundTag serializeNBT() {
            CompoundTag compound = new CompoundTag();
            for (Map.Entry<AnimationAbilityType<?, ?>, DOTFAbility> abilityEntry : this.getAbilityMap().entrySet()) {
                CompoundTag nbt = abilityEntry.getValue().writeNBT();
                if (nbt.m_128456_()) continue;
                compound.m_128365_(abilityEntry.getKey().getName(), (Tag)nbt);
            }
            return compound;
        }

        public void deserializeNBT(CompoundTag nbt) {
            CompoundTag compound = nbt;
            Set keys = compound.m_128431_();
            for (String abilityName : keys) {
                this.nbtMap.put(abilityName, compound.m_128423_(abilityName));
            }
        }
    }

    public static class AbilityProvider
    implements ICapabilityProvider,
    ICapabilitySerializable<CompoundTag> {
        private final LazyOptional<IAbilityCapability> instance = LazyOptional.of(AbilityCapabilityImp::new);

        public CompoundTag serializeNBT() {
            return (CompoundTag)((IAbilityCapability)this.instance.orElseThrow(NullPointerException::new)).serializeNBT();
        }

        public void deserializeNBT(CompoundTag nbt) {
            ((IAbilityCapability)this.instance.orElseThrow(NullPointerException::new)).deserializeNBT((Tag)nbt);
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
            return AnimationCapabilityHandler.ABILITY_CAPABILITY.orEmpty(cap, this.instance.cast());
        }
    }
}

