/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.dotf.playerlib;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.teamabyssalofficial.dotf.playerlib.AnimationAbilityCapability;
import net.teamabyssalofficial.dotf.playerlib.AnimationAbilityHandler;
import net.teamabyssalofficial.dotf.playerlib.AnimationCapabilityHandler;
import net.teamabyssalofficial.dotf.playerlib.PlayerAnimationCapability;

public class AnimationAbilityFactory {
    @SubscribeEvent
    public void onJoinWorld(EntityJoinLevelEvent event) {
        PlayerAnimationCapability.IPlayerCapability playerCapability;
        AnimationAbilityCapability.IAbilityCapability abilityCapability;
        if (event.getEntity() instanceof Player && (abilityCapability = AnimationAbilityHandler.INSTANCE.getAbilityCapability((LivingEntity)event.getEntity())) != null) {
            abilityCapability.instanceAbilities((LivingEntity)event.getEntity());
        }
        if (event.getEntity() instanceof Player && (playerCapability = AnimationCapabilityHandler.getCapability(event.getEntity(), AnimationCapabilityHandler.PLAYER_CAPABILITY)) != null) {
            playerCapability.addedToWorld(event);
        }
    }

    @SubscribeEvent
    public void onJoinWorld(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        AnimationAbilityCapability.IAbilityCapability abilityCapability = AnimationCapabilityHandler.getCapability((Entity)entity, AnimationCapabilityHandler.ABILITY_CAPABILITY);
        if (abilityCapability != null) {
            abilityCapability.tick(event.getEntity());
        }
    }

    @SubscribeEvent
    public void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof LivingEntity) {
            event.addCapability(new ResourceLocation("dotf", "ability"), (ICapabilityProvider)new AnimationAbilityCapability.AbilityProvider());
        }
        if (event.getObject() instanceof Player) {
            event.addCapability(new ResourceLocation("dotf", "player"), (ICapabilityProvider)new PlayerAnimationCapability.PlayerProvider());
        }
    }
}

