/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.dotf.playerlib;

import javax.annotation.Nullable;
import net.fabridge.fabricmc.network.ClientPlayNetworking;
import net.fabridge.fabricmc.network.ServerPlayNetworking;
import net.fabridge.fabricmc.network.fabric.PacketByteBufs;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.teamabyssalofficial.dotf.playerlib.AnimationAbilityCapability;
import net.teamabyssalofficial.dotf.playerlib.AnimationAbilityType;
import net.teamabyssalofficial.dotf.playerlib.AnimationCapabilityHandler;
import net.teamabyssalofficial.dotf.playerlib.AnimationDOTFAbility;
import net.teamabyssalofficial.dotf.playerlib.DOTFAbility;
import net.teamabyssalofficial.dotf.playerlib.PlayerAnimationAbility;
import net.teamabyssalofficial.network.messages.ModMessages;
import org.apache.commons.lang3.ArrayUtils;

public enum AnimationAbilityHandler {
    INSTANCE;

    public static final AnimationAbilityType<Player, AnimationDOTFAbility> ENERGY_SWORD_SWING1;
    public static final AnimationAbilityType<Player, AnimationDOTFAbility> ENERGY_SWORD_SWING2;
    public static final AnimationAbilityType<Player, AnimationDOTFAbility> ENERGY_SWORD_SWING3;
    public static final AnimationAbilityType<Player, AnimationDOTFAbility> GRAVITY_HAMMER_RIGHT_HIT;
    public static final AnimationAbilityType<Player, AnimationDOTFAbility> GRAVITY_HAMMER_LEFT_HIT;
    public static final AnimationAbilityType<Player, AnimationDOTFAbility> GRAVITY_HAMMER_VERTICAL_HIT;
    public static final AnimationAbilityType<Player, AnimationDOTFAbility> GUN_RELOAD;
    public static final AnimationAbilityType<Player, AnimationDOTFAbility> GUN_MELEE1;
    public static final AnimationAbilityType<Player, AnimationDOTFAbility> GUN_MELEE2;
    public static final AnimationAbilityType<Player, AnimationDOTFAbility> GUN_MELEE3;
    public static final AnimationAbilityType<Player, AnimationDOTFAbility> GUN_FIRE;
    public static final AnimationAbilityType<Player, AnimationDOTFAbility> GUN_AIM_FIRE;
    public static final AnimationAbilityType<Player, AnimationDOTFAbility> GRENADE_THROW;
    public static final AnimationAbilityType<Player, ? extends PlayerAnimationAbility>[] PLAYER_ABILITIES;

    @Nullable
    public AnimationAbilityCapability.IAbilityCapability getAbilityCapability(LivingEntity entity) {
        return AnimationCapabilityHandler.getCapability((Entity)entity, AnimationCapabilityHandler.ABILITY_CAPABILITY);
    }

    @Nullable
    public DOTFAbility getAbility(LivingEntity entity, AnimationAbilityType<?, ?> animationAbilityType) {
        AnimationAbilityCapability.IAbilityCapability abilityCapability = this.getAbilityCapability(entity);
        return abilityCapability != null ? abilityCapability.getAbilityMap().get(animationAbilityType) : null;
    }

    public <T extends LivingEntity> void sendAbilityMessage(T entity, AnimationAbilityType<?, ?> animationAbilityType) {
        DOTFAbility instance;
        AnimationAbilityCapability.IAbilityCapability abilityCapability;
        if (!entity.m_9236_().f_46443_ && (abilityCapability = this.getAbilityCapability(entity)) != null && (instance = abilityCapability.getAbilityMap().get(animationAbilityType)) != null && instance.canUse()) {
            abilityCapability.activateAbility(entity, animationAbilityType);
            FriendlyByteBuf buf = PacketByteBufs.create();
            buf.writeInt(entity.m_19879_());
            buf.writeInt(ArrayUtils.indexOf((Object[])abilityCapability.getAbilityTypesOnEntity(entity), animationAbilityType));
            ServerPlayNetworking.send((ServerPlayer)((ServerPlayer)entity), (ResourceLocation)ModMessages.SEND_ABILITY_USE_ID, (FriendlyByteBuf)buf);
        }
    }

    public <T extends Player> void sendPlayerTryAbilityMessage(T entity, AnimationAbilityType<?, ?> ability) {
        AnimationAbilityCapability.IAbilityCapability abilityCapability;
        if (entity.m_9236_().f_46443_ && entity instanceof LocalPlayer && (abilityCapability = this.getAbilityCapability((LivingEntity)entity)) != null) {
            FriendlyByteBuf buf = PacketByteBufs.create();
            buf.writeInt(ArrayUtils.indexOf((Object[])abilityCapability.getAbilityTypesOnEntity((LivingEntity)entity), ability));
            ClientPlayNetworking.send((ResourceLocation)ModMessages.SEND_ABILITY_PLAYER_USE_ID, (FriendlyByteBuf)buf);
        }
    }

    static {
        ENERGY_SWORD_SWING1 = new AnimationAbilityType<LivingEntity, DOTFAbility>("energy_sword_swing1", (type, player) -> new AnimationDOTFAbility(type, (Player)player, "energy_sword_swing1", 20, true));
        ENERGY_SWORD_SWING2 = new AnimationAbilityType<LivingEntity, DOTFAbility>("energy_sword_swing2", (type, player) -> new AnimationDOTFAbility(type, (Player)player, "energy_sword_swing2", 20, true));
        ENERGY_SWORD_SWING3 = new AnimationAbilityType<LivingEntity, DOTFAbility>("energy_sword_swing3", (type, player) -> new AnimationDOTFAbility(type, (Player)player, "energy_sword_swing3", 19, true));
        GRAVITY_HAMMER_RIGHT_HIT = new AnimationAbilityType<LivingEntity, DOTFAbility>("grav_hammer_right_hit", (type, player) -> new AnimationDOTFAbility(type, (Player)player, "grav_hammer_right_hit", 33, true));
        GRAVITY_HAMMER_LEFT_HIT = new AnimationAbilityType<LivingEntity, DOTFAbility>("grav_hammer_left_hit", (type, player) -> new AnimationDOTFAbility(type, (Player)player, "grav_hammer_left_hit", 33, true));
        GRAVITY_HAMMER_VERTICAL_HIT = new AnimationAbilityType<LivingEntity, DOTFAbility>("grav_hammer_vertical_hit", (type, player) -> new AnimationDOTFAbility(type, (Player)player, "grav_hammer_vertical_hit", 29, true));
        GUN_RELOAD = new AnimationAbilityType<LivingEntity, DOTFAbility>("gun_reload", (type, player) -> new AnimationDOTFAbility(type, (Player)player, "gun_reload", 50, true));
        GUN_MELEE1 = new AnimationAbilityType<LivingEntity, DOTFAbility>("gun_melee1", (type, player) -> new AnimationDOTFAbility(type, (Player)player, "gun_melee1", 11, true));
        GUN_MELEE2 = new AnimationAbilityType<LivingEntity, DOTFAbility>("gun_melee2", (type, player) -> new AnimationDOTFAbility(type, (Player)player, "gun_melee2", 11, true));
        GUN_MELEE3 = new AnimationAbilityType<LivingEntity, DOTFAbility>("gun_melee3", (type, player) -> new AnimationDOTFAbility(type, (Player)player, "gun_melee3", 11, true));
        GUN_FIRE = new AnimationAbilityType<LivingEntity, DOTFAbility>("gun_fire", (type, player) -> new AnimationDOTFAbility(type, (Player)player, "gun_fire", 6, true));
        GUN_AIM_FIRE = new AnimationAbilityType<LivingEntity, DOTFAbility>("gun_aim_fire", (type, player) -> new AnimationDOTFAbility(type, (Player)player, "gun_aim_fire", 6, true));
        GRENADE_THROW = new AnimationAbilityType<LivingEntity, DOTFAbility>("grenade_throw", (type, player) -> new AnimationDOTFAbility(type, (Player)player, "grenade_throw", 20, true));
        PLAYER_ABILITIES = new AnimationAbilityType[]{ENERGY_SWORD_SWING1, ENERGY_SWORD_SWING2, ENERGY_SWORD_SWING3, GRAVITY_HAMMER_RIGHT_HIT, GRAVITY_HAMMER_LEFT_HIT, GRAVITY_HAMMER_VERTICAL_HIT, GUN_RELOAD, GUN_MELEE1, GUN_MELEE2, GUN_MELEE3, GUN_FIRE, GUN_AIM_FIRE, GRENADE_THROW};
    }
}

