/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.dotf.playerlib;

import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.teamabyssalofficial.client.special.player.GeckoPlayer;
import net.teamabyssalofficial.dotf.playerlib.AnimationCapabilityHandler;

public class PlayerAnimationCapability {
    public static ResourceLocation ID = new ResourceLocation("dotf", "player_cap");

    public static interface IPlayerCapability
    extends INBTSerializable<CompoundTag> {
        public void tick(TickEvent.PlayerTickEvent var1);

        public void addedToWorld(EntityJoinLevelEvent var1);

        @OnlyIn(value=Dist.CLIENT)
        public GeckoPlayer.GeckoPlayerThirdPerson getGeckoPlayer();
    }

    public static class PlayerCapabilityImp
    implements IPlayerCapability {
        @OnlyIn(value=Dist.CLIENT)
        private GeckoPlayer.GeckoPlayerThirdPerson geckoPlayer;

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public GeckoPlayer.GeckoPlayerThirdPerson getGeckoPlayer() {
            return this.geckoPlayer;
        }

        @Override
        public void addedToWorld(EntityJoinLevelEvent event) {
            if (event.getLevel().m_5776_()) {
                Player player = (Player)event.getEntity();
                this.geckoPlayer = new GeckoPlayer.GeckoPlayerThirdPerson(player);
            }
        }

        @Override
        public void tick(TickEvent.PlayerTickEvent event) {
        }

        public CompoundTag serializeNBT() {
            return new CompoundTag();
        }

        public void deserializeNBT(CompoundTag compound) {
        }
    }

    public static class PlayerProvider
    implements ICapabilityProvider,
    ICapabilitySerializable<CompoundTag> {
        private final LazyOptional<IPlayerCapability> instance = LazyOptional.of(PlayerCapabilityImp::new);

        public CompoundTag serializeNBT() {
            return (CompoundTag)((IPlayerCapability)this.instance.orElseThrow(NullPointerException::new)).serializeNBT();
        }

        public void deserializeNBT(CompoundTag nbt) {
            ((IPlayerCapability)this.instance.orElseThrow(NullPointerException::new)).deserializeNBT((Tag)nbt);
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
            return AnimationCapabilityHandler.PLAYER_CAPABILITY.orEmpty(cap, this.instance.cast());
        }
    }
}

