/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.entity.ai;

import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.level.Level;

public class FollowOthersGoal
extends Goal {
    private static TargetingConditions PARTNER_TARGETING;
    protected final Level level;
    protected final PathfinderMob mob;
    private final Class<? extends PathfinderMob> partnerClass;
    @Nullable
    protected PathfinderMob partner;
    private final double speedModifier;

    public FollowOthersGoal(PathfinderMob mob, double speedModifier) {
        this(mob, speedModifier, mob.getClass());
    }

    public FollowOthersGoal(PathfinderMob mob, double speedModifier, Class<? extends PathfinderMob> partnerClass) {
        this(mob, speedModifier, partnerClass, null);
    }

    public FollowOthersGoal(PathfinderMob mob, double speedModifier, Class<? extends PathfinderMob> partnerClass, @Nullable Predicate<LivingEntity> en) {
        this.level = mob.m_9236_();
        this.mob = mob;
        this.speedModifier = speedModifier;
        this.partnerClass = partnerClass;
        PARTNER_TARGETING = TargetingConditions.m_148353_().m_26883_(32.0).m_26888_(en);
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.mob.m_5448_() != null) {
            return false;
        }
        if (this.mob.m_217043_().m_188503_(15) == 0 && this.getFreePartner() == null) {
            return false;
        }
        if (this.mob.m_217043_().m_188503_(5) == 1) {
            this.partner = this.getFreePartner();
        }
        return this.partnerClass != null;
    }

    public boolean m_8045_() {
        if (this.partner != null) {
            return this.partner.m_6084_() || this.getFreePartner() != null;
        }
        return false;
    }

    public void m_8041_() {
        this.partner = null;
    }

    public void m_8037_() {
        if (this.partner != null) {
            this.mob.m_21573_().m_5624_((Entity)this.partner, this.speedModifier);
        }
    }

    @Nullable
    private PathfinderMob getFreePartner() {
        List list = this.level.m_45971_(this.partnerClass, PARTNER_TARGETING, (LivingEntity)this.mob, this.mob.m_20191_().m_82400_(this.mob.m_21172_(Attributes.f_22277_)));
        double d0 = Double.MAX_VALUE;
        PathfinderMob inf = null;
        for (PathfinderMob inf1 : list) {
            if (!(this.mob.m_20280_((Entity)inf1) < d0)) continue;
            inf = inf1;
            d0 = this.mob.m_20280_((Entity)inf1);
        }
        return inf;
    }
}

