/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.entity.ai;

import java.util.EnumSet;
import java.util.Optional;
import java.util.function.BiPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import net.teamabyssalofficial.entity.categories.BaseForm;
import org.jetbrains.annotations.Nullable;

public class ParkourGoal
extends Goal {
    protected final float maxJumpVelocity;
    private final BaseForm mob;
    private final BiPredicate<Mob, BlockPos> acceptableLandingSpot = ParkourGoal::defaultAcceptableLandingSpot;
    public JumpPhases phase;
    protected Optional<Vec3> initialPosition = Optional.empty();
    @Nullable
    protected Vec3 chosenJump;
    protected BlockPos posToJump;
    protected int findJumpTries;
    protected int failedToFindJumpCounter;
    protected long tryAgainTime;
    private int lookTime;

    public ParkourGoal(BaseForm mob) {
        this.mob = mob;
        this.maxJumpVelocity = 3.0f;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
    }

    public static <E extends Mob> boolean defaultAcceptableLandingSpot(E mob, BlockPos pos) {
        BlockPos blockpos = pos.m_7495_();
        return mob instanceof PathfinderMob && GoalUtils.m_148461_((PathfinderMob)((PathfinderMob)mob), (BlockPos)blockpos);
    }

    public boolean m_8036_() {
        if (this.mob.m_20096_()) {
            Path path = this.mob.m_21573_().m_26570_();
            return this.mob.m_5448_() != null && this.mob.m_21573_().m_26572_() && path != null && !path.m_77403_() && this.mob.m_9236_().m_46467_() - this.tryAgainTime > 30L;
        }
        return false;
    }

    public boolean m_8045_() {
        boolean flag = this.initialPosition.isPresent() && this.findJumpTries > 0 && !this.mob.m_20072_() && this.chosenJump != null && this.phase != JumpPhases.END;
        return flag && this.failedToFindJumpCounter <= 5;
    }

    public void m_8056_() {
        this.phase = JumpPhases.NONE;
        this.chosenJump = null;
        this.findJumpTries = 150;
        this.initialPosition = Optional.of(this.mob.m_20182_());
        if (this.mob.m_21573_().m_26567_() != null) {
            Vec3 pos = Vec3.m_82512_((Vec3i)this.mob.m_21573_().m_26567_());
            this.mob.m_21563_().m_24950_(pos.f_82479_, this.mob.m_20188_(), pos.f_82481_, 90.0f, 90.0f);
            this.mob.m_146922_(this.mob.m_6080_());
            this.pickCandidate((Mob)this.mob, this.mob.m_21573_().m_26567_());
        }
    }

    public void m_8037_() {
        if (this.phase == JumpPhases.LOOK_AT_BLOCK) {
            if (this.lookTime > 0) {
                --this.lookTime;
            }
            if (this.posToJump != null) {
                Vec3 pos = Vec3.m_82512_((Vec3i)this.posToJump);
                this.lookAt(pos, 30.0f, 30.0f);
                this.mob.m_5618_(this.mob.f_20885_);
            }
            if (this.lookTime <= 0) {
                this.phase = JumpPhases.JUMP;
            }
        } else if (this.phase == JumpPhases.JUMP) {
            if (this.chosenJump != null) {
                this.leapTowards((LivingEntity)this.mob, this.mob.m_20182_().m_82549_(this.chosenJump), this.chosenJump.m_82553_(), 0.0);
                this.mob.m_21569_().m_24901_();
                this.phase = JumpPhases.END;
            }
        } else {
            --this.findJumpTries;
        }
    }

    public void lookAt(Vec3 vec3, float pMaxYRotIncrease, float pMaxXRotIncrease) {
        double d0 = vec3.m_7096_() - this.mob.m_20185_();
        double d2 = vec3.m_7094_() - this.mob.m_20189_();
        double d1 = vec3.m_7098_() - this.mob.m_20188_();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
        float f1 = (float)(-(Mth.m_14136_((double)d1, (double)d3) * 57.2957763671875));
        this.mob.m_146926_(this.rotlerp(this.mob.m_146909_(), f1, pMaxXRotIncrease));
        this.mob.m_146922_(this.rotlerp(this.mob.m_146908_(), f, pMaxYRotIncrease));
    }

    private float rotlerp(float pAngle, float pTargetAngle, float pMaxIncrease) {
        float f = Mth.m_14177_((float)(pTargetAngle - pAngle));
        if (f > pMaxIncrease) {
            f = pMaxIncrease;
        }
        if (f < -pMaxIncrease) {
            f = -pMaxIncrease;
        }
        return pAngle + f;
    }

    public void m_8041_() {
        this.phase = JumpPhases.END;
        this.tryAgainTime = this.mob.m_9236_().m_46467_();
        this.failedToFindJumpCounter = 0;
    }

    protected void pickCandidate(Mob pEntity, BlockPos block) {
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)pEntity.m_20183_(), (BlockPos)block)) {
            BlockPos jumpPos;
            BlockPos blockPos = jumpPos = pEntity.m_20183_().m_123314_((Vec3i)pos, 3.0) ? pos : block;
            if (this.isAcceptableLandingPosition(pEntity, jumpPos)) {
                Vec3 vec3 = Vec3.m_82512_((Vec3i)jumpPos);
                Vec3 vec31 = this.calculateJumpVector(pEntity, vec3);
                if (vec31 == null) continue;
                this.lookAt(vec3, 30.0f, 30.0f);
                this.mob.m_5618_(this.mob.f_20885_);
                this.posToJump = jumpPos;
                this.chosenJump = vec31;
                if (this.phase != JumpPhases.NONE) continue;
                this.lookTime = 5;
                this.phase = JumpPhases.LOOK_AT_BLOCK;
                continue;
            }
            ++this.failedToFindJumpCounter;
        }
    }

    private boolean isAcceptableLandingPosition(Mob pEntity, BlockPos pPos) {
        BlockPos blockpos = pEntity.m_20183_();
        int i = blockpos.m_123341_();
        int j = blockpos.m_123343_();
        return (i != pPos.m_123341_() || j != pPos.m_123343_()) && this.acceptableLandingSpot.test(pEntity, pPos);
    }

    @Nullable
    private Vec3 calculateJumpVector(Mob pMob, Vec3 pTarget) {
        Vec3 vec3 = this.mob.m_20184_();
        Vec3 vec31 = new Vec3(pTarget.m_7096_() - pMob.m_20185_(), (double)this.maxJumpVelocity, pTarget.m_7094_() - pMob.m_20189_());
        if (vec31.m_82556_() > 1.0E-7) {
            vec31 = vec31.m_82541_().m_82490_(0.5).m_82549_(vec3.m_82490_(1.5));
        }
        return vec31;
    }

    private void leapTowards(LivingEntity entity, Vec3 target, double horzVel, double yVel) {
        Vec3 dir = target.m_82546_(entity.m_20182_()).m_82541_();
        Vec3 leap = new Vec3(dir.f_82479_, 0.0, dir.f_82481_).m_82541_().m_82490_(horzVel).m_82524_((float)yVel);
        float clampedYVelocity = (float)(entity.m_20184_().m_7098_() < 0.1 ? leap.f_82480_ : 0.0);
        Vec3 horzVelocity = entity.m_20184_().m_82520_(leap.f_82479_, 0.0, leap.f_82481_);
        double scale = horzVel / horzVelocity.m_82553_();
        if (scale < 1.0) {
            horzVelocity = horzVelocity.m_82490_(scale);
        }
        ((Mob)entity).m_21563_().m_24964_(target);
        entity.m_20256_(horzVelocity.m_82524_(clampedYVelocity));
    }

    public boolean m_183429_() {
        return true;
    }

    public static enum JumpPhases {
        NONE,
        LOOK_AT_BLOCK,
        JUMP,
        END;

    }
}

