/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.entity.custom;

import javax.annotation.Nullable;
import mod.chloeprime.aaaparticles.api.common.AAALevel;
import mod.chloeprime.aaaparticles.api.common.ParticleEmitterInfo;
import net.asestefan.utils.ParticleUtils;
import net.asestefan.utils.SoundUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidType;
import net.teamabyssalofficial.dotf.config.DawnOfTheFloodConfig;
import net.teamabyssalofficial.entity.ai.EscapeFromVehicleGoal;
import net.teamabyssalofficial.entity.custom.PodInfectorEntity;
import net.teamabyssalofficial.impl.StackScaler;
import net.teamabyssalofficial.registry.EntityRegistry;
import net.teamabyssalofficial.registry.ParticleRegistry;
import net.teamabyssalofficial.registry.ParticleResourceRegistry;
import net.teamabyssalofficial.util.PerformanceEngine;
import net.teamabyssalofficial.util.WorldDataUtils;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class FloodTadpoleEntity
extends WaterAnimal
implements GeoEntity,
SoundUtils {
    private static final EntityDataAccessor<Integer> AGE = SynchedEntityData.m_135353_(FloodTadpoleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> STACK_SCALE = SynchedEntityData.m_135353_(FloodTadpoleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public final StackScaler stackScaler = new StackScaler(1.0f, 1.0f, 1.0f);

    public FloodTadpoleEntity(EntityType<? extends WaterAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 20.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, -2.0f);
        this.f_21364_ = 0;
        this.f_21342_ = new FloodTadpoleControl(this);
        EntityRegistry.FLOOD_FORMS.add((Entity)this);
    }

    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(AGE, (Object)0);
        this.f_19804_.m_135372_(STACK_SCALE, (Object)Float.valueOf(0.0f));
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("Age", this.getAge());
        pCompound.m_128350_("stackScale", this.stackScale());
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setAge(pCompound.m_128451_("Age"));
        this.setStackScale(pCompound.m_128457_("stackScale"));
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        return false;
    }

    public int m_20146_() {
        return super.m_6062_();
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    protected void m_6229_(int pAirSupply) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22276_, ((Double)DawnOfTheFloodConfig.SERVER.flood_tadpole_health.get()).doubleValue()).m_22268_(Attributes.f_22282_, 0.0).m_22268_(Attributes.f_22278_, 0.0).m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22283_, 0.5);
    }

    public int getAge() {
        return (Integer)this.f_19804_.m_135370_(AGE);
    }

    public void setAge(int age) {
        this.f_19804_.m_135381_(AGE, (Object)age);
    }

    public float stackScale() {
        return ((Float)this.f_19804_.m_135370_(STACK_SCALE)).floatValue();
    }

    public void setStackScale(float pScale) {
        this.f_19804_.m_135381_(STACK_SCALE, (Object)Float.valueOf(pScale));
    }

    public void randomizeScale(float pFactor) {
        float scalingMul = this.f_19796_.m_188501_() / pFactor;
        this.setStackScale(this.stackScale() + scalingMul);
    }

    protected PathNavigation m_6037_(Level pLevel) {
        return new WaterBoundPathNavigation((Mob)this, pLevel);
    }

    public void m_7023_(Vec3 pTravelVector) {
        if (this.m_21515_() && this.m_20069_()) {
            this.m_19920_(0.01f, pTravelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            if (this.m_5448_() == null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
            }
        } else {
            super.m_7023_(pTravelVector);
        }
    }

    public static boolean checkFloodTadpoleSpawnRules(EntityType<? extends WaterAnimal> pWaterAnimal, ServerLevelAccessor levelAccessor, MobSpawnType pSpawnType, BlockPos pPos, RandomSource pRandom) {
        int $$5 = levelAccessor.m_5736_();
        int $$6 = $$5 - 13;
        WorldDataUtils worldDataUtils = WorldDataUtils.getWorldDataRegistry(levelAccessor.m_6018_());
        int currentWave = worldDataUtils.getWave();
        return pPos.m_123342_() >= $$6 && pPos.m_123342_() <= $$5 && levelAccessor.m_6425_(pPos.m_7495_()).m_205070_(FluidTags.f_13131_) && levelAccessor.m_8055_(pPos.m_7494_()).m_60713_(Blocks.f_49990_) && currentWave > 0 && currentWave < 4;
    }

    public void m_8119_() {
        super.m_8119_();
        this.setAge(this.getAge() + 1);
        int finalTicks = (Integer)DawnOfTheFloodConfig.SERVER.flood_tadpole_to_pod_infector_age.get() + this.f_19796_.m_188503_(600);
        if (this.getAge() == finalTicks) {
            this.turnToPod((Entity)this);
        }
    }

    private void turnToPod(Entity entity) {
        PodInfectorEntity podInfectorEntity = new PodInfectorEntity((EntityType<? extends Monster>)((EntityType)EntityRegistry.POD_INFECTOR.get()), entity.m_9236_());
        podInfectorEntity.m_6027_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
        podInfectorEntity.m_146926_(entity.m_146909_());
        podInfectorEntity.m_146922_(entity.m_146908_());
        podInfectorEntity.m_5618_(this.f_20883_);
        podInfectorEntity.m_5616_(this.f_20885_);
        podInfectorEntity.m_6593_(entity.m_7770_());
        podInfectorEntity.m_21563_().m_24964_(entity.m_20154_());
        Level level = entity.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            if (!PerformanceEngine.hasPerformanceModeOn()) {
                AAALevel.addParticle((Level)world, (boolean)true, (ParticleEmitterInfo)ParticleResourceRegistry.getTemporaryFloodSmoke().clone().scale(0.1f).position(this.m_20208_(0.25), this.m_20188_() + 0.2, this.m_20262_(0.25)));
            }
            world.m_8767_((ParticleOptions)((SimpleParticleType)ParticleRegistry.FLOOD_BLOOD_SPLASH.get()), this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), PerformanceEngine.getParticleCount(75), 0.2, 0.8, 0.4, ParticleUtils.getDownwardsMediumSpread((RandomSource)this.f_19796_));
            world.m_8767_((ParticleOptions)((SimpleParticleType)ParticleRegistry.GUTS.get()), this.m_20208_(0.5), this.m_20187_() + 0.35, this.m_20262_(0.65), PerformanceEngine.getParticleCount(35), 0.1, 0.2, 0.1, ParticleUtils.getDownwardsSmallSpread((RandomSource)this.f_19796_));
        }
        entity.m_9236_().m_5594_(null, entity.m_20183_(), SoundEvents.f_12609_, SoundSource.HOSTILE, this.getVolume() + 0.25f, this.getPitch(this.f_19796_));
        entity.m_9236_().m_7967_((Entity)podInfectorEntity);
        entity.m_146870_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(0, (Goal)new PanicGoal((PathfinderMob)this, 1.65));
        this.f_21345_.m_25352_(4, (Goal)new FloodTadpoleSwimGoal(this));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[]{PodInfectorEntity.class}));
        this.f_21345_.m_25352_(4, (Goal)new EscapeFromVehicleGoal((Mob)this));
        this.f_21345_.m_25352_(9, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 16.0f, 3.0, 3.0));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerTadpole) {
        controllerTadpole.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controllerTadpole", 7, event -> {
            if (event.isMoving() && this.m_20069_()) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("flood_tadpole.swim"));
            }
            if (!event.isMoving() && !this.m_5912_()) {
                event.getController().setAnimationSpeed(1.2);
                return event.setAndContinue(RawAnimation.begin().thenLoop("flood_tadpole.idle"));
            }
            return PlayState.CONTINUE;
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    protected SoundEvent m_5501_() {
        return SoundEvents.f_11938_;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        this.randomizeScale(2.75f);
        this.stackScaler.randomizeScale(this.f_19796_, 2.0f);
        return super.m_6518_(pLevel, pDifficulty, pReason, spawnGroupData, compoundTag);
    }

    public boolean canSwim() {
        return true;
    }

    private static class FloodTadpoleControl
    extends MoveControl {
        private final FloodTadpoleEntity tadpoleEntity;

        FloodTadpoleControl(FloodTadpoleEntity pTadpole) {
            super((Mob)pTadpole);
            this.tadpoleEntity = pTadpole;
        }

        public void m_8126_() {
            if (this.tadpoleEntity.m_204029_(FluidTags.f_13131_)) {
                this.tadpoleEntity.m_20256_(this.tadpoleEntity.m_20184_().m_82520_(0.0, 0.005, 0.0));
            }
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !this.tadpoleEntity.m_21573_().m_26571_()) {
                float $$0 = (float)(this.f_24978_ * this.tadpoleEntity.m_21133_(Attributes.f_22279_));
                this.tadpoleEntity.m_7910_(Mth.m_14179_((float)0.125f, (float)this.tadpoleEntity.m_6113_(), (float)$$0));
                double $$1 = this.f_24975_ - this.tadpoleEntity.m_20185_();
                double $$2 = this.f_24976_ - this.tadpoleEntity.m_20186_();
                double $$3 = this.f_24977_ - this.tadpoleEntity.m_20189_();
                if ($$2 != 0.0) {
                    double $$4 = Math.sqrt($$1 * $$1 + $$2 * $$2 + $$3 * $$3);
                    this.tadpoleEntity.m_20256_(this.tadpoleEntity.m_20184_().m_82520_(0.0, (double)this.tadpoleEntity.m_6113_() * ($$2 / $$4) * 0.1, 0.0));
                }
                if ($$1 != 0.0 || $$3 != 0.0) {
                    float $$5 = (float)(Mth.m_14136_((double)$$3, (double)$$1) * 57.2957763671875) - 90.0f;
                    this.tadpoleEntity.m_146922_(this.m_24991_(this.tadpoleEntity.m_146908_(), $$5, 90.0f));
                    this.tadpoleEntity.f_20883_ = this.tadpoleEntity.m_146908_();
                }
            } else {
                this.tadpoleEntity.m_7910_(0.0f);
            }
        }
    }

    private static class FloodTadpoleSwimGoal
    extends RandomSwimmingGoal {
        private final FloodTadpoleEntity floodTadpoleEntity;

        public FloodTadpoleSwimGoal(FloodTadpoleEntity floodTadpoleEntity) {
            super((PathfinderMob)floodTadpoleEntity, 2.0, 40);
            this.floodTadpoleEntity = floodTadpoleEntity;
        }

        public boolean m_8036_() {
            return this.floodTadpoleEntity.canSwim() && super.m_8036_();
        }
    }
}

