/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.entity.custom;

import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import mod.chloeprime.aaaparticles.api.common.AAALevel;
import mod.chloeprime.aaaparticles.api.common.ParticleEmitterInfo;
import net.asestefan.screenshake.ScreenShakeUtils;
import net.asestefan.utils.ParticleUtils;
import net.asestefan.utils.SoundUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.teamabyssalofficial.dotf.config.DawnOfTheFloodConfig;
import net.teamabyssalofficial.dotf.datagen.tags.GenericBlockTags;
import net.teamabyssalofficial.entity.ai.EscapeFromVehicleGoal;
import net.teamabyssalofficial.entity.ai.FastSwimmingDiveGoal;
import net.teamabyssalofficial.entity.ai.OpenFenceGateGoal;
import net.teamabyssalofficial.entity.ai.TargetCropsGoal;
import net.teamabyssalofficial.entity.categories.BaseForm;
import net.teamabyssalofficial.entity.custom.PillagerFormEntity;
import net.teamabyssalofficial.entity.custom.PlayerFormEntity;
import net.teamabyssalofficial.entity.custom.PodInfectorEntity;
import net.teamabyssalofficial.entity.custom.UnarmedFloodedGolemEntity;
import net.teamabyssalofficial.entity.custom.special.CovenantOrsShipEntity;
import net.teamabyssalofficial.entity.custom.special.IronAxeEntity;
import net.teamabyssalofficial.guns.bullet.AbstractBullet;
import net.teamabyssalofficial.impl.StackScaler;
import net.teamabyssalofficial.registry.DamageTypeRegistry;
import net.teamabyssalofficial.registry.EntityRegistry;
import net.teamabyssalofficial.registry.ParticleRegistry;
import net.teamabyssalofficial.registry.ParticleResourceRegistry;
import net.teamabyssalofficial.registry.SoundRegistry;
import net.teamabyssalofficial.util.BlockUtils;
import net.teamabyssalofficial.util.PerformanceEngine;
import net.teamabyssalofficial.util.SoundPacket;
import net.teamabyssalofficial.util.WorldDataUtils;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class FloodedGolemEntity
extends Monster
implements GeoEntity,
SoundUtils {
    private static final EntityDataAccessor<Boolean> TRANSFORMED = SynchedEntityData.m_135353_(FloodedGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> AGGRO_TICKS = SynchedEntityData.m_135353_(FloodedGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SPAWN_TIMER = SynchedEntityData.m_135353_(FloodedGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> IS_ARMED = SynchedEntityData.m_135353_(FloodedGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DISCARD = SynchedEntityData.m_135353_(FloodedGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> ARMOR_LAYER = SynchedEntityData.m_135353_(FloodedGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> STACK_SCALE = SynchedEntityData.m_135353_(FloodedGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public final StackScaler stackScaler = new StackScaler(1.0f, 1.0f, 1.0f);
    public int attacktick;
    public int attackID;
    public boolean isImmobile = false;
    public static final byte ATTACK = 1;
    public static final byte PUNCH_ATTACK = 2;
    public static final int ATTACK_LENGTH = 23;
    public static final int PUNCH_ATTACK_LENGTH = 45;
    public static final int SPAWN_TICKS = 140;

    public FloodedGolemEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 32.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, -1.6f);
        this.m_274367_(1.75f);
        this.f_21364_ = 30;
        EntityRegistry.FLOOD_FORMS.add((Entity)this);
    }

    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(AGGRO_TICKS, (Object)0);
        this.f_19804_.m_135372_(SPAWN_TIMER, (Object)140);
        this.f_19804_.m_135372_(TRANSFORMED, (Object)false);
        this.f_19804_.m_135372_(DISCARD, (Object)false);
        this.f_19804_.m_135372_(IS_ARMED, (Object)false);
        this.f_19804_.m_135372_(ARMOR_LAYER, (Object)1);
        this.f_19804_.m_135372_(STACK_SCALE, (Object)Float.valueOf(0.0f));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22279_, 0.23).m_22268_(Attributes.f_22276_, ((Double)DawnOfTheFloodConfig.SERVER.flooded_golem_health.get()).doubleValue()).m_22268_(Attributes.f_22281_, ((Double)DawnOfTheFloodConfig.SERVER.flooded_golem_damage.get()).doubleValue()).m_22268_(Attributes.f_22282_, 0.75).m_22268_(Attributes.f_22283_, 1.85).m_22268_(Attributes.f_22278_, 5.25).m_22268_(Attributes.f_22285_, 8.0).m_22268_(Attributes.f_22284_, ((Double)DawnOfTheFloodConfig.SERVER.flooded_golem_armor.get()).doubleValue());
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("aggroTicks", this.getAggroTicks());
        pCompound.m_128405_("spawnTimer", this.getSpawnTimer());
        pCompound.m_128379_("isArmed", this.isArmed());
        pCompound.m_128379_("transformed", this.isTransformed());
        pCompound.m_128379_("discard", this.shouldDiscard());
        pCompound.m_128405_("armorLayer", this.getArmorLayer());
        pCompound.m_128350_("stackScale", this.stackScale());
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setAggroTicks(pCompound.m_128451_("aggroTicks"));
        this.setSpawnTimer(pCompound.m_128451_("spawnTimer"));
        this.setIsArmed(pCompound.m_128471_("isArmed"));
        this.setTransformed(pCompound.m_128471_("transformed"));
        this.willDiscard(pCompound.m_128471_("discard"));
        this.setArmorLayer(pCompound.m_128451_("armorLayer"));
        this.setStackScale(pCompound.m_128457_("stackScale"));
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false));
        this.f_21345_.m_25352_(5, (Goal)new FastSwimmingDiveGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8){

            public boolean m_8036_() {
                return super.m_8036_() && this.f_25725_.m_5448_() == null;
            }

            public boolean m_8045_() {
                return super.m_8045_() && this.f_25725_.m_5448_() == null;
            }
        });
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, true, this::targetPredicate));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[]{BaseForm.class}));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[]{PodInfectorEntity.class}));
        this.f_21345_.m_25352_(0, (Goal)new FloodedGolemMeleeAttackGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new FloodedGolemPunchAttackGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new TargetCropsGoal((PathfinderMob)this, 1.2, 32));
        this.f_21345_.m_25352_(4, (Goal)new EscapeFromVehicleGoal((Mob)this));
        this.f_21345_.m_25352_(6, (Goal)new OpenFenceGateGoal((Mob)this, true));
        this.f_21345_.m_25352_(6, (Goal)new OpenDoorGoal((Mob)this, true){

            public void m_8056_() {
                this.f_25189_.m_6674_(InteractionHand.MAIN_HAND);
                super.m_8056_();
            }
        });
    }

    private boolean targetPredicate(LivingEntity liv) {
        return !EntityRegistry.FLOOD_FORMS.contains(liv) && !(liv instanceof CovenantOrsShipEntity) && !(liv instanceof Squid) && !(liv instanceof ArmorStand) && !(liv instanceof AbstractFish) && !(liv instanceof Bat) && !((List)DawnOfTheFloodConfig.SERVER.blacklist.get()).contains(liv.m_20078_());
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerV) {
        controllerV.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller1", 7, event -> {
            if (this.getSpawnTimer() > 0 && this.isTransformed()) {
                return event.setAndContinue(RawAnimation.begin().thenPlay("flooded.golem.transform"));
            }
            if (!event.isMoving() && !this.m_5912_() && this.attackID == 0) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("flooded.golem.idle"));
            }
            if (event.isMoving() && !this.m_5912_() && this.attackID == 0) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("flooded.golem.walk"));
            }
            if (event.isMoving() && this.m_5912_() && this.attackID == 0) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("flooded.golem.target"));
            }
            if (this.attackID == 1) {
                return event.setAndContinue(RawAnimation.begin().thenPlayAndHold("flooded.golem.attack_target"));
            }
            if (this.attackID == 2) {
                return event.setAndContinue(RawAnimation.begin().thenPlayAndHold("flooded.golem.attack"));
            }
            return PlayState.CONTINUE;
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void setAttackID(int id) {
        this.attackID = id;
        this.attacktick = 0;
        this.m_9236_().m_7605_((Entity)this, (byte)(-id));
    }

    public void m_7822_(byte id) {
        if (id <= 0) {
            this.attackID = Math.abs(id);
            this.attacktick = 0;
        } else {
            super.m_7822_(id);
        }
    }

    public int getAggroTicks() {
        return (Integer)this.f_19804_.m_135370_(AGGRO_TICKS);
    }

    public void setAggroTicks(int ticks) {
        this.f_19804_.m_135381_(AGGRO_TICKS, (Object)ticks);
    }

    public int getSpawnTimer() {
        return (Integer)this.f_19804_.m_135370_(SPAWN_TIMER);
    }

    public void setSpawnTimer(int ticks) {
        this.f_19804_.m_135381_(SPAWN_TIMER, (Object)ticks);
    }

    public boolean isTransformed() {
        return (Boolean)this.f_19804_.m_135370_(TRANSFORMED);
    }

    public void setTransformed(boolean value) {
        this.f_19804_.m_135381_(TRANSFORMED, (Object)value);
    }

    public boolean isArmed() {
        return (Boolean)this.f_19804_.m_135370_(IS_ARMED);
    }

    public void setIsArmed(boolean value) {
        this.f_19804_.m_135381_(IS_ARMED, (Object)value);
    }

    public boolean shouldDiscard() {
        return (Boolean)this.f_19804_.m_135370_(DISCARD);
    }

    public void willDiscard(boolean value) {
        this.f_19804_.m_135381_(DISCARD, (Object)value);
    }

    public int getArmorLayer() {
        return (Integer)this.f_19804_.m_135370_(ARMOR_LAYER);
    }

    public void setArmorLayer(int layer) {
        this.f_19804_.m_135381_(ARMOR_LAYER, (Object)layer);
    }

    public float stackScale() {
        return ((Float)this.f_19804_.m_135370_(STACK_SCALE)).floatValue();
    }

    public void setStackScale(float pScale) {
        this.f_19804_.m_135381_(STACK_SCALE, (Object)Float.valueOf(pScale));
    }

    public void randomizeScale(float pFactor) {
        float scalingMul = this.f_19796_.m_188501_() / pFactor;
        this.setStackScale(this.stackScale() + scalingMul);
    }

    protected void m_8024_() {
        if (this.getSpawnTimer() > 0) {
            this.setSpawnTimer(this.getSpawnTimer() - 1);
        }
        super.m_8024_();
    }

    public boolean m_7327_(Entity pEntity) {
        if (!this.m_9236_().f_46443_ && this.attackID == 0) {
            this.attackID = this.f_19796_.m_188503_(4) != 0 ? 1 : 2;
        }
        return true;
    }

    public void m_8107_() {
        super.m_8107_();
        LivingEntity attackTarget = this.m_5448_();
        if (this.m_6084_() && attackTarget != null && this.m_142582_((Entity)attackTarget) && this.m_20270_((Entity)attackTarget) <= 10.0f && ((Boolean)DawnOfTheFloodConfig.SERVER.flooded_golem_breaks_blocks.get()).booleanValue()) {
            SoundPacket soundPacket = new SoundPacket((SoundEvent)SoundRegistry.ENTITY_FORM_IDLE.get(), SoundSource.HOSTILE, this.getVolume(), this.getPitch(this.f_19796_) - 0.45f);
            BlockUtils.destroyBlocks(this.m_9236_(), (LivingEntity)this, 0.2f, this.getDestroySpeed(), 50, soundPacket);
        }
    }

    public int getDestroySpeed() {
        return 2;
    }

    public static boolean checkFloodedGolemRules(EntityType<? extends FloodedGolemEntity> entityType, ServerLevelAccessor levelAccessor, MobSpawnType mobSpawnType, BlockPos pos, RandomSource source) {
        WorldDataUtils worldDataUtils = WorldDataUtils.getWorldDataRegistry(levelAccessor.m_6018_());
        int currentWave = worldDataUtils.getWave();
        return levelAccessor.m_46791_() != Difficulty.PEACEFUL && FloodedGolemEntity.m_219009_((ServerLevelAccessor)levelAccessor, (BlockPos)pos, (RandomSource)source) && FloodedGolemEntity.m_217057_(entityType, (LevelAccessor)levelAccessor, (MobSpawnType)mobSpawnType, (BlockPos)pos, (RandomSource)source) && currentWave > 4;
    }

    public int getSubtractionPoints() {
        return 1200;
    }

    public float getPitch(RandomSource random) {
        return 0.75f;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return SoundEvents.f_12008_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12059_;
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        super.m_7355_(pos, blockIn);
        this.m_5496_((SoundEvent)SoundRegistry.ENTITY_FORM_STEP.get(), this.getVolume() * 0.85f, this.getPitch(this.f_19796_) * 0.55f);
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        Arrow arrow;
        if (this.getArmorLayer() < 5) {
            this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)SoundRegistry.FLOODED_GOLEM_ARMOR_HIT.get(), SoundSource.HOSTILE, this.getVolume(), this.getPitch(this.f_19796_));
        } else {
            this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)SoundRegistry.FLOODED_GOLEM_BIOMASS_HIT.get(), SoundSource.HOSTILE, this.getVolume(), this.getPitch(this.f_19796_));
        }
        Entity entity = pSource.m_7640_();
        if (entity instanceof Arrow && ((arrow = (Arrow)entity).m_19749_() instanceof PlayerFormEntity || arrow.m_19749_() instanceof PillagerFormEntity)) {
            return false;
        }
        if (pSource.m_7640_() instanceof AbstractBullet) {
            return false;
        }
        if (pSource.m_7640_() instanceof IronAxeEntity) {
            return false;
        }
        return super.m_6469_(pSource, pAmount);
    }

    public void m_6667_(DamageSource source) {
        this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)SoundRegistry.FLOODED_GOLEM_BIOMASS_REVEAL.get(), SoundSource.HOSTILE, this.getVolume() + 0.25f, this.getPitch(this.f_19796_) - 0.25f);
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            WorldDataUtils worldDataUtils = WorldDataUtils.getWorldDataRegistry(world);
            int currentScore = worldDataUtils.getScore();
            int currentWave = worldDataUtils.getWave();
            if (currentWave > 4) {
                worldDataUtils.setScore(currentScore - this.getSubtractionPoints());
            }
        }
        if (Math.random() <= (double)0.2f && !this.isArmed() && ((Boolean)DawnOfTheFloodConfig.SERVER.unarmed_flooded_golem_spawn.get()).booleanValue()) {
            this.dropShell((Entity)this);
            this.vanish();
            this.setIsArmed(true);
            this.willDiscard(true);
        } else {
            this.willDiscard(false);
        }
        super.m_6667_(source);
    }

    protected void m_6153_() {
        super.m_6153_();
        ++this.f_20919_;
        if (this.f_20919_ == 1 && this.shouldDiscard()) {
            this.m_146870_();
        } else if (this.f_20919_ == 30 && !this.shouldDiscard()) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    private void dropShell(Entity entity) {
        UnarmedFloodedGolemEntity unarmedFloodedGolemEntity = new UnarmedFloodedGolemEntity((EntityType<? extends Monster>)((EntityType)EntityRegistry.UNARMED_FLOODED_GOLEM.get()), entity.m_9236_());
        unarmedFloodedGolemEntity.m_6027_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
        unarmedFloodedGolemEntity.m_146926_(entity.m_146909_());
        unarmedFloodedGolemEntity.m_146922_(entity.m_146908_());
        unarmedFloodedGolemEntity.m_5618_(this.f_20883_);
        unarmedFloodedGolemEntity.m_5616_(this.f_20885_);
        unarmedFloodedGolemEntity.m_21563_().m_24964_(entity.m_20154_());
        unarmedFloodedGolemEntity.m_6593_(entity.m_7770_());
        unarmedFloodedGolemEntity.stackScaler.setpX(this.stackScaler.getpX());
        unarmedFloodedGolemEntity.stackScaler.setpY(this.stackScaler.getpY());
        unarmedFloodedGolemEntity.stackScaler.setpZ(this.stackScaler.getpZ());
        unarmedFloodedGolemEntity.setStackScale(this.stackScale());
        entity.m_9236_().m_7967_((Entity)unarmedFloodedGolemEntity);
    }

    private void vanish() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            if (!PerformanceEngine.hasPerformanceModeOn()) {
                AAALevel.addParticle((Level)world, (boolean)true, (ParticleEmitterInfo)ParticleResourceRegistry.getTemporaryFloodSmoke().clone().scale(0.15f).position(this.m_20208_(0.25), this.m_20188_() + 0.2, this.m_20262_(0.25)));
            }
            world.m_8767_((ParticleOptions)((SimpleParticleType)ParticleRegistry.GUTS.get()), this.m_20208_(0.5), this.m_20187_() + 0.35, this.m_20262_(0.65), PerformanceEngine.getParticleCount(35), 0.1, 0.2, 0.1, ParticleUtils.getDownwardsSmallSpread((RandomSource)this.f_19796_));
            world.m_8767_((ParticleOptions)ParticleTypes.f_123813_, this.m_20208_(0.25), this.m_20187_() + 0.25, this.m_20262_(0.25), PerformanceEngine.getParticleCount(6), 0.1, 0.2, 0.1, 0.01);
        }
        this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_12609_, SoundSource.HOSTILE, 1.25f, 0.95f);
        this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)SoundRegistry.BODY_REMOVED.get(), SoundSource.HOSTILE, 1.05f, 0.65f);
        AABB aabb = this.m_20191_().m_82400_(0.5);
        for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
            BlockUtils.generateBlood(this.m_9236_(), blockpos);
        }
    }

    public double getMovementSpeed() {
        return 0.23;
    }

    public DamageSource getDamage() {
        List<DamageSource> damageSources = List.of(DamageTypeRegistry.form_melee_damage1((LivingEntity)this), DamageTypeRegistry.form_melee_damage2((LivingEntity)this), DamageTypeRegistry.form_melee_damage3((LivingEntity)this), DamageTypeRegistry.form_melee_damage4((LivingEntity)this), DamageTypeRegistry.form_melee_damage5((LivingEntity)this), DamageTypeRegistry.form_melee_damage6((LivingEntity)this), DamageTypeRegistry.form_melee_damage7((LivingEntity)this), DamageTypeRegistry.form_melee_damage8((LivingEntity)this));
        int length = damageSources.size();
        return damageSources.get(this.f_19796_.m_188503_(length));
    }

    private double getSweepingRange() {
        return 1.6021963705062867;
    }

    private void sweep(Entity pEntity) {
        AABB boundingBox = this.m_20191_().m_82400_(this.getSweepingRange());
        List entities = this.m_9236_().m_45933_((Entity)this, boundingBox);
        for (Entity entity : entities) {
            LivingEntity livingEntity;
            if (!(entity instanceof LivingEntity) || !this.targetPredicate(livingEntity = (LivingEntity)entity) || livingEntity == pEntity) continue;
            float dist = this.m_20270_((Entity)livingEntity);
            livingEntity.m_6469_(this.getDamage(), (float)this.m_21133_(Attributes.f_22281_) * (1.0f / dist) * 0.75f);
            livingEntity.m_9236_().m_5594_(null, livingEntity.m_20183_(), SoundEvents.f_12317_, SoundSource.HOSTILE, this.getVolume(), this.getPitch(this.f_19796_) - 0.45f);
        }
    }

    public void destroySwingable(boolean moveBlocks) {
        AABB aabb = this.m_20191_().m_82400_((double)0.35f);
        for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
            BlockState blockstate = this.m_9236_().m_8055_(blockpos);
            if (!blockstate.m_204336_(BlockTags.f_13104_) && !blockstate.m_204336_(BlockTags.f_13073_) && !blockstate.m_204336_(BlockTags.f_13035_) && !blockstate.m_204336_(GenericBlockTags.Blocks.SWINGABLE) && (!(blockstate.m_60800_((BlockGetter)this.m_9236_(), blockpos) < (float)(this.getDestroySpeed() + 1)) || !((double)blockpos.m_123342_() > this.m_20186_()))) continue;
            this.m_9236_().m_46953_(blockpos, false, (Entity)this);
            if (!moveBlocks) continue;
            BlockUtils.moveTrembleBlocks(this.m_9236_(), 3, (LivingEntity)this, (double)0.15f, (double)0.15f, (double)0.15f, false);
        }
    }

    private void summonFloodParticle() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            server.m_8767_((ParticleOptions)((SimpleParticleType)ParticleRegistry.FLOOD_BLOOD_SPLASH.get()), this.m_20208_(0.25), this.m_20187_() + 0.25, this.m_20262_(0.25), 3, 0.1, 0.2, 0.1, ParticleUtils.getDownwardsSmallSpread((RandomSource)this.f_19796_));
        }
    }

    public boolean canRegenerate() {
        return !this.m_6060_();
    }

    public void m_8119_() {
        float f;
        super.m_8119_();
        if (this.m_20096_() && !this.isInFluidType() && this.f_267362_.m_267731_() > 0.1f && ((Boolean)DawnOfTheFloodConfig.SERVER.flooded_golem_tremble_walk.get()).booleanValue() && (double)Math.abs(f = (float)Math.cos(this.f_267362_.m_267756_() * 0.8f - 1.5f)) < 0.2) {
            if (PerformanceEngine.canPerformShake((LivingEntity)this, this.m_9236_(), 8.0)) {
                ScreenShakeUtils.ScreenShake((Level)this.m_9236_(), (Vec3)this.m_20182_(), (float)PerformanceEngine.getShakeRadius(8), (float)0.012f, (int)3, (int)2);
            }
            this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_12010_, SoundSource.HOSTILE, this.getVolume() * 1.25f, this.getPitch(this.f_19796_) * 0.75f);
        }
        if (this.m_5448_() != null && ((Boolean)DawnOfTheFloodConfig.SERVER.flooded_golem_aggro_despawn.get()).booleanValue()) {
            this.setAggroTicks(this.getAggroTicks() + 1);
        }
        if (!this.m_9236_().f_46443_) {
            this.m_21195_(MobEffects.f_19614_);
        }
        if (this.attackID == 2) {
            Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22100_(0.0);
        } else {
            Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22100_(this.getMovementSpeed());
        }
        if (this.isImmobile) {
            Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22100_(0.0);
        } else {
            Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22100_(this.getMovementSpeed());
        }
        if (this.getSpawnTimer() > 0 && this.isTransformed() && !this.isImmobile) {
            this.isImmobile = true;
            Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22100_(0.0);
        }
        if (this.getSpawnTimer() == 0 && this.isTransformed() && this.isImmobile) {
            this.isImmobile = false;
            Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22100_(this.getMovementSpeed());
        }
        if (this.getSpawnTimer() == 135 && this.isTransformed()) {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)SoundRegistry.ENTITY_FORM_SPAWN.get(), this.m_5720_(), this.getVolume(), this.getPitch(this.f_19796_) - 0.55f);
        }
        if (this.getSpawnTimer() == 95 && this.isTransformed()) {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)SoundRegistry.ENTITY_FORM_ROAR.get(), this.m_5720_(), this.getVolume(), this.getPitch(this.f_19796_) - 0.85f);
            if (((Boolean)DawnOfTheFloodConfig.SERVER.flooded_golem_screen_shake.get()).booleanValue() && PerformanceEngine.canPerformShake((LivingEntity)this, this.m_9236_(), 8.0)) {
                ScreenShakeUtils.ScreenShake((Level)this.m_9236_(), (Vec3)this.m_20182_(), (float)PerformanceEngine.getShakeRadius(8), (float)0.19f, (int)50, (int)10);
            }
        }
        if (this.getSpawnTimer() > 0 && this.isTransformed()) {
            this.summonFloodParticle();
        }
        if (this.m_21223_() <= this.m_21233_() * 0.65f) {
            this.setArmorLayer(2);
        }
        if (this.m_21223_() <= this.m_21233_() * 0.55f) {
            this.setArmorLayer(3);
        }
        if (this.m_21223_() <= this.m_21233_() * 0.45f) {
            this.setArmorLayer(4);
        }
        if (this.m_21223_() <= this.m_21233_() * 0.35f) {
            this.setArmorLayer(5);
        }
        Objects.requireNonNull(this.m_21051_(Attributes.f_22284_)).m_22100_((Double)DawnOfTheFloodConfig.SERVER.flooded_golem_armor.get() / (double)this.getArmorLayer());
        if (this.attackID != 0) {
            this.f_20883_ = this.f_20885_;
            this.m_146922_(this.f_20883_);
            ++this.attacktick;
            if (this.m_5448_() != null) {
                this.m_21563_().m_24960_((Entity)this.m_5448_(), 30.0f, 90.0f);
            }
        }
        if (this.canRegenerate() && ((Boolean)DawnOfTheFloodConfig.SERVER.flooded_golem_regeneration.get()).booleanValue() && this.m_217043_().m_188503_(350) == 0 && (double)this.m_21223_() < (double)this.m_21233_() - 2.5) {
            this.m_5634_(2.5f);
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        this.randomizeScale(3.25f);
        this.stackScaler.randomizeScale(this.f_19796_, 2.2f);
        return super.m_6518_(pLevel, pDifficulty, pReason, spawnGroupData, compoundTag);
    }

    public boolean m_6785_(double pDistanceToClosestPlayer) {
        return pDistanceToClosestPlayer > 16384.0 || this.getAggroTicks() < (Integer)DawnOfTheFloodConfig.SERVER.flooded_golem_aggro_ticks.get();
    }

    class FloodedGolemMeleeAttackGoal
    extends Goal {
        private final FloodedGolemEntity floodedGolemEntity;
        private LivingEntity attackTarget;

        public FloodedGolemMeleeAttackGoal(FloodedGolemEntity floodedGolemEntity) {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.floodedGolemEntity = floodedGolemEntity;
        }

        public boolean m_8036_() {
            this.attackTarget = this.floodedGolemEntity.m_5448_();
            return this.attackTarget != null && this.floodedGolemEntity.attackID == 1 && !FloodedGolemEntity.this.isImmobile;
        }

        public void m_8056_() {
            this.floodedGolemEntity.setAttackID(1);
        }

        public void m_8041_() {
            this.floodedGolemEntity.setAttackID(0);
            this.attackTarget = null;
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8045_() {
            return this.floodedGolemEntity.attacktick < 23;
        }

        public void m_8037_() {
            if (FloodedGolemEntity.this.attacktick == 12) {
                float f1 = (float)Math.cos(Math.toRadians(FloodedGolemEntity.this.m_146908_() + 90.0f));
                float f2 = (float)Math.sin(Math.toRadians(FloodedGolemEntity.this.m_146908_() + 90.0f));
                FloodedGolemEntity.this.m_5997_((double)f1 * 0.1, 0.0, (double)f2 * 0.1);
            }
            if (FloodedGolemEntity.this.attacktick == 18) {
                float volume = 1.25f;
                float pitch = 0.15f;
                this.floodedGolemEntity.m_9236_().m_5594_(null, this.floodedGolemEntity.m_20183_(), (SoundEvent)SoundRegistry.ENTITY_SWING.get(), SoundSource.HOSTILE, volume, pitch);
            }
            if (FloodedGolemEntity.this.attacktick == 22) {
                FloodedGolemEntity.this.destroySwingable(false);
                FloodedGolemEntity.this.sweep((Entity)this.attackTarget);
                if (FloodedGolemEntity.this.m_20270_((Entity)this.attackTarget) <= 3.5f) {
                    Player player;
                    LivingEntity livingEntity;
                    this.attackTarget.m_6469_(FloodedGolemEntity.this.getDamage(), (float)FloodedGolemEntity.this.m_21133_(Attributes.f_22281_) * 0.75f);
                    if (this.attackTarget.m_6084_() && (livingEntity = this.attackTarget) instanceof Player && (player = (Player)livingEntity).m_21254_()) {
                        player.m_36384_(true);
                    }
                }
            }
            FloodedGolemEntity.this.m_21573_().m_26569_();
        }
    }

    class FloodedGolemPunchAttackGoal
    extends Goal {
        private final FloodedGolemEntity floodedGolemEntity;
        private LivingEntity attackTarget;

        public FloodedGolemPunchAttackGoal(FloodedGolemEntity floodedGolemEntity) {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.floodedGolemEntity = floodedGolemEntity;
        }

        public boolean m_8036_() {
            this.attackTarget = this.floodedGolemEntity.m_5448_();
            return this.attackTarget != null && this.floodedGolemEntity.attackID == 2 && !FloodedGolemEntity.this.isImmobile;
        }

        public void m_8056_() {
            this.floodedGolemEntity.setAttackID(2);
            Objects.requireNonNull(this.floodedGolemEntity.m_21051_(Attributes.f_22279_)).m_22100_(0.0);
        }

        public void m_8041_() {
            this.floodedGolemEntity.setAttackID(0);
            this.attackTarget = null;
            Objects.requireNonNull(this.floodedGolemEntity.m_21051_(Attributes.f_22279_)).m_22100_(this.floodedGolemEntity.getMovementSpeed());
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8045_() {
            return this.floodedGolemEntity.attacktick < 45;
        }

        public void m_8037_() {
            if (FloodedGolemEntity.this.attacktick == 15) {
                float f1 = (float)Math.cos(Math.toRadians(FloodedGolemEntity.this.m_146908_() + 90.0f));
                float f2 = (float)Math.sin(Math.toRadians(FloodedGolemEntity.this.m_146908_() + 90.0f));
                FloodedGolemEntity.this.m_5997_((double)f1 * 0.4, 0.0, (double)f2 * 0.4);
            }
            if (FloodedGolemEntity.this.attacktick == 21) {
                float volume = 1.25f;
                float pitch = 0.15f;
                this.floodedGolemEntity.m_9236_().m_5594_(null, this.floodedGolemEntity.m_20183_(), (SoundEvent)SoundRegistry.ENTITY_SWING.get(), SoundSource.HOSTILE, volume, pitch);
            }
            if (FloodedGolemEntity.this.attacktick == 24) {
                FloodedGolemEntity.this.destroySwingable(true);
                FloodedGolemEntity.this.sweep((Entity)this.attackTarget);
                if (FloodedGolemEntity.this.m_20270_((Entity)this.attackTarget) <= 3.75f) {
                    Player player;
                    LivingEntity livingEntity;
                    this.attackTarget.m_6469_(FloodedGolemEntity.this.getDamage(), (float)FloodedGolemEntity.this.m_21133_(Attributes.f_22281_));
                    if (this.attackTarget.m_6084_() && (livingEntity = this.attackTarget) instanceof Player && (player = (Player)livingEntity).m_21254_()) {
                        player.m_36384_(true);
                    }
                }
            }
            FloodedGolemEntity.this.m_21573_().m_26569_();
        }
    }
}

