/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.entity.custom;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.asestefan.utils.SoundUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.network.NetworkHooks;
import net.teamabyssalofficial.dotf.config.DawnOfTheFloodConfig;
import net.teamabyssalofficial.dotf.datagen.tags.GenericBlockTags;
import net.teamabyssalofficial.entity.ai.CustomMeleeAttackGoal;
import net.teamabyssalofficial.entity.ai.EscapeFromVehicleGoal;
import net.teamabyssalofficial.entity.categories.BaseForm;
import net.teamabyssalofficial.entity.custom.PillagerFormEntity;
import net.teamabyssalofficial.entity.custom.PlayerFormEntity;
import net.teamabyssalofficial.entity.custom.PodInfectorEntity;
import net.teamabyssalofficial.entity.custom.special.CovenantOrsShipEntity;
import net.teamabyssalofficial.entity.custom.special.IronAxeEntity;
import net.teamabyssalofficial.entity.custom.special.MawClawEntity;
import net.teamabyssalofficial.guns.bullet.AbstractBullet;
import net.teamabyssalofficial.impl.ReentrantBoolean;
import net.teamabyssalofficial.impl.StackScaler;
import net.teamabyssalofficial.registry.DamageTypeRegistry;
import net.teamabyssalofficial.registry.EffectRegistry;
import net.teamabyssalofficial.registry.EntityRegistry;
import net.teamabyssalofficial.registry.SoundRegistry;
import net.teamabyssalofficial.util.WorldDataUtils;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class MawFormEntity
extends Monster
implements GeoEntity,
SoundUtils {
    private static final EntityDataAccessor<Integer> BURROW_PROGRESS = SynchedEntityData.m_135353_(MawFormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> STACK_SCALE = SynchedEntityData.m_135353_(MawFormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public int attacktick;
    public int attackID;
    public static final byte ATTACK = 1;
    public static final int BURROW_TIME = 500;
    public static final int UNDERGROUND_TIME = 100;
    public static final int EMERGE_TIME = 90;
    private static final int BURROW_COOLDOWN = 900;
    private static final int MAW_ATTACK_LENGTH = 30;
    private int burrowCooldown = 0;
    private int burrowX = 0;
    private int burrowY = 0;
    private int burrowZ = 0;
    private int cooldownTick = 0;
    public int prevClientBurrowProgress = 0;
    public int clientBurrowProgress = 0;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public final StackScaler stackScaler = new StackScaler(1.0f, 1.0f, 1.0f);
    public final ReentrantBoolean canPlayAppearSound = new ReentrantBoolean(true);
    public final ReentrantBoolean digSoundLock = new ReentrantBoolean(false);

    public MawFormEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 16.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, -1.6f);
        this.f_21364_ = 25;
        this.m_274367_(0.0f);
        EntityRegistry.FLOOD_FORMS.add((Entity)this);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerV) {
        controllerV.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controllerV", 7, event -> {
            if (this.isBurrowing() || this.isEmerging()) {
                return event.setAndContinue(RawAnimation.begin().thenPlay("maw_form.dig"));
            }
            if (!(event.isMoving() || this.isBurrowing() || this.isEmerging() || this.isUnderground() || this.attackID != 0)) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("maw_form.idle"));
            }
            if (this.attackID == 1) {
                return event.setAndContinue(RawAnimation.begin().thenPlayAndHold("maw_form.slam"));
            }
            return PlayState.CONTINUE;
        })});
    }

    public boolean m_7337_(Entity pEntity) {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    protected void m_7324_(Entity entity) {
    }

    protected float m_6118_() {
        return 0.0f;
    }

    public boolean m_6785_(double pDistanceToClosestPlayer) {
        return false;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BURROW_PROGRESS, (Object)0);
        this.f_19804_.m_135372_(STACK_SCALE, (Object)Float.valueOf(0.0f));
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_("burrowProgress", this.getBurrowProgress());
        nbt.m_128350_("stackScale", this.stackScale());
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setBurrowProgress(nbt.m_128451_("burrowProgress"));
        this.setStackScale(nbt.m_128457_("stackScale"));
    }

    public int getBurrowProgress() {
        return (Integer)this.f_19804_.m_135370_(BURROW_PROGRESS);
    }

    public void setBurrowProgress(int burrowProgress) {
        this.f_19804_.m_135381_(BURROW_PROGRESS, (Object)burrowProgress);
    }

    public boolean isBurrowing() {
        return this.getBurrowProgress() != 0 && this.getBurrowProgress() < 500;
    }

    public boolean isUnderground() {
        return this.getBurrowProgress() >= 500 && this.getBurrowProgress() <= 600;
    }

    public boolean isEmerging() {
        return this.getBurrowProgress() > 600;
    }

    public float stackScale() {
        return ((Float)this.f_19804_.m_135370_(STACK_SCALE)).floatValue();
    }

    public void setStackScale(float pScale) {
        this.f_19804_.m_135381_(STACK_SCALE, (Object)Float.valueOf(pScale));
    }

    public void randomizeScale(float pFactor) {
        float scalingMul = this.f_19796_.m_188501_() / pFactor;
        this.setStackScale(this.stackScale() + scalingMul);
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        return false;
    }

    public int m_20146_() {
        return super.m_6062_();
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22277_, 256.0).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22276_, ((Double)DawnOfTheFloodConfig.SERVER.maw_form_health.get()).doubleValue()).m_22268_(Attributes.f_22281_, ((Double)DawnOfTheFloodConfig.SERVER.maw_form_damage.get()).doubleValue()).m_22268_(Attributes.f_22282_, 3.0).m_22268_(Attributes.f_22278_, 20.0).m_22268_(Attributes.f_22284_, 15.0).m_22268_(Attributes.f_22283_, 1.1);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new CustomMeleeAttackGoal((PathfinderMob)this, 1.2, false){

            @Override
            protected double getAttackReachSqr(LivingEntity entity) {
                return 8.5 + (double)(entity.m_20205_() * entity.m_20205_());
            }
        });
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, true, this::targetPredicate));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21345_.m_25352_(0, (Goal)new MawFormSlamAttackGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[]{BaseForm.class}));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[]{MawFormEntity.class}));
        this.f_21345_.m_25352_(4, (Goal)new EscapeFromVehicleGoal((Mob)this));
    }

    private boolean targetPredicate(LivingEntity liv) {
        return !EntityRegistry.FLOOD_FORMS.contains(liv) && !(liv instanceof CovenantOrsShipEntity) && !(liv instanceof Squid) && !(liv instanceof ArmorStand) && !(liv instanceof AbstractFish) && !(liv instanceof Bat) && !((List)DawnOfTheFloodConfig.SERVER.blacklist.get()).contains(liv.m_20078_());
    }

    public static boolean checkMawFormRules(EntityType<? extends MawFormEntity> entityType, ServerLevelAccessor levelAccessor, MobSpawnType mobSpawnType, BlockPos pos, RandomSource source) {
        WorldDataUtils worldDataUtils = WorldDataUtils.getWorldDataRegistry(levelAccessor.m_6018_());
        int currentWave = worldDataUtils.getWave();
        return levelAccessor.m_46791_() != Difficulty.PEACEFUL && MawFormEntity.m_219009_((ServerLevelAccessor)levelAccessor, (BlockPos)pos, (RandomSource)source) && MawFormEntity.m_217057_(entityType, (LevelAccessor)levelAccessor, (MobSpawnType)mobSpawnType, (BlockPos)pos, (RandomSource)source) && currentWave > 3;
    }

    public float getVolume() {
        return 2.15f;
    }

    public float getPitch(RandomSource random) {
        return 0.95f;
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundRegistry.MAW_FORM_DEATH.get();
    }

    public int getSubtractionPoints() {
        return 1000;
    }

    public void setAttackID(int id) {
        this.attackID = id;
        this.attacktick = 0;
        this.m_9236_().m_7605_((Entity)this, (byte)(-id));
    }

    public void m_7822_(byte id) {
        if (id <= 0) {
            this.attackID = Math.abs(id);
            this.attacktick = 0;
        } else {
            super.m_7822_(id);
        }
    }

    public boolean m_7327_(Entity pEntity) {
        if (!this.m_9236_().f_46443_ && this.attackID == 0) {
            this.attackID = 1;
        }
        return true;
    }

    private boolean canSummonClaw() {
        float area = 64.0f;
        int maximumClaws = 5;
        AABB areaBox = this.m_20191_().m_82400_((double)area);
        List entities = this.m_9236_().m_45933_((Entity)this, areaBox);
        ArrayList<MawClawEntity> nearbyClaws = new ArrayList<MawClawEntity>();
        for (Entity entity : entities) {
            if (!(entity instanceof MawClawEntity)) continue;
            MawClawEntity mawClawEntity = (MawClawEntity)entity;
            nearbyClaws.add(mawClawEntity);
        }
        return nearbyClaws.size() < maximumClaws;
    }

    private void createClaw(Monster entity) {
        LivingEntity target = Objects.requireNonNull(entity.m_5448_());
        MawClawEntity mawClawEntity = new MawClawEntity((EntityType<? extends Monster>)((EntityType)EntityRegistry.MAW_CLAW.get()), entity.m_9236_());
        mawClawEntity.m_6027_(entity.m_20185_() + this.f_19796_.m_188583_() * 2.0, entity.m_20186_(), entity.m_20189_() + this.f_19796_.m_188583_() * 2.0);
        entity.m_9236_().m_7967_((Entity)mawClawEntity);
        entity.m_9236_().m_5594_(null, entity.m_20183_(), (SoundEvent)SoundRegistry.MAW_CLAW_SUMMON.get(), SoundSource.HOSTILE, 2.0f, 1.0f);
        mawClawEntity.burrowTo((int)target.m_20185_(), (int)target.m_20186_(), (int)target.m_20189_());
    }

    public boolean canSummonPods() {
        float area = 32.0f;
        int maximumPods = 9;
        AABB areaBox = this.m_20191_().m_82400_((double)area);
        List entities = this.m_9236_().m_45933_((Entity)this, areaBox);
        ArrayList<PodInfectorEntity> nearbyPods = new ArrayList<PodInfectorEntity>();
        for (Entity entity : entities) {
            if (!(entity instanceof PodInfectorEntity)) continue;
            PodInfectorEntity podInfectorEntity = (PodInfectorEntity)entity;
            nearbyPods.add(podInfectorEntity);
        }
        return nearbyPods.size() < maximumPods;
    }

    private void createPods(Entity entity) {
        for (int i = 0; i < 3; ++i) {
            PodInfectorEntity podInfectorEntity = new PodInfectorEntity((EntityType<? extends Monster>)((EntityType)EntityRegistry.POD_INFECTOR.get()), entity.m_9236_());
            podInfectorEntity.m_6027_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
            entity.m_9236_().m_7967_((Entity)podInfectorEntity);
            podInfectorEntity.m_5997_(this.f_19796_.m_188583_() * (double)0.2f, this.f_19796_.m_188583_() * 0.25, this.f_19796_.m_188583_() * (double)0.2f);
            podInfectorEntity.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.FROM_THE_SOURCE.get(), 500, 0));
        }
        entity.m_9236_().m_5594_(null, entity.m_20183_(), (SoundEvent)SoundRegistry.MAW_CLAW_SUMMON.get(), SoundSource.HOSTILE, 2.0f, 1.0f);
    }

    public void m_8119_() {
        super.m_8119_();
        LivingEntity target = this.m_5448_();
        if (target != null && this.canSummonClaw() && this.f_19796_.m_188503_(30) == 0) {
            this.createClaw(this);
        }
        if (target != null && this.cooldownTick == 0 && this.canSummonPods() && !this.isUnderground()) {
            this.createPods((Entity)this);
            this.cooldownTick = 200 + this.f_19796_.m_188503_(200);
        }
        if (this.cooldownTick > 0) {
            --this.cooldownTick;
        }
        if (!this.m_9236_().f_46443_) {
            this.m_21195_(MobEffects.f_19614_);
            if (this.burrowCooldown > 0) {
                --this.burrowCooldown;
            } else if (this.burrowCooldown == 0 && target != null && this.m_20270_((Entity)target) <= 120.0f) {
                int x = (int)((float)((int)target.m_20185_()) + this.m_20270_((Entity)target) / 6.0f + (float)this.f_19796_.m_188503_(6));
                int y = (int)target.m_20186_();
                int z = (int)((float)((int)target.m_20189_()) + this.m_20270_((Entity)target) / 6.0f + (float)this.f_19796_.m_188503_(6));
                this.burrowTo(x, y, z);
            }
            if (this.getBurrowProgress() > 0) {
                this.setBurrowProgress(this.getBurrowProgress() + 1);
                if (this.getBurrowProgress() == 1) {
                    this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)SoundRegistry.MAW_DIG.get(), SoundSource.PLAYERS, 3.2f, 1.0f);
                }
                if (this.getBurrowProgress() == 550) {
                    this.m_20984_((double)this.burrowX + 0.5, this.burrowY, (double)this.burrowZ + 0.5, false);
                }
                if (this.getBurrowProgress() == 690) {
                    this.setBurrowProgress(0);
                }
            }
        } else if (this.isBurrowing() || this.isEmerging()) {
            this.digParticles();
            this.prevClientBurrowProgress = this.clientBurrowProgress;
            this.clientBurrowProgress = this.getBurrowProgress();
        }
        if (target != null && !this.canPlayAppearSound.isLocked()) {
            this.canPlayAppearSound.lock();
            this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)SoundRegistry.MAW_APPEAR.get(), SoundSource.PLAYERS, 3.2f, 1.0f);
        } else if (target == null && this.canPlayAppearSound.isLocked()) {
            this.canPlayAppearSound.unlock();
        }
        if (this.canRegenerate() && ((Boolean)DawnOfTheFloodConfig.SERVER.maw_form_regeneration.get()).booleanValue() && this.m_217043_().m_188503_(280) == 0 && (double)this.m_21223_() < (double)this.m_21233_() - 2.5) {
            this.m_5634_(2.5f);
        }
        if (this.attackID != 0) {
            this.f_20883_ = this.f_20885_;
            this.m_146922_(this.f_20883_);
            ++this.attacktick;
            if (target != null) {
                this.m_21563_().m_24960_((Entity)target, 30.0f, 90.0f);
            }
        }
    }

    public void digParticles() {
        RandomSource random = this.m_217043_();
        BlockState blockState = this.m_20075_();
        if (blockState.m_60799_() != RenderShape.INVISIBLE) {
            for (int i = 0; i < 30; ++i) {
                double d = this.m_20185_() + (double)Mth.m_216283_((RandomSource)random, (float)-0.7f, (float)0.7f);
                double e = this.m_20186_();
                double f = this.m_20189_() + (double)Mth.m_216283_((RandomSource)random, (float)-0.7f, (float)0.7f);
                this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockState), d, e, f, 0.0, 0.0, 0.0);
            }
        }
    }

    public boolean couldEntityFit(Entity entity, double x, double y, double z) {
        float w = entity.m_20205_() / 2.0f;
        float h = entity.m_20206_();
        for (VoxelShape voxelShape : entity.m_9236_().m_186434_(entity, new AABB(x - (double)w, y, z - (double)w, x + (double)w, y + (double)h, z + (double)w))) {
            if (voxelShape.m_83281_()) continue;
            return false;
        }
        return true;
    }

    public void burrowTo(int x, int y, int z) {
        if (this.canBurrow() && this.m_20096_() && this.couldEntityFit((Entity)this, (double)x + 0.5, y, (double)z + 0.5)) {
            this.burrowX = x;
            this.burrowY = y;
            this.burrowZ = z;
            this.setBurrowProgress(1);
            this.m_21573_().m_26573_();
            this.m_20334_(0.0, 0.0, 0.0);
            this.burrowCooldown = 900;
            this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)SoundRegistry.MAW_DIG.get(), SoundSource.HOSTILE, 3.2f, 1.0f);
        }
    }

    public float getBurrowDepth() {
        return this.m_20206_() + 0.5f;
    }

    public boolean canBurrow() {
        return this.burrowCooldown == 0;
    }

    public boolean m_20145_() {
        return super.m_20145_() || this.isUnderground();
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        Arrow arrow;
        if (this.isUnderground()) {
            return false;
        }
        Entity entity = pSource.m_7640_();
        if (entity instanceof Arrow && ((arrow = (Arrow)entity).m_19749_() instanceof PlayerFormEntity || arrow.m_19749_() instanceof PillagerFormEntity)) {
            return false;
        }
        if (pSource.m_7640_() instanceof AbstractBullet) {
            return false;
        }
        if (pSource.m_7640_() instanceof IronAxeEntity) {
            return false;
        }
        if (pSource.m_7640_() instanceof Projectile) {
            return super.m_6469_(pSource, pAmount / 4.0f);
        }
        if (pSource.m_7639_() != null && (entity = pSource.m_7639_()) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            this.m_6710_(livingEntity);
        }
        return super.m_6469_(pSource, pAmount);
    }

    public void m_6667_(DamageSource source) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            WorldDataUtils worldDataUtils = WorldDataUtils.getWorldDataRegistry(world);
            int currentScore = worldDataUtils.getScore();
            int currentWave = worldDataUtils.getWave();
            if (currentWave > 3) {
                worldDataUtils.setScore(currentScore - this.getSubtractionPoints());
            }
        }
        super.m_6667_(source);
    }

    private void sweep(Entity pEntity) {
        AABB boundingBox = this.m_20191_().m_82400_(1.85);
        List entities = this.m_9236_().m_45933_((Entity)this, boundingBox);
        for (Entity entity : entities) {
            LivingEntity livingEntity;
            if (!(entity instanceof LivingEntity) || !this.targetPredicate(livingEntity = (LivingEntity)entity) || livingEntity == pEntity) continue;
            float dist = this.m_20270_((Entity)livingEntity);
            livingEntity.m_6469_(this.getDamage(), (float)this.m_21133_(Attributes.f_22281_) * (1.0f / dist) * 0.75f);
            livingEntity.m_9236_().m_5594_(null, livingEntity.m_20183_(), SoundEvents.f_12317_, SoundSource.HOSTILE, this.getVolume(), this.getPitch(this.f_19796_) - 0.35f);
        }
    }

    public void destroySwingable() {
        AABB aabb = this.m_20191_().m_82400_((double)0.95f);
        for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
            BlockState blockstate = this.m_9236_().m_8055_(blockpos);
            if (!blockstate.m_204336_(BlockTags.f_13104_) && !blockstate.m_204336_(BlockTags.f_13073_) && !blockstate.m_204336_(BlockTags.f_13035_) && !blockstate.m_204336_(GenericBlockTags.Blocks.SWINGABLE)) continue;
            this.m_9236_().m_46953_(blockpos, false, (Entity)this);
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        this.randomizeScale(3.0f);
        this.stackScaler.randomizeScale(this.f_19796_, 2.2f);
        return super.m_6518_(pLevel, pDifficulty, pReason, spawnGroupData, compoundTag);
    }

    public boolean canRegenerate() {
        return !this.m_6060_();
    }

    public DamageSource getDamage() {
        List<DamageSource> damageSources = List.of(DamageTypeRegistry.form_melee_damage1((LivingEntity)this), DamageTypeRegistry.form_melee_damage2((LivingEntity)this), DamageTypeRegistry.form_melee_damage3((LivingEntity)this), DamageTypeRegistry.form_melee_damage4((LivingEntity)this), DamageTypeRegistry.form_melee_damage5((LivingEntity)this), DamageTypeRegistry.form_melee_damage6((LivingEntity)this), DamageTypeRegistry.form_melee_damage7((LivingEntity)this), DamageTypeRegistry.form_melee_damage8((LivingEntity)this));
        int length = damageSources.size();
        return damageSources.get(this.f_19796_.m_188503_(length));
    }

    public class MawFormSlamAttackGoal
    extends Goal {
        private final MawFormEntity mawFormEntity;
        private LivingEntity attackTarget;

        public MawFormSlamAttackGoal(MawFormEntity marineFormEntity) {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.mawFormEntity = marineFormEntity;
        }

        public boolean m_8036_() {
            this.attackTarget = this.mawFormEntity.m_5448_();
            return this.attackTarget != null && this.mawFormEntity.attackID == 1 && !this.mawFormEntity.isBurrowing() && !this.mawFormEntity.isEmerging();
        }

        public void m_8056_() {
            this.mawFormEntity.setAttackID(1);
        }

        public void m_8041_() {
            this.mawFormEntity.setAttackID(0);
            this.attackTarget = null;
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8045_() {
            return this.mawFormEntity.attacktick < 30;
        }

        public void m_8037_() {
            if (MawFormEntity.this.attacktick == 2) {
                float volume = 1.15f;
                float pitch = 0.65f;
                this.mawFormEntity.m_9236_().m_5594_(null, this.mawFormEntity.m_20183_(), (SoundEvent)SoundRegistry.ENTITY_SWING.get(), SoundSource.HOSTILE, volume, pitch);
            }
            if (MawFormEntity.this.attacktick == 3) {
                MawFormEntity.this.destroySwingable();
                MawFormEntity.this.sweep((Entity)this.attackTarget);
                if (MawFormEntity.this.m_20270_((Entity)this.attackTarget) <= 8.5f) {
                    this.attackTarget.m_6469_(MawFormEntity.this.getDamage(), (float)MawFormEntity.this.m_21133_(Attributes.f_22281_));
                    if (this.attackTarget.m_6084_()) {
                        Player player;
                        double dx = Mth.m_14031_((float)((float)Math.PI)) * 2.05f;
                        double dz = this.attackTarget.m_20189_();
                        double strength = 1.95f;
                        this.attackTarget.m_147240_(strength, dx, dz);
                        LivingEntity livingEntity = this.attackTarget;
                        if (livingEntity instanceof Player && (player = (Player)livingEntity).m_21254_()) {
                            player.m_36384_(true);
                        }
                    }
                }
            }
            MawFormEntity.this.m_21573_().m_26569_();
        }
    }
}

