/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.entity.custom;

import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.asestefan.screenshake.ScreenShakeUtils;
import net.asestefan.utils.ParticleUtils;
import net.asestefan.utils.SoundUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.network.NetworkHooks;
import net.teamabyssalofficial.dotf.config.DawnOfTheFloodConfig;
import net.teamabyssalofficial.dotf.controls.WallMovementControl;
import net.teamabyssalofficial.dotf.datagen.tags.GenericBlockTags;
import net.teamabyssalofficial.entity.ai.EscapeFromVehicleGoal;
import net.teamabyssalofficial.entity.ai.FastSwimmingDiveGoal;
import net.teamabyssalofficial.entity.categories.BaseForm;
import net.teamabyssalofficial.entity.custom.MarineFormEntity;
import net.teamabyssalofficial.entity.custom.PillagerFormEntity;
import net.teamabyssalofficial.entity.custom.PlayerFormEntity;
import net.teamabyssalofficial.entity.custom.PodInfectorEntity;
import net.teamabyssalofficial.entity.custom.special.CovenantOrsShipEntity;
import net.teamabyssalofficial.entity.custom.special.IronAxeEntity;
import net.teamabyssalofficial.entity.custom.special.TyrantProjectileEntity;
import net.teamabyssalofficial.guns.bullet.AbstractBullet;
import net.teamabyssalofficial.registry.DamageTypeRegistry;
import net.teamabyssalofficial.registry.EntityRegistry;
import net.teamabyssalofficial.registry.ParticleRegistry;
import net.teamabyssalofficial.registry.SoundRegistry;
import net.teamabyssalofficial.util.BlockUtils;
import net.teamabyssalofficial.util.MathhaxUtils;
import net.teamabyssalofficial.util.PerformanceEngine;
import net.teamabyssalofficial.util.SoundPacket;
import net.teamabyssalofficial.util.WorldDataUtils;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class TyrantFormEntity
extends Monster
implements GeoEntity,
SoundUtils,
RangedAttackMob {
    private static final EntityDataAccessor<Integer> AGGRO_TICKS = SynchedEntityData.m_135353_(TyrantFormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> TRANSFORM_SPAWNED = SynchedEntityData.m_135353_(TyrantFormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> SPAWN_TIMER = SynchedEntityData.m_135353_(TyrantFormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ROAR_TIMER = SynchedEntityData.m_135353_(TyrantFormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> STACK_SCALE = SynchedEntityData.m_135353_(TyrantFormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public int attacktick;
    public int attackID;
    public boolean isImmobile = false;
    public static final byte CLAW_ATTACK = 1;
    public static final byte BITE_ATTACK1 = 2;
    public static final byte BITE_ATTACK2 = 3;
    public static final byte SPIT_ACID_ATTACK = 4;
    public static final int CLAW_ATTACK_LENGTH = 22;
    public static final int BITE_ATTACK1_LENGTH = 19;
    public static final int BITE_ATTACK2_LENGTH = 20;
    public static final int SPIT_ACID_ATTACK_LENGTH = 20;
    public static final int ROAR_TICKS = 80;
    public static final int TRANSFORM_TICKS = 33;
    private int roarCooldownTicks = 0;
    private int spitCooldownTicks = 0;
    private MarineFormEntity riderEntity;

    public TyrantFormEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 40.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, -2.0f);
        if (((Boolean)DawnOfTheFloodConfig.SERVER.tyrant_form_climb.get()).booleanValue()) {
            this.f_21342_ = new WallMovementControl((Mob)this);
            this.f_21344_ = new WallClimberNavigation((Mob)this, pLevel);
        }
        this.m_274367_(1.75f);
        this.f_21364_ = 30;
        EntityRegistry.FLOOD_FORMS.add((Entity)this);
    }

    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(AGGRO_TICKS, (Object)0);
        this.f_19804_.m_135372_(TRANSFORM_SPAWNED, (Object)false);
        this.f_19804_.m_135372_(SPAWN_TIMER, (Object)33);
        this.f_19804_.m_135372_(ROAR_TIMER, (Object)0);
        this.f_19804_.m_135372_(STACK_SCALE, (Object)Float.valueOf(0.0f));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22277_, 50.0).m_22268_(Attributes.f_22279_, 0.27).m_22268_(Attributes.f_22276_, ((Double)DawnOfTheFloodConfig.SERVER.tyrant_form_health.get()).doubleValue()).m_22268_(Attributes.f_22281_, ((Double)DawnOfTheFloodConfig.SERVER.tyrant_form_damage.get()).doubleValue()).m_22268_(Attributes.f_22282_, 0.75).m_22268_(Attributes.f_22283_, 2.15).m_22268_(Attributes.f_22278_, 2.55).m_22268_(Attributes.f_22284_, 6.0);
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("aggroTicks", this.getAggroTicks());
        pCompound.m_128379_("transformSpawned", this.isTransformSpawned());
        pCompound.m_128405_("spawnTimer", this.getSpawnTimer());
        pCompound.m_128405_("roarTimer", this.getRoarTimer());
        pCompound.m_128350_("stackScale", this.stackScale());
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setAggroTicks(pCompound.m_128451_("aggroTicks"));
        this.setTransformSpawned(pCompound.m_128471_("transformSpawned"));
        this.setSpawnTimer(pCompound.m_128451_("spawnTimer"));
        this.setRoarTimer(pCompound.m_128451_("roarTimer"));
        this.setStackScale(pCompound.m_128457_("stackScale"));
    }

    public int m_20146_() {
        return super.m_6062_();
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        return false;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false));
        this.f_21345_.m_25352_(5, (Goal)new FastSwimmingDiveGoal((Mob)this, 0.5f));
        this.f_21345_.m_25352_(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8){

            public boolean m_8036_() {
                return super.m_8036_() && this.f_25725_.m_5448_() == null;
            }

            public boolean m_8045_() {
                return super.m_8045_() && this.f_25725_.m_5448_() == null;
            }
        });
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, true, this::targetPredicate));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[]{BaseForm.class}));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[]{PodInfectorEntity.class}));
        this.f_21345_.m_25352_(0, (Goal)new TyrantFormClawAttackGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new TyrantFormBiteWeakAttackGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new TyrantFormBiteStrongAttackGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new TyrantFormSpitAcidGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new EscapeFromVehicleGoal((Mob)this));
    }

    private boolean targetPredicate(LivingEntity liv) {
        return !EntityRegistry.FLOOD_FORMS.contains(liv) && !(liv instanceof CovenantOrsShipEntity) && !(liv instanceof Squid) && !(liv instanceof ArmorStand) && !(liv instanceof AbstractFish) && !(liv instanceof Bat) && !((List)DawnOfTheFloodConfig.SERVER.blacklist.get()).contains(liv.m_20078_());
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerV) {
        controllerV.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controllerTyrant", 8, event -> {
            if (this.getRoarTimer() > 0) {
                return event.setAndContinue(RawAnimation.begin().thenPlay("tyrant_form.roar"));
            }
            if (this.getSpawnTimer() > 0 && this.isTransformSpawned()) {
                return event.setAndContinue(RawAnimation.begin().thenPlay("tyrant_form.transform"));
            }
            if (!event.isMoving() && !this.m_5912_() && this.attackID == 0) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("tyrant_form.idle"));
            }
            if (event.isMoving() && !this.m_5912_() && this.attackID == 0) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("tyrant_form.walk"));
            }
            if (event.isMoving() && this.m_5912_() && this.attackID == 0) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("tyrant_form.target"));
            }
            if (this.attackID == 1) {
                return event.setAndContinue(RawAnimation.begin().thenPlay("tyrant_form.claw_attack"));
            }
            if (this.attackID == 2) {
                return event.setAndContinue(RawAnimation.begin().thenPlay("tyrant_form.bite1"));
            }
            if (this.attackID == 3) {
                return event.setAndContinue(RawAnimation.begin().thenPlay("tyrant_form.bite2"));
            }
            if (this.attackID == 4) {
                return event.setAndContinue(RawAnimation.begin().thenPlay("tyrant_form.spit_acid"));
            }
            return PlayState.CONTINUE;
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void setAttackID(int id) {
        this.attackID = id;
        this.attacktick = 0;
        this.m_9236_().m_7605_((Entity)this, (byte)(-id));
    }

    public void m_7822_(byte id) {
        if (id <= 0) {
            this.attackID = Math.abs(id);
            this.attacktick = 0;
        } else {
            super.m_7822_(id);
        }
    }

    public int getAggroTicks() {
        return (Integer)this.f_19804_.m_135370_(AGGRO_TICKS);
    }

    public void setAggroTicks(int ticks) {
        this.f_19804_.m_135381_(AGGRO_TICKS, (Object)ticks);
    }

    public int getRoarTimer() {
        return (Integer)this.f_19804_.m_135370_(ROAR_TIMER);
    }

    public void setRoarTimer(int ticks) {
        this.f_19804_.m_135381_(ROAR_TIMER, (Object)ticks);
    }

    public int getSpawnTimer() {
        return (Integer)this.f_19804_.m_135370_(SPAWN_TIMER);
    }

    public void setSpawnTimer(int ticks) {
        this.f_19804_.m_135381_(SPAWN_TIMER, (Object)ticks);
    }

    public boolean isTransformSpawned() {
        return (Boolean)this.f_19804_.m_135370_(TRANSFORM_SPAWNED);
    }

    public void setTransformSpawned(boolean transformSpawned) {
        this.f_19804_.m_135381_(TRANSFORM_SPAWNED, (Object)transformSpawned);
    }

    public float stackScale() {
        return ((Float)this.f_19804_.m_135370_(STACK_SCALE)).floatValue();
    }

    public void setStackScale(float pScale) {
        this.f_19804_.m_135381_(STACK_SCALE, (Object)Float.valueOf(pScale));
    }

    public void randomizeScale(float pFactor) {
        float scalingMul = this.f_19796_.m_188501_() / pFactor;
        this.setStackScale(this.stackScale() + scalingMul);
    }

    protected void m_8024_() {
        if (this.getSpawnTimer() > 0) {
            this.setSpawnTimer(this.getSpawnTimer() - 1);
        }
        if (this.getRoarTimer() > 0) {
            this.setRoarTimer(this.getRoarTimer() - 1);
        }
        super.m_8024_();
    }

    public boolean m_7327_(Entity pEntity) {
        if (!this.m_9236_().f_46443_ && this.attackID == 0) {
            int rand = this.f_19796_.m_188503_(5);
            switch (rand) {
                case 0: 
                case 1: {
                    this.attackID = 1;
                    break;
                }
                case 2: 
                case 3: {
                    this.attackID = 2;
                    break;
                }
                default: {
                    this.attackID = 3;
                }
            }
        }
        return true;
    }

    public void m_8107_() {
        super.m_8107_();
        LivingEntity attackTarget = this.m_5448_();
        if (this.m_6084_() && attackTarget != null && this.m_142582_((Entity)attackTarget) && this.m_20270_((Entity)attackTarget) <= 15.0f && ((Boolean)DawnOfTheFloodConfig.SERVER.tyrant_form_breaks_blocks.get()).booleanValue()) {
            SoundPacket soundPacket = new SoundPacket((SoundEvent)SoundRegistry.TYRANT_IDLE.get(), SoundSource.HOSTILE, this.getVolume(), this.getPitch(this.f_19796_));
            BlockUtils.destroyBlocks(this.m_9236_(), (LivingEntity)this, 0.33f, this.getDestroySpeed(), 45, soundPacket);
        }
    }

    public int getDestroySpeed() {
        return 2;
    }

    public static boolean checkFloodTyrantFormRules(EntityType<? extends TyrantFormEntity> entityType, ServerLevelAccessor levelAccessor, MobSpawnType mobSpawnType, BlockPos pos, RandomSource source) {
        WorldDataUtils worldDataUtils = WorldDataUtils.getWorldDataRegistry(levelAccessor.m_6018_());
        int currentWave = worldDataUtils.getWave();
        return levelAccessor.m_46791_() != Difficulty.PEACEFUL && TyrantFormEntity.m_219009_((ServerLevelAccessor)levelAccessor, (BlockPos)pos, (RandomSource)source) && TyrantFormEntity.m_217057_(entityType, (LevelAccessor)levelAccessor, (MobSpawnType)mobSpawnType, (BlockPos)pos, (RandomSource)source) && currentWave > 4 && !levelAccessor.m_45527_(pos) && pos.m_123342_() <= 10;
    }

    public int getSubtractionPoints() {
        return 4500;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)SoundRegistry.TYRANT_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundRegistry.TYRANT_DEATH.get();
    }

    @org.jetbrains.annotations.Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)SoundRegistry.TYRANT_IDLE.get();
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        super.m_7355_(pos, blockIn);
        this.m_5496_((SoundEvent)SoundRegistry.HEAVY_STEP.get(), this.getVolume() * 0.85f, this.getPitch(this.f_19796_) * 0.55f);
    }

    public DamageSource getDamage() {
        List<DamageSource> damageSources = List.of(DamageTypeRegistry.form_melee_damage1((LivingEntity)this), DamageTypeRegistry.form_melee_damage2((LivingEntity)this), DamageTypeRegistry.form_melee_damage3((LivingEntity)this), DamageTypeRegistry.form_melee_damage4((LivingEntity)this), DamageTypeRegistry.form_melee_damage5((LivingEntity)this), DamageTypeRegistry.form_melee_damage6((LivingEntity)this), DamageTypeRegistry.form_melee_damage7((LivingEntity)this), DamageTypeRegistry.form_melee_damage8((LivingEntity)this));
        int length = damageSources.size();
        return damageSources.get(this.f_19796_.m_188503_(length));
    }

    public void m_6667_(DamageSource source) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            WorldDataUtils worldDataUtils = WorldDataUtils.getWorldDataRegistry(world);
            int currentScore = worldDataUtils.getScore();
            int currentWave = worldDataUtils.getWave();
            if (currentWave > 4) {
                worldDataUtils.setScore(currentScore - this.getSubtractionPoints());
            }
        }
        super.m_6667_(source);
    }

    private void sweep(Entity pEntity) {
        AABB boundingBox = this.m_20191_().m_82400_((double)2.15f);
        List entities = this.m_9236_().m_45933_((Entity)this, boundingBox);
        for (Entity entity : entities) {
            LivingEntity livingEntity;
            if (!(entity instanceof LivingEntity) || !this.targetPredicate(livingEntity = (LivingEntity)entity) || livingEntity == pEntity) continue;
            float dist = this.m_20270_((Entity)livingEntity);
            livingEntity.m_6469_(this.getDamage(), (float)this.m_21133_(Attributes.f_22281_) * (1.0f / dist) * 0.75f);
            livingEntity.m_9236_().m_5594_(null, livingEntity.m_20183_(), SoundEvents.f_12317_, SoundSource.HOSTILE, this.getVolume(), this.getPitch(this.f_19796_) - 0.45f);
        }
    }

    public void destroySwingable() {
        AABB aabb = this.m_20191_().m_82400_((double)0.9f);
        for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
            BlockState blockstate = this.m_9236_().m_8055_(blockpos);
            if (!blockstate.m_204336_(BlockTags.f_13104_) && !blockstate.m_204336_(BlockTags.f_13073_) && !blockstate.m_204336_(BlockTags.f_13035_) && !blockstate.m_204336_(GenericBlockTags.Blocks.SWINGABLE)) continue;
            this.m_9236_().m_46953_(blockpos, false, (Entity)this);
        }
    }

    private void summonFloodParticle() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            server.m_8767_((ParticleOptions)((SimpleParticleType)ParticleRegistry.FLOOD_BLOOD_SPLASH.get()), this.m_20208_(0.25), this.m_20187_() + 0.25, this.m_20262_(0.25), 3, 0.1, 0.2, 0.1, ParticleUtils.getDownwardsSmallSpread((RandomSource)this.f_19796_));
        }
    }

    public void riderTick() {
        if (this.riderEntity != null) {
            this.riderEntity.m_6034_(this.m_20185_(), this.m_20186_() + 3.1 + (double)(1.0f / this.stackScale()), this.m_20189_());
            this.riderEntity.setHasTyrant(this.riderEntity.m_6084_());
            this.riderEntity.m_21563_().m_24964_(this.m_20154_());
        }
    }

    public void m_8119_() {
        float f;
        super.m_8119_();
        if (this.roarCooldownTicks > 0) {
            --this.roarCooldownTicks;
        }
        if (this.roarCooldownTicks == 0 && this.m_5448_() != null) {
            this.roarCooldownTicks = 1600;
            this.setRoarTimer(80);
        }
        if (this.spitCooldownTicks > 0) {
            --this.spitCooldownTicks;
        }
        if (this.spitCooldownTicks == 0 && this.m_5448_() != null && MathhaxUtils.betweenInclusive(this.m_20270_((Entity)this.m_5448_()), 6.0f, 30.0f) && this.getRoarTimer() == 0 && ((Boolean)DawnOfTheFloodConfig.SERVER.tyrant_form_spit_acid.get()).booleanValue()) {
            this.spitCooldownTicks = 400;
            this.attackID = 4;
        }
        if (this.m_20096_() && !this.isInFluidType() && this.f_267362_.m_267731_() > 0.1f && ((Boolean)DawnOfTheFloodConfig.SERVER.tyrant_form_tremble_walk.get()).booleanValue() && (double)Math.abs(f = (float)Math.cos(this.f_267362_.m_267756_() * 0.8f - 1.5f)) < 0.2) {
            if (PerformanceEngine.canPerformShake((LivingEntity)this, this.m_9236_(), 12.0)) {
                ScreenShakeUtils.ScreenShake((Level)this.m_9236_(), (Vec3)this.m_20182_(), (float)PerformanceEngine.getShakeRadius(12), (float)0.022f, (int)3, (int)2);
            }
            this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)SoundRegistry.HEAVY_STEP.get(), SoundSource.HOSTILE, 1.35f, 1.0f);
        }
        if (this.m_5448_() != null && ((Boolean)DawnOfTheFloodConfig.SERVER.juggernaut_form_aggro_despawn.get()).booleanValue()) {
            this.setAggroTicks(this.getAggroTicks() + 1);
        }
        if (!this.m_9236_().f_46443_) {
            this.m_21195_(MobEffects.f_19614_);
        }
        if (this.getSpawnTimer() > 0 || this.getRoarTimer() > 0 && !this.isImmobile) {
            this.isImmobile = true;
            Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22100_(0.0);
        }
        if (this.getSpawnTimer() == 0 && this.getRoarTimer() == 0 && this.isImmobile) {
            this.isImmobile = false;
            Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22100_(0.27);
        }
        if (this.getSpawnTimer() == 31 && this.isTransformSpawned()) {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)SoundRegistry.ENTITY_FORM_SPAWN.get(), this.m_5720_(), this.getVolume(), this.getPitch(this.f_19796_) - 0.45f);
        }
        if (this.getSpawnTimer() == 6 && this.getRoarTimer() == 0 && this.isTransformSpawned()) {
            this.setRoarTimer(80);
        }
        if (this.getRoarTimer() > 0) {
            this.summonFloodParticle();
        }
        if (this.getRoarTimer() == 64) {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)SoundRegistry.TYRANT_ROAR.get(), this.m_5720_(), 4.0f, this.getPitch(this.f_19796_));
            if (((Boolean)DawnOfTheFloodConfig.SERVER.base_form_screen_shake.get()).booleanValue()) {
                ScreenShakeUtils.ScreenShake((Level)this.m_9236_(), (Vec3)this.m_20182_(), (float)PerformanceEngine.getShakeRadius(40), (float)0.27f, (int)44, (int)10);
            }
        }
        if (this.attackID != 0 || this.getRoarTimer() > 0) {
            Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22100_(0.0);
        } else {
            Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22100_(0.27);
        }
        if (this.attackID != 0) {
            this.f_20883_ = this.f_20885_;
            this.m_146922_(this.f_20883_);
            ++this.attacktick;
            if (this.m_5448_() != null) {
                this.m_21563_().m_24960_((Entity)this.m_5448_(), 30.0f, 90.0f);
            }
        }
        if (this.canRegenerate() && ((Boolean)DawnOfTheFloodConfig.SERVER.tyrant_form_regeneration.get()).booleanValue() && this.m_217043_().m_188503_(150) == 0 && (double)this.m_21223_() < (double)this.m_21233_() - 2.0) {
            this.m_5634_(2.0f);
        }
        this.riderTick();
    }

    public boolean m_6094_() {
        return false;
    }

    protected void m_7324_(Entity p_20971_) {
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        Arrow arrow;
        Entity entity = pSource.m_7640_();
        if (entity instanceof Arrow && ((arrow = (Arrow)entity).m_19749_() instanceof PlayerFormEntity || arrow.m_19749_() instanceof PillagerFormEntity)) {
            return false;
        }
        if (pSource.m_7640_() instanceof AbstractBullet) {
            return false;
        }
        if (pSource.m_7640_() instanceof IronAxeEntity) {
            return false;
        }
        return super.m_6469_(pSource, pAmount);
    }

    public boolean canRegenerate() {
        return !this.m_6060_();
    }

    public void spawnWithMarine() {
        MarineFormEntity marineFormEntity = new MarineFormEntity((EntityType<? extends Monster>)((EntityType)EntityRegistry.MARINE_FORM.get()), this.m_9236_());
        marineFormEntity.m_146884_(this.m_20182_());
        marineFormEntity.m_21563_().m_24964_(this.m_20154_());
        marineFormEntity.m_6518_((ServerLevelAccessor)((ServerLevel)this.m_9236_()), this.m_9236_().m_6436_(this.m_20183_()), MobSpawnType.JOCKEY, null, null);
        this.riderEntity = marineFormEntity;
        this.m_9236_().m_7967_((Entity)marineFormEntity);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        RandomSource randomsource = pLevel.m_213780_();
        this.m_213945_(randomsource, pDifficulty);
        ((GroundPathNavigation)this.m_21573_()).m_26477_(true);
        this.randomizeScale(2.8f);
        if (this.m_217043_().m_188503_(5) == 0) {
            this.spawnWithMarine();
        }
        return super.m_6518_(pLevel, pDifficulty, pReason, spawnGroupData, compoundTag);
    }

    public boolean m_6785_(double pDistanceToClosestPlayer) {
        return pDistanceToClosestPlayer > 16384.0 || this.getAggroTicks() < (Integer)DawnOfTheFloodConfig.SERVER.juggernaut_form_aggro_ticks.get();
    }

    public void m_6504_(LivingEntity livingEntity, float v) {
        TyrantProjectileEntity projectileEntity = new TyrantProjectileEntity(this.m_9236_(), this);
        double newX = livingEntity.m_20185_() - this.m_20185_();
        double newY = livingEntity.m_20227_(0.3333333333333333) - projectileEntity.m_20186_();
        double newZ = livingEntity.m_20189_() - this.m_20189_();
        double square = Math.sqrt(newX * newX + newZ * newZ) * (double)0.2f;
        projectileEntity.m_6686_(newX, newY + square, newZ, 1.5f, 10.0f);
        if (!this.m_20067_()) {
            this.m_9236_().m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)SoundRegistry.TYRANT_SPIT_ACID.get(), this.m_5720_(), 1.6f, 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f);
        }
        this.m_9236_().m_7967_((Entity)projectileEntity);
    }

    class TyrantFormClawAttackGoal
    extends Goal {
        private final TyrantFormEntity tyrantFormEntity;
        private LivingEntity attackTarget;

        public TyrantFormClawAttackGoal(TyrantFormEntity tyrantFormEntity) {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.tyrantFormEntity = tyrantFormEntity;
        }

        public boolean m_8036_() {
            this.attackTarget = this.tyrantFormEntity.m_5448_();
            return this.attackTarget != null && this.tyrantFormEntity.attackID == 1 && !TyrantFormEntity.this.isImmobile;
        }

        public void m_8056_() {
            this.tyrantFormEntity.setAttackID(1);
            Objects.requireNonNull(this.tyrantFormEntity.m_21051_(Attributes.f_22279_)).m_22100_(0.0);
        }

        public void m_8041_() {
            this.tyrantFormEntity.setAttackID(0);
            this.attackTarget = null;
            Objects.requireNonNull(this.tyrantFormEntity.m_21051_(Attributes.f_22279_)).m_22100_(0.27);
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8045_() {
            return this.tyrantFormEntity.attacktick < 22;
        }

        public void m_8037_() {
            if (TyrantFormEntity.this.attacktick == 7) {
                float f1 = (float)Math.cos(Math.toRadians(TyrantFormEntity.this.m_146908_() + 90.0f));
                float f2 = (float)Math.sin(Math.toRadians(TyrantFormEntity.this.m_146908_() + 90.0f));
                TyrantFormEntity.this.m_5997_((double)f1 * 0.1, 0.0, (double)f2 * 0.1);
            }
            if (TyrantFormEntity.this.attacktick == 12) {
                float volume = 1.15f;
                float pitch = 0.45f;
                this.tyrantFormEntity.m_9236_().m_5594_(null, this.tyrantFormEntity.m_20183_(), (SoundEvent)SoundRegistry.ENTITY_SWING.get(), SoundSource.HOSTILE, volume, pitch);
            }
            if (TyrantFormEntity.this.attacktick == 14) {
                TyrantFormEntity.this.destroySwingable();
                TyrantFormEntity.this.sweep((Entity)this.attackTarget);
                if (TyrantFormEntity.this.m_20270_((Entity)this.attackTarget) <= 5.7f) {
                    this.attackTarget.m_6469_(TyrantFormEntity.this.getDamage(), (float)TyrantFormEntity.this.m_21133_(Attributes.f_22281_) * 0.65f);
                }
            }
            TyrantFormEntity.this.m_21573_().m_26569_();
        }
    }

    class TyrantFormBiteWeakAttackGoal
    extends Goal {
        private final TyrantFormEntity tyrantFormEntity;
        private LivingEntity attackTarget;

        public TyrantFormBiteWeakAttackGoal(TyrantFormEntity tyrantFormEntity) {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.tyrantFormEntity = tyrantFormEntity;
        }

        public boolean m_8036_() {
            this.attackTarget = this.tyrantFormEntity.m_5448_();
            return this.attackTarget != null && this.tyrantFormEntity.attackID == 2 && !TyrantFormEntity.this.isImmobile;
        }

        public void m_8056_() {
            this.tyrantFormEntity.setAttackID(2);
            Objects.requireNonNull(this.tyrantFormEntity.m_21051_(Attributes.f_22279_)).m_22100_(0.0);
        }

        public void m_8041_() {
            this.tyrantFormEntity.setAttackID(0);
            this.attackTarget = null;
            Objects.requireNonNull(this.tyrantFormEntity.m_21051_(Attributes.f_22279_)).m_22100_(0.27);
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8045_() {
            return this.tyrantFormEntity.attacktick < 19;
        }

        public void m_8037_() {
            if (TyrantFormEntity.this.attacktick == 15) {
                float volume = 1.25f;
                float pitch = 0.95f;
                this.tyrantFormEntity.m_9236_().m_5594_(null, this.tyrantFormEntity.m_20183_(), (SoundEvent)SoundRegistry.TYRANT_BITE.get(), SoundSource.HOSTILE, volume, pitch);
                TyrantFormEntity.this.destroySwingable();
                if (TyrantFormEntity.this.m_20270_((Entity)this.attackTarget) <= 6.0f) {
                    Player player;
                    LivingEntity livingEntity;
                    this.attackTarget.m_6469_(TyrantFormEntity.this.getDamage(), (float)TyrantFormEntity.this.m_21133_(Attributes.f_22281_));
                    if (this.attackTarget.m_6084_() && (livingEntity = this.attackTarget) instanceof Player && (player = (Player)livingEntity).m_21254_()) {
                        player.m_36384_(true);
                    }
                }
            }
            TyrantFormEntity.this.m_21573_().m_26569_();
        }
    }

    class TyrantFormBiteStrongAttackGoal
    extends Goal {
        private final TyrantFormEntity tyrantFormEntity;
        private LivingEntity attackTarget;

        public TyrantFormBiteStrongAttackGoal(TyrantFormEntity tyrantFormEntity) {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.tyrantFormEntity = tyrantFormEntity;
        }

        public boolean m_8036_() {
            this.attackTarget = this.tyrantFormEntity.m_5448_();
            return this.attackTarget != null && this.tyrantFormEntity.attackID == 3 && !TyrantFormEntity.this.isImmobile;
        }

        public void m_8056_() {
            this.tyrantFormEntity.setAttackID(3);
            Objects.requireNonNull(this.tyrantFormEntity.m_21051_(Attributes.f_22279_)).m_22100_(0.0);
        }

        public void m_8041_() {
            this.tyrantFormEntity.setAttackID(0);
            this.attackTarget = null;
            Objects.requireNonNull(this.tyrantFormEntity.m_21051_(Attributes.f_22279_)).m_22100_(0.27);
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8045_() {
            return this.tyrantFormEntity.attacktick < 20;
        }

        public void m_8037_() {
            if (TyrantFormEntity.this.attacktick == 16) {
                float volume = 1.25f;
                float pitch = 0.9f;
                this.tyrantFormEntity.m_9236_().m_5594_(null, this.tyrantFormEntity.m_20183_(), (SoundEvent)SoundRegistry.TYRANT_BITE.get(), SoundSource.HOSTILE, volume, pitch);
                TyrantFormEntity.this.destroySwingable();
                if (TyrantFormEntity.this.m_20270_((Entity)this.attackTarget) <= 6.0f) {
                    Player player;
                    LivingEntity livingEntity;
                    this.attackTarget.m_6469_(TyrantFormEntity.this.getDamage(), (float)TyrantFormEntity.this.m_21133_(Attributes.f_22281_) * 1.1f);
                    if (this.attackTarget.m_6084_() && (livingEntity = this.attackTarget) instanceof Player && (player = (Player)livingEntity).m_21254_()) {
                        player.m_36384_(true);
                    }
                }
            }
            TyrantFormEntity.this.m_21573_().m_26569_();
        }
    }

    class TyrantFormSpitAcidGoal
    extends Goal {
        private final TyrantFormEntity tyrantFormEntity;
        private LivingEntity attackTarget;

        public TyrantFormSpitAcidGoal(TyrantFormEntity tyrantFormEntity) {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.tyrantFormEntity = tyrantFormEntity;
        }

        public boolean m_8036_() {
            this.attackTarget = this.tyrantFormEntity.m_5448_();
            return this.attackTarget != null && this.tyrantFormEntity.attackID == 4 && !TyrantFormEntity.this.isImmobile;
        }

        public void m_8056_() {
            this.tyrantFormEntity.setAttackID(4);
            Objects.requireNonNull(this.tyrantFormEntity.m_21051_(Attributes.f_22279_)).m_22100_(0.0);
        }

        public void m_8041_() {
            this.tyrantFormEntity.setAttackID(0);
            this.attackTarget = null;
            Objects.requireNonNull(this.tyrantFormEntity.m_21051_(Attributes.f_22279_)).m_22100_(0.27);
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8045_() {
            return this.tyrantFormEntity.attacktick < 20;
        }

        public void m_8037_() {
            if (TyrantFormEntity.this.attacktick == 4) {
                TyrantFormEntity.this.f_20883_ = TyrantFormEntity.this.f_20885_;
                float f1 = (float)Math.cos(Math.toRadians(TyrantFormEntity.this.m_146908_() + 90.0f));
                float f2 = (float)Math.sin(Math.toRadians(TyrantFormEntity.this.m_146908_() + 90.0f));
                TyrantFormEntity.this.m_5997_((double)f1 * 0.1, 0.0, (double)f2 * 0.1);
            }
            if (TyrantFormEntity.this.attacktick == 16) {
                this.tyrantFormEntity.m_6504_(this.attackTarget, 1.0f);
            }
            TyrantFormEntity.this.m_21573_().m_26569_();
        }
    }
}

