/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.entity.custom;

import javax.annotation.Nullable;
import mod.chloeprime.aaaparticles.api.common.AAALevel;
import mod.chloeprime.aaaparticles.api.common.ParticleEmitterInfo;
import net.asestefan.utils.ParticleUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.network.NetworkHooks;
import net.teamabyssalofficial.impl.StackScaler;
import net.teamabyssalofficial.registry.EntityRegistry;
import net.teamabyssalofficial.registry.ItemRegistry;
import net.teamabyssalofficial.registry.ParticleRegistry;
import net.teamabyssalofficial.registry.ParticleResourceRegistry;
import net.teamabyssalofficial.registry.SoundRegistry;
import net.teamabyssalofficial.util.BlockUtils;
import net.teamabyssalofficial.util.PerformanceEngine;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class UnarmedFloodedGolemEntity
extends Monster
implements GeoEntity {
    private static final EntityDataAccessor<Integer> DESPAWN_TICKS = SynchedEntityData.m_135353_(UnarmedFloodedGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> WATER_DESPAWN_TICKS = SynchedEntityData.m_135353_(UnarmedFloodedGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> TAKEN = SynchedEntityData.m_135353_(UnarmedFloodedGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> STACK_SCALE = SynchedEntityData.m_135353_(UnarmedFloodedGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public final StackScaler stackScaler = new StackScaler(1.0f, 1.0f, 1.0f);

    public UnarmedFloodedGolemEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21364_ = 4;
        EntityRegistry.FLOOD_FORMS.add((Entity)this);
    }

    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DESPAWN_TICKS, (Object)0);
        this.f_19804_.m_135372_(WATER_DESPAWN_TICKS, (Object)0);
        this.f_19804_.m_135372_(TAKEN, (Object)false);
        this.f_19804_.m_135372_(STACK_SCALE, (Object)Float.valueOf(0.0f));
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("Despawn_Ticks", this.getDespawnTicks());
        compoundTag.m_128405_("Water_Despawn_Ticks", this.getWaterDespawnTicks());
        compoundTag.m_128379_("Taken", this.isTaken());
        compoundTag.m_128350_("stackScale", this.stackScale());
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.setDespawnTicks(compoundTag.m_128451_("Despawn_Ticks"));
        this.setWaterDespawnTicks(compoundTag.m_128451_("Water_Despawn_Ticks"));
        this.setTaken(compoundTag.m_128471_("Taken"));
        this.setStackScale(compoundTag.m_128457_("stackScale"));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22281_, 0.0).m_22268_(Attributes.f_22282_, 0.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22284_, 2.0);
    }

    public int getDespawnTicks() {
        return (Integer)this.f_19804_.m_135370_(DESPAWN_TICKS);
    }

    public void setDespawnTicks(int ticks) {
        this.f_19804_.m_135381_(DESPAWN_TICKS, (Object)ticks);
    }

    public int getWaterDespawnTicks() {
        return (Integer)this.f_19804_.m_135370_(WATER_DESPAWN_TICKS);
    }

    public void setWaterDespawnTicks(int ticks) {
        this.f_19804_.m_135381_(WATER_DESPAWN_TICKS, (Object)ticks);
    }

    public boolean isTaken() {
        return (Boolean)this.f_19804_.m_135370_(TAKEN);
    }

    public void setTaken(boolean value) {
        this.f_19804_.m_135381_(TAKEN, (Object)value);
    }

    public float stackScale() {
        return ((Float)this.f_19804_.m_135370_(STACK_SCALE)).floatValue();
    }

    public void setStackScale(float pScale) {
        this.f_19804_.m_135381_(STACK_SCALE, (Object)Float.valueOf(pScale));
    }

    public void randomizeScale(float pFactor) {
        float scalingMul = this.f_19796_.m_188501_() / pFactor;
        this.setStackScale(this.stackScale() + scalingMul);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerV) {
        controllerV.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controllerUnarmed", 7, event -> event.setAndContinue(RawAnimation.begin().thenLoop("pose")))});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void m_8119_() {
        super.m_8119_();
        this.setDespawnTicks(this.getDespawnTicks() + 1);
        if (this.m_5842_()) {
            this.setWaterDespawnTicks(this.getWaterDespawnTicks() + 1);
        }
        if (this.getDespawnTicks() == 12000 || this.getWaterDespawnTicks() == 200 || this.m_5842_() && PerformanceEngine.hasPerformanceModeOn()) {
            this.m_146870_();
            this.vanish();
        }
    }

    public boolean m_6094_() {
        return false;
    }

    protected void m_7324_(Entity p_20971_) {
    }

    public boolean m_7337_(Entity pEntity) {
        return true;
    }

    public boolean m_5829_() {
        return true;
    }

    public void vanish() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            if (!PerformanceEngine.hasPerformanceModeOn()) {
                AAALevel.addParticle((Level)world, (boolean)true, (ParticleEmitterInfo)ParticleResourceRegistry.getTemporaryFloodSmoke().clone().scale(0.15f).position(this.m_20208_(0.25), this.m_20188_() + 0.2, this.m_20262_(0.25)));
            }
            world.m_8767_((ParticleOptions)((SimpleParticleType)ParticleRegistry.GUTS.get()), this.m_20208_(0.5), this.m_20187_() + 0.35, this.m_20262_(0.65), PerformanceEngine.getParticleCount(35), 0.1, 0.2, 0.1, ParticleUtils.getDownwardsSmallSpread((RandomSource)this.f_19796_));
            world.m_8767_((ParticleOptions)ParticleTypes.f_123813_, this.m_20208_(0.25), this.m_20187_() + 0.25, this.m_20262_(0.25), PerformanceEngine.getParticleCount(5), 0.1, 0.2, 0.1, 0.01);
        }
        this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_12609_, SoundSource.HOSTILE, 1.25f, 0.95f);
        AABB aabb = this.m_20191_().m_82400_(1.0);
        for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
            BlockUtils.generateBlood(this.m_9236_(), blockpos);
        }
        for (int i = 0; i < 1 + this.f_19796_.m_188503_(2); ++i) {
            this.m_19998_((ItemLike)ItemRegistry.RIPPING_FLESH.get());
            for (int j = 0; j < 1 + this.f_19796_.m_188503_(2); ++j) {
                this.m_19998_((ItemLike)Items.f_42416_);
            }
        }
    }

    public void m_6667_(DamageSource pDamageSource) {
        this.m_146870_();
        this.vanish();
        super.m_6667_(pDamageSource);
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        return false;
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        Player player;
        Entity entity;
        if (pSource.m_7639_() != null && (entity = pSource.m_7639_()) instanceof Player && (player = (Player)entity).m_21205_().m_41720_() instanceof PickaxeItem) {
            this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_12008_, SoundSource.HOSTILE, 1.0f, 0.65f);
            return super.m_6469_(pSource, pAmount);
        }
        this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)SoundRegistry.FLOODED_GOLEM_ARMOR_HIT.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
        return false;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return null;
    }

    public int m_20146_() {
        return super.m_6062_();
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        this.randomizeScale(3.25f);
        this.stackScaler.randomizeScale(this.f_19796_, 2.2f);
        return super.m_6518_(pLevel, pDifficulty, pReason, spawnGroupData, compoundTag);
    }

    public boolean m_6785_(double pDistanceToClosestPlayer) {
        return pDistanceToClosestPlayer > 16384.0;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

