/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.entity.custom.special;

import mod.chloeprime.aaaparticles.api.common.AAALevel;
import mod.chloeprime.aaaparticles.api.common.ParticleEmitterInfo;
import net.asestefan.screenshake.ScreenShakeUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.teamabyssalofficial.entity.custom.CarrierFormEntity;
import net.teamabyssalofficial.entity.custom.MarineFormEntity;
import net.teamabyssalofficial.entity.custom.PodInfectorEntity;
import net.teamabyssalofficial.entity.custom.SangheiliFormEntity;
import net.teamabyssalofficial.registry.EffectRegistry;
import net.teamabyssalofficial.registry.EntityRegistry;
import net.teamabyssalofficial.registry.ParticleResourceRegistry;
import net.teamabyssalofficial.registry.SoundRegistry;
import net.teamabyssalofficial.util.ConstantUtils;
import net.teamabyssalofficial.util.PerformanceEngine;

public class PortalEntity
extends Entity {
    private static final EntityDataAccessor<Float> PORTAL_SIZE = SynchedEntityData.m_135353_(PortalEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final int ACTIVE_TICKS = ConstantUtils.toTicksFromMinutes(5);
    private static final short TICK_DELAY = 2;
    private final boolean activeParticle = false;

    public PortalEntity(EntityType<?> type, Level world) {
        super(type, world);
    }

    public PortalEntity(Level world, Vec3 position) {
        super((EntityType)EntityRegistry.PORTAL.get(), world);
        this.m_6034_(position.f_82479_, position.f_82480_, position.f_82481_);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(PORTAL_SIZE, (Object)Float.valueOf(1.05f));
    }

    protected void m_7378_(CompoundTag compound) {
        this.setPortalSize(compound.m_128457_("portalSize"));
        this.f_19797_ = compound.m_128451_("ticks_existed");
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128350_("portalSize", this.getPortalSize());
        compound.m_128405_("ticks_existed", this.f_19797_);
    }

    public float getPortalSize() {
        return ((Float)this.f_19804_.m_135370_(PORTAL_SIZE)).floatValue();
    }

    public void setPortalSize(float size) {
        this.f_19804_.m_135381_(PORTAL_SIZE, (Object)Float.valueOf(size));
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ > ACTIVE_TICKS + 2) {
            this.m_146870_();
        } else if (this.f_19796_.m_188503_(600) == 0 && !this.m_9236_().m_5776_()) {
            int rand = this.f_19796_.m_188503_(19);
            switch (rand) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    this.spawnSangheili(this);
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    this.spawnCarrier(this);
                    break;
                }
                case 12: 
                case 13: 
                case 14: {
                    this.spawnPod(this);
                    break;
                }
                default: {
                    this.spawnMarine(this);
                }
            }
        }
    }

    private void spawnSangheili(Entity entity) {
        SangheiliFormEntity sangheiliFormEntity = new SangheiliFormEntity((EntityType<? extends Monster>)((EntityType)EntityRegistry.SANGHEILI_FORM.get()), entity.m_9236_());
        sangheiliFormEntity.m_6027_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
        sangheiliFormEntity.m_6518_((ServerLevelAccessor)((ServerLevel)sangheiliFormEntity.m_9236_()), sangheiliFormEntity.m_9236_().m_6436_(sangheiliFormEntity.m_20183_()), MobSpawnType.TRIGGERED, null, null);
        entity.m_9236_().m_7967_((Entity)sangheiliFormEntity);
        sangheiliFormEntity.m_5997_(this.f_19796_.m_188583_() * (double)0.15f, 0.1f, this.f_19796_.m_188583_() * (double)0.55f);
        sangheiliFormEntity.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.FROM_THE_SOURCE.get(), 200, 0));
        entity.m_9236_().m_5594_(null, entity.m_20183_(), (SoundEvent)SoundRegistry.PORTAL_ENTITY_SPAWN.get(), SoundSource.HOSTILE, 2.0f, 1.0f);
    }

    private void spawnCarrier(Entity entity) {
        CarrierFormEntity carrierFormEntity = new CarrierFormEntity((EntityType<? extends Monster>)((EntityType)EntityRegistry.CARRIER_FORM.get()), entity.m_9236_());
        carrierFormEntity.m_6027_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
        carrierFormEntity.m_6518_((ServerLevelAccessor)((ServerLevel)carrierFormEntity.m_9236_()), carrierFormEntity.m_9236_().m_6436_(carrierFormEntity.m_20183_()), MobSpawnType.TRIGGERED, null, null);
        entity.m_9236_().m_7967_((Entity)carrierFormEntity);
        carrierFormEntity.m_5997_(this.f_19796_.m_188583_() * (double)0.15f, 0.1f, this.f_19796_.m_188583_() * (double)0.55f);
        carrierFormEntity.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.FROM_THE_SOURCE.get(), 200, 0));
        entity.m_9236_().m_5594_(null, entity.m_20183_(), (SoundEvent)SoundRegistry.PORTAL_ENTITY_SPAWN.get(), SoundSource.HOSTILE, 2.0f, 1.0f);
    }

    private void spawnMarine(Entity entity) {
        MarineFormEntity marineFormEntity = new MarineFormEntity((EntityType<? extends Monster>)((EntityType)EntityRegistry.MARINE_FORM.get()), entity.m_9236_());
        marineFormEntity.m_6027_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
        marineFormEntity.m_6518_((ServerLevelAccessor)((ServerLevel)marineFormEntity.m_9236_()), marineFormEntity.m_9236_().m_6436_(marineFormEntity.m_20183_()), MobSpawnType.TRIGGERED, null, null);
        entity.m_9236_().m_7967_((Entity)marineFormEntity);
        marineFormEntity.m_5997_(this.f_19796_.m_188583_() * (double)0.15f, 0.1f, this.f_19796_.m_188583_() * (double)0.55f);
        marineFormEntity.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.FROM_THE_SOURCE.get(), 200, 0));
        entity.m_9236_().m_5594_(null, entity.m_20183_(), (SoundEvent)SoundRegistry.PORTAL_ENTITY_SPAWN.get(), SoundSource.HOSTILE, 2.0f, 1.0f);
    }

    private void spawnPod(Entity entity) {
        PodInfectorEntity podInfectorEntity = new PodInfectorEntity((EntityType<? extends Monster>)((EntityType)EntityRegistry.POD_INFECTOR.get()), entity.m_9236_());
        podInfectorEntity.m_6027_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
        podInfectorEntity.m_6518_((ServerLevelAccessor)((ServerLevel)podInfectorEntity.m_9236_()), podInfectorEntity.m_9236_().m_6436_(podInfectorEntity.m_20183_()), MobSpawnType.TRIGGERED, null, null);
        entity.m_9236_().m_7967_((Entity)podInfectorEntity);
        podInfectorEntity.m_5997_(this.f_19796_.m_188583_() * (double)0.15f, 0.1f, this.f_19796_.m_188583_() * (double)0.55f);
        podInfectorEntity.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.FROM_THE_SOURCE.get(), 200, 0));
        entity.m_9236_().m_5594_(null, entity.m_20183_(), (SoundEvent)SoundRegistry.PORTAL_ENTITY_SPAWN.get(), SoundSource.HOSTILE, 2.0f, 1.0f);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public static void addPortal(Level world, Vec3 position) {
        if (!world.f_46443_) {
            PortalEntity portal = new PortalEntity(world, position);
            world.m_7967_((Entity)portal);
            if (PerformanceEngine.canPerformShake(portal.m_20191_(), world, (double)PerformanceEngine.getShakeRadius(15))) {
                ScreenShakeUtils.ScreenShake((Level)world, (Vec3)portal.m_20182_(), (float)PerformanceEngine.getShakeRadius(15), (float)0.09f, (int)8, (int)3);
            }
            AAALevel.addParticle((Level)world, (boolean)true, (ParticleEmitterInfo)ParticleResourceRegistry.getPortal().clone().scale(1.75f).position(portal.m_20182_()));
            world.m_5594_(null, portal.m_20183_(), (SoundEvent)SoundRegistry.PORTAL_SPAWN.get(), SoundSource.MASTER, 4.0f, (1.0f + (world.f_46441_.m_188501_() - world.f_46441_.m_188501_()) * 0.2f) * 0.7f);
        }
    }
}

