/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.item;

import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.teamabyssalofficial.client.weapon.renderer.PlasmaGrenadeItemRenderer;
import net.teamabyssalofficial.dotf.playerlib.AnimationAbilityHandler;
import net.teamabyssalofficial.entity.custom.special.PlasmaGrenadeEntity;
import net.teamabyssalofficial.guns.helper.KeybindHelper;
import net.teamabyssalofficial.item.RenderedHandsItem;
import net.teamabyssalofficial.network.ServerNetworkHandler;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.cache.AnimatableIdCache;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;
import software.bernie.geckolib.util.RenderUtils;

public class PlasmaGrenadeItem
extends RenderedHandsItem
implements GeoAnimatable,
GeoItem {
    protected final AnimatableInstanceCache animationCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final int THROW_TICKS = 18;

    public PlasmaGrenadeItem(Item.Properties pProperties) {
        super(pProperties.m_41487_(6).setNoRepair());
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    private void setDefaultNBT(ItemStack stack) {
        CompoundTag nbtCompound = stack.m_41784_();
        nbtCompound.m_128405_("throwTick", 0);
    }

    public void m_7836_(ItemStack pStack, Level pLevel, Player pPlayer) {
        this.setDefaultNBT(pStack);
        if (pLevel instanceof ServerLevel) {
            long id = GeoItem.getOrAssignId((ItemStack)pStack, (ServerLevel)((ServerLevel)pLevel));
            this.triggerAnim((Entity)pPlayer, id, "grenade_controller", "idle");
        }
        super.m_7836_(pStack, pLevel, pPlayer);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        CompoundTag nbtCompound = stack.m_41784_();
        ItemStack mainHandGun = ((Player)entity).m_21205_();
        if (!nbtCompound.m_128425_("GeckoLibID", 99) && world instanceof ServerLevel) {
            nbtCompound.m_128356_("GeckoLibID", AnimatableIdCache.getFreeId((ServerLevel)((ServerLevel)world)));
        }
        if (nbtCompound.m_128451_("throwTick") > 0) {
            nbtCompound.m_128405_("throwTick", nbtCompound.m_128451_("throwTick") - 1);
        }
        long id = GeoItem.getId((ItemStack)stack);
        AnimationController animationController = (AnimationController)this.getAnimatableInstanceCache().getManagerForId(id).getAnimationControllers().get("grenade_controller");
        if (world.f_46443_) {
            Minecraft client = Minecraft.m_91087_();
            Options options = client.f_91066_;
            boolean canAnimate = options.m_92176_().m_90612_();
            if (animationController.getCurrentRawAnimation() != Animations.IDLE && !canAnimate) {
                animationController.tryTriggerAnimation("idle");
            }
            if (mainHandGun == stack && KeybindHelper.getShootMapping().m_90857_()) {
                boolean canPlayAnim;
                boolean bl = canPlayAnim = animationController.getCurrentRawAnimation() != Animations.THROW;
                if (canPlayAnim) {
                    if (canAnimate) {
                        animationController.tryTriggerAnimation("throw");
                    }
                    ServerNetworkHandler.sendC2SSendPlasmaTick(18);
                    AnimationAbilityHandler.INSTANCE.sendPlayerTryAbilityMessage((Player)entity, AnimationAbilityHandler.GRENADE_THROW);
                }
            }
            if (mainHandGun == stack && !entity.m_5833_()) {
                int throwTick = 12;
                if (nbtCompound.m_128451_("throwTick") == throwTick) {
                    ServerNetworkHandler.sendC2SSendPlasmaGrenade();
                }
            }
        }
    }

    public void throwPlasmaGrenade(Player player, ItemStack stack) {
        if (!(player instanceof Player) || !player.m_7500_()) {
            stack.m_41774_(1);
        }
        PlasmaGrenadeEntity grenade = this.create(player.m_9236_(), (LivingEntity)player, 100);
        grenade.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 1.0f, 1.0f);
        player.m_9236_().m_7967_((Entity)grenade);
        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
    }

    public PlasmaGrenadeEntity create(Level world, LivingEntity entity, int timeLeft) {
        return new PlasmaGrenadeEntity(world, entity, timeLeft);
    }

    public boolean m_8120_(ItemStack pStack) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private PlasmaGrenadeItemRenderer renderer;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.renderer == null) {
                    this.renderer = new PlasmaGrenadeItemRenderer();
                }
                return this.renderer;
            }
        });
    }

    private PlayState predicate(AnimationState<PlasmaGrenadeItem> event) {
        if (event.getController().getCurrentAnimation() == null || event.getController().getAnimationState() == AnimationController.State.STOPPED) {
            event.getController().tryTriggerAnimation("idle");
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animationCache;
    }

    public double getTick(Object itemStack) {
        return RenderUtils.getCurrentTick();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        AnimationController grenade_controller = new AnimationController((GeoAnimatable)this, "grenade_controller", 1, this::predicate).triggerableAnim("idle", Animations.IDLE).triggerableAnim("throw", Animations.THROW);
        controllers.add(new AnimationController[]{grenade_controller});
    }

    public static class Animations {
        public static final RawAnimation IDLE = RawAnimation.begin().thenLoop("idle");
        public static final RawAnimation THROW = RawAnimation.begin().then("throw", Animation.LoopType.PLAY_ONCE);
    }
}

