/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.mixin;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.teamabyssalofficial.guns.gun.GunItem;
import net.teamabyssalofficial.item.EnergySwordItem;
import net.teamabyssalofficial.item.FragmentGrenadeItem;
import net.teamabyssalofficial.item.PlasmaGrenadeItem;
import net.teamabyssalofficial.item.RenderedHandsItem;
import org.spongepowered.asm.mixin.Debug;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Debug(export=true)
@Mixin(value={Player.class})
public abstract class PlayerEntityMixin
extends LivingEntity {
    protected PlayerEntityMixin(EntityType<? extends LivingEntity> entityType, Level world) {
        super(entityType, world);
    }

    @Inject(method={"drop(Lnet/minecraft/world/item/ItemStack;Z)Lnet/minecraft/world/entity/item/ItemEntity;"}, at={@At(value="HEAD")})
    private void resetGunBeforeDrop(ItemStack pItemStack, boolean pIncludeThrowerName, CallbackInfoReturnable<ItemEntity> cir) {
        if (pItemStack.m_41720_() instanceof GunItem) {
            CompoundTag tag = pItemStack.m_41784_();
            tag.m_128405_("reloadTick", 0);
            tag.m_128379_("isReloading", false);
            tag.m_128379_("isAiming", false);
            tag.m_128379_("isInspecting", false);
        } else if (pItemStack.m_41720_() instanceof EnergySwordItem) {
            CompoundTag tag = pItemStack.m_41784_();
            tag.m_128405_("attackTick", 0);
            tag.m_128344_("attackID", (byte)0);
        } else if (pItemStack.m_41720_() instanceof FragmentGrenadeItem || pItemStack.m_41720_() instanceof PlasmaGrenadeItem) {
            CompoundTag tag = pItemStack.m_41784_();
            tag.m_128405_("throwTick", 0);
        }
    }

    @Inject(method={"attack"}, at={@At(value="HEAD")}, cancellable=true)
    private void sweepMeleeIfGun(Entity target, CallbackInfo ci) {
        if (this.m_21205_().m_41720_() instanceof GunItem || this.m_21205_().m_41720_() instanceof RenderedHandsItem) {
            ci.cancel();
        }
    }

    @Inject(method={"resetAttackStrengthTicker"}, at={@At(value="HEAD")}, cancellable=true)
    private void dontResetIfGun(CallbackInfo ci) {
        if (this.m_21205_().m_41720_() instanceof GunItem || this.m_21205_().m_41720_() instanceof RenderedHandsItem) {
            ci.cancel();
        }
    }
}

