/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.util;

import net.minecraft.server.level.ServerLevel;
import net.teamabyssalofficial.dotf.config.DawnOfTheFloodConfig;
import net.teamabyssalofficial.util.LevelGetterInterface;
import net.teamabyssalofficial.util.WorldDataUtils;

public class ConstantUtils {
    public static int getMobCap() {
        ServerLevel world = LevelGetterInterface.INSTANCE.level;
        int cap = (Integer)DawnOfTheFloodConfig.SERVER.mob_cap.get();
        if (world != null) {
            WorldDataUtils worldDataUtils = WorldDataUtils.getWorldDataRegistry(world);
            int currentWave = worldDataUtils.getWave();
            if (currentWave < 4) {
                return cap;
            }
            return switch (currentWave) {
                case 4 -> cap + 5;
                case 5 -> cap + 10;
                case 6 -> cap + 15;
                default -> cap + 20;
            };
        }
        return cap;
    }

    public static int toTicksFromSeconds(int pSeconds) {
        return pSeconds * 20;
    }

    public static int toTicksFromMinutes(int pMinutes) {
        return ConstantUtils.toTicksFromSeconds(pMinutes * 60);
    }

    public static int toSeconds(int pTicks) {
        return pTicks / 20;
    }

    public static int toMinutes(int pTicks) {
        return ConstantUtils.toSeconds(pTicks / 60);
    }
}

