#version 150

uniform sampler2D Sampler0;

uniform vec4 ColorModulator;
uniform float GameTime;

in vec4 vertexColor;
in vec2 texCoord0;

out vec4 fragColor;

void main()
{
    vec4 defaultColor = texture(Sampler0, texCoord0) * vertexColor;
    float atomicAnimation = GameTime * 1000.0;
    float redAnimation = sin(atomicAnimation / 1) + 1;
    float greenAnimation = sin(atomicAnimation / 2) + 1;
    float blueAnimation = sin(atomicAnimation / 3) + 1;
    vec4 shieldColor = vec4(0.3 + redAnimation, 0.3 + greenAnimation, 0.4 + blueAnimation, defaultColor.a);
    fragColor = shieldColor * ColorModulator;
}