#version 150

uniform sampler2D Sampler0;

uniform vec4 ColorModulator;
uniform float GameTime;

in vec4 vertexColor;
in vec2 texCoord0;

out vec4 fragColor;

void main()
{
    vec4 defaultColor = texture(Sampler0, texCoord0) * vertexColor;
    float atomicAnimation = GameTime * 500.0;
    float greenAnimation = sin(atomicAnimation / 3) + 1;
    vec4 floodColor = vec4(0.76, 0.96 + greenAnimation, 0.31, defaultColor.a);
    fragColor = floodColor * ColorModulator;
}