/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util;

import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.gui.interfaces.IMessageConsumer;
import fi.dy.masa.malilib.interfaces.IStringConsumer;
import fi.dy.masa.malilib.render.MessageRenderer;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.StringUtils;
import net.minecraft.class_156;
import net.minecraft.class_2378;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_7436;

public class InfoUtils {
    private static final MessageRenderer IN_GAME_MESSAGES = new MessageRenderer(-1610612736, 0).setBackgroundStyle(true, false).setCentered(true, false).setExpandUp(true);
    public static final IStringConsumer INFO_MESSAGE_CONSUMER = new InfoMessageConsumer();

    public static void showGuiMessage(Message.MessageType type, String translationKey, Object ... args) {
        InfoUtils.showGuiMessage(type, 5000, translationKey, args);
    }

    public static void showGuiMessage(Message.MessageType type, int lifeTime, String translationKey, Object ... args) {
        if (GuiUtils.getCurrentScreen() instanceof IMessageConsumer) {
            ((IMessageConsumer)GuiUtils.getCurrentScreen()).addMessage(type, lifeTime, translationKey, args);
        }
    }

    public static void showGuiOrActionBarMessage(Message.MessageType type, String translationKey, Object ... args) {
        InfoUtils.showGuiOrActionBarMessage(type, 5000, translationKey, args);
    }

    public static void showGuiOrActionBarMessage(Message.MessageType type, int lifeTime, String translationKey, Object ... args) {
        if (GuiUtils.getCurrentScreen() instanceof IMessageConsumer) {
            ((IMessageConsumer)GuiUtils.getCurrentScreen()).addMessage(type, lifeTime, translationKey, args);
        } else {
            String msg = type.getFormatting() + StringUtils.translate(translationKey, args) + GuiBase.TXT_RST;
            InfoUtils.printActionbarMessage(msg, new Object[0]);
        }
    }

    public static void showGuiOrInGameMessage(Message.MessageType type, String translationKey, Object ... args) {
        InfoUtils.showGuiOrInGameMessage(type, 5000, translationKey, args);
    }

    public static void showGuiOrInGameMessage(Message.MessageType type, int lifeTime, String translationKey, Object ... args) {
        if (GuiUtils.getCurrentScreen() instanceof IMessageConsumer) {
            ((IMessageConsumer)GuiUtils.getCurrentScreen()).addMessage(type, lifeTime, translationKey, args);
        } else {
            InfoUtils.showInGameMessage(type, lifeTime, translationKey, args);
        }
    }

    public static void showGuiAndInGameMessage(Message.MessageType type, String translationKey, Object ... args) {
        InfoUtils.showGuiAndInGameMessage(type, 5000, translationKey, args);
    }

    public static void showGuiAndInGameMessage(Message.MessageType type, int lifeTime, String translationKey, Object ... args) {
        InfoUtils.showGuiMessage(type, lifeTime, translationKey, args);
        InfoUtils.showInGameMessage(type, lifeTime, translationKey, args);
    }

    public static void printActionbarMessage(String key, Object ... args) {
        InfoUtils.sendVanillaMessage((class_5321<class_2556>)class_2556.field_11733, class_2561.method_43469((String)key, (Object[])args));
    }

    public static void showInGameMessage(Message.MessageType type, String translationKey, Object ... args) {
        InfoUtils.showInGameMessage(type, 5000, translationKey, args);
    }

    public static void showInGameMessage(Message.MessageType type, int lifeTime, String translationKey, Object ... args) {
        IN_GAME_MESSAGES.addMessage(type, lifeTime, translationKey, args);
    }

    public static void printBooleanConfigToggleMessage(String prettyName, boolean newValue) {
        String pre = newValue ? GuiBase.TXT_GREEN : GuiBase.TXT_RED;
        String status = StringUtils.translate("malilib.message.value." + (newValue ? "on" : "off"), new Object[0]);
        String message = StringUtils.translate("malilib.message.toggled", prettyName, pre + status + GuiBase.TXT_RST);
        InfoUtils.printActionbarMessage(message, new Object[0]);
    }

    public static void renderInGameMessages(class_4587 matrixStack) {
        int x = GuiUtils.getScaledWindowWidth() / 2;
        int y = GuiUtils.getScaledWindowHeight() - 76;
        IN_GAME_MESSAGES.drawMessages(x, y, matrixStack);
    }

    public static void sendVanillaMessage(class_5321<class_2556> messageTypeKey, class_5250 message) {
        class_638 world = class_310.method_1551().field_1687;
        if (world != null) {
            class_2556 type = (class_2556)world.method_30349().method_30530(class_2378.field_39205).method_29107(messageTypeKey);
            class_7436 sender = new class_7436(class_156.field_25140, (class_2561)message);
            class_310.method_1551().field_1705.method_43592(type, (class_2561)message, sender);
        }
    }

    public static class InfoMessageConsumer
    implements IStringConsumer {
        @Override
        public void setString(String string) {
            InfoUtils.sendVanillaMessage((class_5321<class_2556>)class_2556.field_11733, class_2561.method_43470((String)string));
        }
    }
}

