/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.templates.block;

import io.github.cottonmc.templates.Templates;
import io.github.cottonmc.templates.api.TemplateInteractionUtil;
import io.github.cottonmc.templates.api.ThemeableBlockEntity;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_7871;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class TemplateEntity
extends class_2586
implements ThemeableBlockEntity {
    protected class_2680 renderedState = class_2246.field_10124.method_9564();
    protected byte bitfield = (byte)16;
    protected static final int SPENT_GLOWSTONE_DUST_MASK = 1;
    protected static final int SPENT_REDSTONE_TORCH_MASK = 2;
    protected static final int SPENT_POPPED_CHORUS_MASK = 4;
    protected static final int EMITS_REDSTONE_MASK = 8;
    protected static final int IS_SOLID_MASK = 16;
    protected static final byte DEFAULT_BITFIELD = 16;
    protected static final String BLOCKSTATE_KEY = "s";
    protected static final String BITFIELD_KEY = "b";

    public TemplateEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        class_2680 lastRenderedState = this.renderedState;
        if (tag.method_10545("BlockState")) {
            this.renderedState = class_2512.method_10681((class_7871)class_7923.field_41175.method_46771(), (class_2487)tag.method_10562("BlockState"));
            if (tag.method_10577("spentglow")) {
                this.spentGlowstoneDust();
            }
            if (tag.method_10577("spentredst")) {
                this.spentRedstoneTorch();
            }
            if (tag.method_10577("spentchor")) {
                this.spentPoppedChorus();
            }
            this.setEmitsRedstone(tag.method_10577("emitsredst"));
            this.setSolidity(!tag.method_10545("solid") || tag.method_10577("solid"));
        } else {
            this.renderedState = class_2512.method_10681((class_7871)class_7923.field_41175.method_46771(), (class_2487)tag.method_10562(BLOCKSTATE_KEY));
            this.bitfield = (byte)(tag.method_10545(BITFIELD_KEY) ? (int)tag.method_10571(BITFIELD_KEY) : 16);
        }
        if (this.field_11863 != null && this.field_11863.field_9236 && !Objects.equals(lastRenderedState, this.renderedState)) {
            Templates.chunkRerenderProxy.accept(this.field_11863, this.field_11867);
        }
    }

    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        if (this.renderedState != class_2246.field_10124.method_9564()) {
            tag.method_10566(BLOCKSTATE_KEY, (class_2520)class_2512.method_10686((class_2680)this.renderedState));
        }
        if (this.bitfield != 16) {
            tag.method_10567(BITFIELD_KEY, this.bitfield);
        }
    }

    @Nonnull
    public static class_2680 readStateFromItem(class_1799 stack) {
        class_2520 subElement;
        class_2487 blockEntityTag = class_1747.method_38072((class_1799)stack);
        if (blockEntityTag == null) {
            return class_2246.field_10124.method_9564();
        }
        if (blockEntityTag.method_10545(BLOCKSTATE_KEY)) {
            subElement = blockEntityTag.method_10580(BLOCKSTATE_KEY);
        } else if (blockEntityTag.method_10545("BlockState")) {
            subElement = blockEntityTag.method_10580("BlockState");
        } else {
            return class_2246.field_10124.method_9564();
        }
        if (!(subElement instanceof class_2487)) {
            return class_2246.field_10124.method_9564();
        }
        class_2487 subCompound = (class_2487)subElement;
        return class_2512.method_10681((class_7871)class_7923.field_41175.method_46771(), (class_2487)subCompound);
    }

    @Nullable
    public static class_2680 weirdNbtLightLevelStuff(@Nullable class_2680 state, class_1799 stack) {
        if (state == null || stack == null) {
            return state;
        }
        class_2487 blockEntityTag = class_1747.method_38072((class_1799)stack);
        if (blockEntityTag == null) {
            return state;
        }
        if (state.method_28498((class_2769)TemplateInteractionUtil.LIGHT)) {
            state = (class_2680)state.method_11657((class_2769)TemplateInteractionUtil.LIGHT, (Comparable)Boolean.valueOf(blockEntityTag.method_10577("spentglow") || ((blockEntityTag.method_10545(BITFIELD_KEY) ? (int)blockEntityTag.method_10571(BITFIELD_KEY) : 16) & 1) != 0 || TemplateEntity.readStateFromItem(stack).method_26213() != 0));
        }
        return state;
    }

    public class_2680 getRenderAttachmentData() {
        return this.renderedState;
    }

    public void setRenderedState(class_2680 newState) {
        if (!Objects.equals(this.renderedState, newState)) {
            this.renderedState = newState;
            this.markDirtyAndDispatch();
        }
    }

    public boolean hasSpentGlowstoneDust() {
        return (this.bitfield & 1) != 0;
    }

    public void spentGlowstoneDust() {
        this.bitfield = (byte)(this.bitfield | 1);
        this.markDirtyAndDispatch();
    }

    public boolean hasSpentRedstoneTorch() {
        return (this.bitfield & 2) != 0;
    }

    public void spentRedstoneTorch() {
        this.bitfield = (byte)(this.bitfield | 2);
        this.markDirtyAndDispatch();
    }

    public boolean hasSpentPoppedChorus() {
        return (this.bitfield & 4) != 0;
    }

    public void spentPoppedChorus() {
        this.bitfield = (byte)(this.bitfield | 4);
        this.markDirtyAndDispatch();
    }

    public boolean emitsRedstone() {
        return (this.bitfield & 8) != 0;
    }

    public void setEmitsRedstone(boolean nextEmitsRedstone) {
        boolean currentlyEmitsRedstone = this.emitsRedstone();
        if (currentlyEmitsRedstone != nextEmitsRedstone) {
            this.bitfield = currentlyEmitsRedstone ? (byte)(this.bitfield & 0xFFFFFFF7) : (byte)(this.bitfield | 8);
            this.markDirtyAndDispatch();
            if (this.field_11863 != null) {
                this.field_11863.method_8408(this.field_11867, this.method_11010().method_26204());
            }
        }
    }

    public boolean isSolid() {
        return (this.bitfield & 0x10) != 0;
    }

    public void setSolidity(boolean nextSolid) {
        boolean currentlySolid = this.isSolid();
        if (currentlySolid != nextSolid) {
            this.bitfield = currentlySolid ? (byte)(this.bitfield & 0xFFFFFFEF) : (byte)(this.bitfield | 0x10);
            this.markDirtyAndDispatch();
            if (this.field_11863 != null) {
                this.field_11863.method_8501(this.field_11867, this.method_11010());
            }
        }
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    protected void dispatch() {
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 sworld = (class_3218)class_19372;
            sworld.method_14178().method_14128(this.field_11867);
        }
    }

    protected void markDirtyAndDispatch() {
        this.method_5431();
        this.dispatch();
    }
}

