/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.templates.model;

import io.github.cottonmc.templates.block.TemplateEntity;
import io.github.cottonmc.templates.mixin.MinecraftAccessor;
import io.github.cottonmc.templates.model.MeshTransformUtil;
import io.github.cottonmc.templates.model.TemplateAppearance;
import io.github.cottonmc.templates.model.TemplateAppearanceManager;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.model.ForwardingBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.fabricmc.fabric.api.rendering.data.v1.RenderAttachedBlockView;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3665;
import net.minecraft.class_5819;

public abstract class RetexturingBakedModel
extends ForwardingBakedModel {
    protected final TemplateAppearanceManager tam;
    protected final Map<class_2350, class_2350> facePermutation;
    protected final boolean uvlock;
    protected final class_2680 itemModelState;
    protected final boolean ao;
    protected final ConcurrentMap<CacheKey, Mesh> retexturedMeshes = new ConcurrentHashMap<CacheKey, Mesh>();
    protected static final class_2350[] DIRECTIONS = class_2350.values();
    protected static final class_2350[] DIRECTIONS_AND_NULL = new class_2350[DIRECTIONS.length + 1];

    public RetexturingBakedModel(class_1087 baseModel, TemplateAppearanceManager tam, class_3665 settings, class_2680 itemModelState, boolean ao) {
        this.wrapped = baseModel;
        this.tam = tam;
        this.facePermutation = MeshTransformUtil.facePermutation(settings);
        this.uvlock = settings.method_3512();
        this.itemModelState = itemModelState;
        this.ao = ao;
    }

    protected abstract Mesh getBaseMesh(class_2680 var1);

    public boolean isVanillaAdapter() {
        return false;
    }

    public class_1058 method_4711() {
        return this.tam.getDefaultAppearance().getSprite(class_2350.field_11036);
    }

    public void emitBlockQuads(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, RenderContext context) {
        class_2680 s;
        class_2680 theme;
        Object object = ((RenderAttachedBlockView)blockView).getBlockEntityRenderAttachment(pos);
        class_2680 class_26802 = theme = object instanceof class_2680 ? (s = (class_2680)object) : null;
        if (theme == null || theme.method_26215()) {
            this.getUntintedRetexturedMesh(new CacheKey(state, this.tam.getDefaultAppearance())).outputTo(context.getEmitter());
            return;
        }
        if (theme.method_26204() == class_2246.field_10499) {
            return;
        }
        theme = theme.getAppearance(blockView, pos, class_2350.field_11033, theme, pos);
        TemplateAppearance ta = this.tam.getAppearance(theme);
        int tint = 0xFF000000 | class_310.method_1551().method_1505().method_1697(theme, blockView, pos, 0);
        Mesh untintedMesh = this.getUntintedRetexturedMesh(new CacheKey(state, ta));
        if (tint == -1) {
            untintedMesh.outputTo(context.getEmitter());
        } else {
            context.pushTransform((RenderContext.QuadTransform)new TintingTransformer(ta, tint));
            untintedMesh.outputTo(context.getEmitter());
            context.popTransform();
        }
    }

    public void emitItemQuads(class_1799 stack, Supplier<class_5819> randomSupplier, RenderContext context) {
        int tint;
        TemplateAppearance nbtAppearance;
        class_2680 theme = TemplateEntity.readStateFromItem(stack);
        if (!theme.method_26215()) {
            nbtAppearance = this.tam.getAppearance(theme);
            tint = 0xFF000000 | ((MinecraftAccessor)class_310.method_1551()).templates$getItemColors().method_1704(new class_1799((class_1935)theme.method_26204()), 0);
        } else {
            nbtAppearance = this.tam.getDefaultAppearance();
            tint = -1;
        }
        Mesh untintedMesh = this.getUntintedRetexturedMesh(new CacheKey(this.itemModelState, nbtAppearance));
        if (tint == -1) {
            untintedMesh.outputTo(context.getEmitter());
        } else {
            context.pushTransform((RenderContext.QuadTransform)new TintingTransformer(nbtAppearance, tint));
            untintedMesh.outputTo(context.getEmitter());
            context.popTransform();
        }
    }

    protected Mesh getUntintedRetexturedMesh(CacheKey key) {
        return this.retexturedMeshes.computeIfAbsent(key, this::createUntintedRetexturedMesh);
    }

    protected Mesh createUntintedRetexturedMesh(CacheKey key) {
        return MeshTransformUtil.pretransformMesh(this.getBaseMesh(key.state), new RetexturingTransformer(key.appearance));
    }

    @Deprecated(forRemoval=true)
    public RetexturingBakedModel(class_1087 baseModel, TemplateAppearanceManager tam, class_3665 settings, class_2680 itemModelState) {
        this(baseModel, tam, settings, itemModelState, true);
    }

    static {
        System.arraycopy(DIRECTIONS, 0, DIRECTIONS_AND_NULL, 0, DIRECTIONS.length);
    }

    protected record CacheKey(class_2680 state, TemplateAppearance appearance) {
    }

    protected class TintingTransformer
    implements RenderContext.QuadTransform {
        protected final TemplateAppearance ta;
        protected final int tint;

        protected TintingTransformer(TemplateAppearance ta, int tint) {
            this.ta = ta;
            this.tint = tint;
        }

        public boolean transform(MutableQuadView quad) {
            int tag = quad.tag();
            if (tag == 0) {
                return true;
            }
            class_2350 dir = RetexturingBakedModel.this.facePermutation.get(DIRECTIONS[quad.tag() - 1]);
            if (this.ta.hasColor(dir)) {
                quad.color(this.tint, this.tint, this.tint, this.tint);
            }
            return true;
        }
    }

    protected class RetexturingTransformer
    implements RenderContext.QuadTransform {
        protected final TemplateAppearance ta;

        protected RetexturingTransformer(TemplateAppearance ta) {
            this.ta = ta;
        }

        @Deprecated(forRemoval=true)
        protected RetexturingTransformer(TemplateAppearance ta, int ignoredTint) {
            this(ta);
        }

        public boolean transform(MutableQuadView quad) {
            quad.material(this.ta.getRenderMaterial(RetexturingBakedModel.this.ao));
            int tag = quad.tag();
            if (tag == 0) {
                return true;
            }
            class_2350 dir = RetexturingBakedModel.this.facePermutation.get(DIRECTIONS[quad.tag() - 1]);
            quad.spriteBake(this.ta.getSprite(dir), 0x20 | this.ta.getBakeFlags(dir) | (RetexturingBakedModel.this.uvlock ? 4 : 0));
            return true;
        }
    }
}

