/*
 * Decompiled with CFR 0.152.
 */
package net.ardcameg.potion_overflow.init;

import net.ardcameg.potion_overflow.potion.AncientKnowledgeMobEffect;
import net.ardcameg.potion_overflow.potion.CantBuildMobEffect;
import net.ardcameg.potion_overflow.potion.DivineWingsMobEffect;
import net.ardcameg.potion_overflow.potion.EbonyDespairWingsMobEffect;
import net.ardcameg.potion_overflow.potion.EnderMobEffect;
import net.ardcameg.potion_overflow.potion.GlitteringInvocationMobEffect;
import net.ardcameg.potion_overflow.potion.InferiorMobEffect;
import net.ardcameg.potion_overflow.potion.NoiseMobEffect;
import net.ardcameg.potion_overflow.potion.TeleportRemainMobEffect;
import net.ardcameg.potion_overflow.procedures.TeleportRemainLimitedProcedure;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber
public class PotionOverflowModMobEffects {
    public static final DeferredRegister<MobEffect> REGISTRY = DeferredRegister.create((ResourceKey)Registries.MOB_EFFECT, (String)"potion_overflow");
    public static final DeferredHolder<MobEffect, MobEffect> INFERIOR = REGISTRY.register("inferior", () -> new InferiorMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> ENDER = REGISTRY.register("ender", () -> new EnderMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> TELEPORT_REMAIN = REGISTRY.register("teleport_remain", () -> new TeleportRemainMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> NOISE = REGISTRY.register("noise", () -> new NoiseMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> CANT_BUILD = REGISTRY.register("cant_build", () -> new CantBuildMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> ANCIENT_KNOWLEDGE = REGISTRY.register("ancient_knowledge", () -> new AncientKnowledgeMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> DIVINE_WINGS = REGISTRY.register("divine_wings", () -> new DivineWingsMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> GLITTERING_INVOCATION = REGISTRY.register("glittering_invocation", () -> new GlitteringInvocationMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> EBONY_DESPAIR_WINGS = REGISTRY.register("ebony_despair_wings", () -> new EbonyDespairWingsMobEffect());

    @SubscribeEvent
    public static void onEffectRemoved(MobEffectEvent.Remove event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            PotionOverflowModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    @SubscribeEvent
    public static void onEffectExpired(MobEffectEvent.Expired event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            PotionOverflowModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    private static void expireEffects(Entity entity, MobEffectInstance effectInstance) {
        if (effectInstance.getEffect().is(TELEPORT_REMAIN)) {
            TeleportRemainLimitedProcedure.execute((LevelAccessor)entity.level(), entity);
        }
    }
}

