/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.addonpacks;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import lucraft.mods.lucraftcore.LucraftCore;
import lucraft.mods.lucraftcore.addonpacks.AddonPackConfig;
import lucraft.mods.lucraftcore.addonpacks.AddonPackInfo;
import lucraft.mods.lucraftcore.addonpacks.AddonPackReadEvent;
import lucraft.mods.lucraftcore.util.creativetabs.CreativeTabRegistry;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.FilenameUtils;

@Mod.EventBusSubscriber(modid="lucraftcore", value={Side.CLIENT})
public class AddonPackHandler {
    public static final List<AddonPackInfo> ADDON_PACKS = new ArrayList<AddonPackInfo>();
    public static int tabIconTimer = 0;
    public static int tabIconIndex = 0;
    public static CreativeTabs CREATIVE_TAB = new CreativeTabs("tabAddonPacks"){

        public ItemStack func_78016_d() {
            NonNullList items = NonNullList.func_191196_a();
            CREATIVE_TAB.func_78018_a(items);
            if (items.size() == 0) {
                return new ItemStack(Blocks.field_180401_cv);
            }
            if (tabIconIndex >= items.size()) {
                tabIconIndex = 0;
            }
            return (ItemStack)items.get(tabIconIndex);
        }
    };

    public static File getAddonPacksDir() {
        return new File(AddonPackConfig.addonpacksFolder);
    }

    public static void load() {
        CreativeTabRegistry.addCreativeTab("addon_packs", CREATIVE_TAB);
        LucraftCore.LOGGER.info("Loading addonpacks from '../" + AddonPackHandler.getAddonPacksDir().getName() + "'");
        if (!AddonPackHandler.getAddonPacksDir().exists()) {
            AddonPackHandler.getAddonPacksDir().mkdir();
        }
        for (ModContainer mod : Loader.instance().getActiveModList()) {
            if (mod.getSource() == null || mod.getName().equalsIgnoreCase("Minecraft") || mod.getName().equalsIgnoreCase("Minecraft Coder Pack") || mod.getName().equalsIgnoreCase("Forge Mod Loader") || mod.getName().equalsIgnoreCase("Minecraft Forge")) continue;
            if (mod.getSource().isDirectory()) {
                AddonPackHandler.processPackFolder(mod.getSource(), mod);
                continue;
            }
            if (!FilenameUtils.getExtension((String)mod.getSource().getName()).equalsIgnoreCase("zip") && !FilenameUtils.getExtension((String)mod.getSource().getName()).equalsIgnoreCase("jar")) continue;
            AddonPackHandler.processPackZip(mod.getSource(), mod);
        }
        for (File file : AddonPackHandler.getAddonPacksDir().listFiles()) {
            if (file.isDirectory()) {
                AddonPackHandler.processPackFolder(file, null);
                continue;
            }
            if (!FilenameUtils.getExtension((String)file.getName()).equalsIgnoreCase("zip") && !FilenameUtils.getExtension((String)file.getName()).equalsIgnoreCase("jar")) continue;
            AddonPackHandler.processPackZip(file, null);
        }
    }

    public static void processPackFolder(File file, ModContainer mod) {
        String path;
        List<File> files = AddonPackHandler.getFilesRecursively(file, new ArrayList<File>());
        AddonPackInfo info = null;
        if (mod == null) {
            LucraftCore.LOGGER.info("The addon-pack '" + file.getName() + "' is loading...");
        }
        for (File f : files) {
            path = f.getPath().replace(file.getPath(), "");
            path = path.replace("/", "\\");
            while (path.startsWith("\\")) {
                path = path.substring(1);
            }
            if (!path.equalsIgnoreCase("addonpack.mcmeta")) continue;
            try {
                FileInputStream stream = new FileInputStream(f);
                info = AddonPackHandler.readAddonPackInfo(stream, file.getName(), file);
                stream.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            break;
        }
        if (info == null) {
            if (mod == null) {
                LucraftCore.LOGGER.error("The addon-pack '" + file.getName() + "' is missing a addonpack.mcmeta file.");
            }
            return;
        }
        for (File f : files) {
            path = f.getPath().replace(file.getPath(), "");
            path = path.replace("/", "\\");
            while (path.startsWith("\\")) {
                path = path.substring(1);
            }
            String s = FilenameUtils.removeExtension((String)path).replace("assets\\", "");
            String[] astring = s.split("\\\\", 3);
            if (!f.isDirectory() && astring.length >= 3) {
                ResourceLocation loc = new ResourceLocation(astring[0], astring[2]);
                try {
                    FileInputStream stream = new FileInputStream(f);
                    MinecraftForge.EVENT_BUS.post((Event)new AddonPackReadEvent(stream, loc, file, f.getName(), astring[1], mod));
                    stream.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (!path.equalsIgnoreCase(info.getImageLocation()) || FMLCommonHandler.instance().getSide() != Side.CLIENT) continue;
            try {
                FileInputStream stream = new FileInputStream(f);
                info.image = ImageIO.read(stream);
                stream.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (mod != null) {
            info.setMod(mod);
        }
        LucraftCore.LOGGER.info("The addon-pack '" + file.getName() + "' has finished loading.");
        ADDON_PACKS.add(info);
    }

    public static void processPackZip(File file, ModContainer mod) {
        try {
            InputStream stream;
            ZipEntry entry;
            ZipFile zipFile = new ZipFile(file);
            String zipName = FilenameUtils.getName((String)zipFile.getName());
            AddonPackInfo info = null;
            if (mod == null) {
                LucraftCore.LOGGER.info("The addon-pack '" + zipName + "' is loading...");
            }
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                entry = entries.nextElement();
                if (!entry.getName().equals("addonpack.mcmeta") || entry.getName().replace("/", "\\").contains("\\")) continue;
                stream = zipFile.getInputStream(entry);
                info = AddonPackHandler.readAddonPackInfo(stream, zipFile.getName(), file);
                stream.close();
            }
            if (info == null) {
                if (mod == null) {
                    LucraftCore.LOGGER.error("The addon-pack '" + zipName + "' is missing a addonpack.mcmeta file.");
                }
                return;
            }
            entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                entry = entries.nextElement();
                stream = zipFile.getInputStream(entry);
                String s = FilenameUtils.removeExtension((String)entry.getName()).replace("assets/", "").replace("/", "\\");
                String[] astring = s.split("\\\\", 3);
                if (!entry.isDirectory() && astring.length >= 3) {
                    ResourceLocation loc = new ResourceLocation(astring[0], astring[2]);
                    MinecraftForge.EVENT_BUS.post((Event)new AddonPackReadEvent(stream, loc, file, entry.getName(), astring[1], mod));
                }
                if (entry.getName().equalsIgnoreCase(info.getImageLocation()) && FMLCommonHandler.instance().getSide() == Side.CLIENT) {
                    info.image = ImageIO.read(stream);
                }
                stream.close();
            }
            if (mod != null) {
                info.setMod(mod);
            }
            LucraftCore.LOGGER.info("The addon-pack '" + zipName + "' has finished loading.");
            ADDON_PACKS.add(info);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static AddonPackInfo readAddonPackInfo(InputStream stream, String zipName, File file) {
        BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
        JsonObject jsonobject = new JsonParser().parse((Reader)bufferedreader).getAsJsonObject();
        String name = "";
        String author = "";
        String desc = "";
        String icon = "";
        if (!JsonUtils.func_151204_g((JsonObject)jsonobject, (String)"name")) {
            LucraftCore.LOGGER.error("The addonpack.mcmeta of the addon-pack \"" + zipName + "\" is missing \"name\".");
            return null;
        }
        name = JsonUtils.func_151200_h((JsonObject)jsonobject, (String)"name");
        author = JsonUtils.func_151204_g((JsonObject)jsonobject, (String)"author") ? JsonUtils.func_151200_h((JsonObject)jsonobject, (String)"author") : "";
        desc = JsonUtils.func_151204_g((JsonObject)jsonobject, (String)"description") ? JsonUtils.func_151200_h((JsonObject)jsonobject, (String)"description") : "";
        icon = JsonUtils.func_151204_g((JsonObject)jsonobject, (String)"icon") ? JsonUtils.func_151200_h((JsonObject)jsonobject, (String)"icon") : "";
        return new AddonPackInfo(name, author, desc, icon, file);
    }

    public static List<File> getFilesRecursively(File folder, List<File> list) {
        if (folder == null || folder.list() == null) {
            return list;
        }
        for (File files : folder.listFiles()) {
            if (files.isDirectory()) {
                AddonPackHandler.getFilesRecursively(files, list);
                continue;
            }
            list.add(files);
        }
        return list;
    }

    @SideOnly(value=Side.CLIENT)
    public static void loadImages() {
        for (AddonPackInfo info : ADDON_PACKS) {
            info.registerIcon();
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onTick(TickEvent.ClientTickEvent e) {
        if (e.phase == TickEvent.Phase.END && ++tabIconTimer == 40) {
            NonNullList items = NonNullList.func_191196_a();
            CREATIVE_TAB.func_78018_a(items);
            if (++tabIconIndex >= items.size()) {
                tabIconIndex = 0;
            }
            tabIconTimer = 0;
        }
    }
}

