/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.addonpacks;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import lucraft.mods.lucraftcore.addonpacks.AddonPackReadEvent;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

@Mod.EventBusSubscriber(modid="lucraftcore")
public class AddonPackRecipeReader {
    private static Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static Map<String, List<RecipeCache>> recipes = new HashMap<String, List<RecipeCache>>();
    private static Map<String, JsonContextExt> contexts = new HashMap<String, JsonContextExt>();

    @SubscribeEvent
    public static void onRead(AddonPackReadEvent e) {
        if (e.getMod() == null && e.getDirectory().equals("recipes") && FilenameUtils.getExtension((String)e.getFileName()).equalsIgnoreCase("json")) {
            JsonContextExt ctx;
            BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(e.getInputStream(), StandardCharsets.UTF_8));
            JsonContextExt jsonContextExt = ctx = contexts.containsKey(e.getResourceLocation().func_110624_b()) ? contexts.get(e.getResourceLocation().func_110624_b()) : new JsonContextExt(e.getResourceLocation().func_110624_b());
            if (e.getFileName().endsWith("_constants.json")) {
                JsonObject[] json = (JsonObject[])JsonUtils.func_193839_a((Gson)GSON, (Reader)bufferedreader, JsonObject[].class);
                ctx.loadConstants(json);
            } else {
                JsonObject jsonobject = new JsonParser().parse((Reader)bufferedreader).getAsJsonObject();
                ArrayList<RecipeCache> list = recipes.containsKey(e.getResourceLocation().func_110624_b()) ? recipes.get(e.getResourceLocation().func_110624_b()) : new ArrayList<RecipeCache>();
                list.add(new RecipeCache(jsonobject, e.getResourceLocation()));
                recipes.put(e.getResourceLocation().func_110624_b(), list);
            }
            IOUtils.closeQuietly((Reader)bufferedreader);
            contexts.put(e.getResourceLocation().func_110624_b(), ctx);
        }
    }

    @SubscribeEvent
    public static void onRegisterRecipes(RegistryEvent.Register<IRecipe> e) {
        for (String modid : recipes.keySet()) {
            List<RecipeCache> list = recipes.get(modid);
            for (RecipeCache recipes : list) {
                try {
                    JsonContextExt ctx = contexts.containsKey(recipes.resourceLocation.func_110624_b()) ? contexts.get(recipes.resourceLocation.func_110624_b()) : new JsonContextExt(recipes.resourceLocation.func_110624_b());
                    JsonObject json = recipes.jsonObject;
                    if (!json.has("conditions") || CraftingHelper.processConditions((JsonArray)JsonUtils.func_151214_t((JsonObject)json, (String)"conditions"), (JsonContext)ctx)) {
                        IRecipe recipe = (IRecipe)CraftingHelper.getRecipe((JsonObject)json, (JsonContext)ctx).setRegistryName(recipes.resourceLocation);
                        e.getRegistry().register((IForgeRegistryEntry)recipe);
                    }
                    contexts.put(recipes.resourceLocation.func_110624_b(), ctx);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        contexts.clear();
        recipes.clear();
    }

    public static class JsonContextExt
    extends JsonContext {
        private Map<String, Ingredient> constants = Maps.newHashMap();

        public JsonContextExt(String modId) {
            super(modId);
        }

        @Nullable
        public Ingredient getConstant(String name) {
            return this.constants.get(name);
        }

        public void loadConstants(JsonObject[] jsons) {
            for (JsonObject json : jsons) {
                if (json.has("conditions") && !CraftingHelper.processConditions((JsonArray)json.getAsJsonArray("conditions"), (JsonContext)this)) continue;
                if (!json.has("ingredient")) {
                    throw new JsonSyntaxException("Constant entry must contain 'ingredient' value");
                }
                this.constants.put(JsonUtils.func_151200_h((JsonObject)json, (String)"name"), CraftingHelper.getIngredient((JsonElement)json.get("ingredient"), (JsonContext)this));
            }
        }
    }

    public static class RecipeCache {
        public JsonObject jsonObject;
        public ResourceLocation resourceLocation;

        public RecipeCache(JsonObject jsonObject, ResourceLocation resourceLocation) {
            this.jsonObject = jsonObject;
            this.resourceLocation = resourceLocation;
        }
    }
}

