/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.extendedinventory.capabilities;

import lucraft.mods.lucraftcore.extendedinventory.IItemExtendedInventory;
import lucraft.mods.lucraftcore.extendedinventory.InventoryExtendedInventory;
import lucraft.mods.lucraftcore.extendedinventory.capabilities.CapabilityExtendedInventoryProvider;
import lucraft.mods.lucraftcore.extendedinventory.capabilities.IExtendedInventoryCapability;
import lucraft.mods.lucraftcore.extendedinventory.network.MessageOpenExtendedInventory;
import lucraft.mods.lucraftcore.extendedinventory.network.MessageSyncExtendedInventory;
import lucraft.mods.lucraftcore.network.LCPacketDispatcher;
import lucraft.mods.lucraftcore.tabs.TabRegistry;
import lucraft.mods.lucraftcore.util.gui.buttons.GuiButton10x;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CapabilityExtendedInventory
implements IExtendedInventoryCapability {
    @CapabilityInject(value=IExtendedInventoryCapability.class)
    public static final Capability<IExtendedInventoryCapability> EXTENDED_INVENTORY_CAP = null;
    public EntityPlayer player;
    private InventoryExtendedInventory inventory;

    public CapabilityExtendedInventory(EntityPlayer player) {
        this.player = player;
        this.inventory = new InventoryExtendedInventory(player);
    }

    @Override
    public InventoryExtendedInventory getInventory() {
        return this.inventory;
    }

    @Override
    public NBTTagCompound writeNBT() {
        return this.inventory.writeToNBT(new NBTTagCompound());
    }

    @Override
    public void readNBT(NBTTagCompound nbt) {
        this.inventory.readFromNBT(nbt);
    }

    @Override
    public void syncToPlayer() {
        this.syncToPlayer(this.player);
    }

    @Override
    public void syncToPlayer(EntityPlayer receiver) {
        if (receiver instanceof EntityPlayerMP) {
            LCPacketDispatcher.sendTo(new MessageSyncExtendedInventory(this.player), (EntityPlayerMP)receiver);
        }
    }

    @Override
    public void syncToAll() {
        this.syncToPlayer();
        if (this.player.field_70170_p instanceof WorldServer) {
            for (EntityPlayer players : ((WorldServer)this.player.field_70170_p).func_73039_n().getTrackingPlayers((Entity)this.player)) {
                if (!(players instanceof EntityPlayerMP)) continue;
                LCPacketDispatcher.sendTo(new MessageSyncExtendedInventory(this.player), (EntityPlayerMP)players);
            }
        }
    }

    public static class CapabilityExtendedInventoryStorage
    implements Capability.IStorage<IExtendedInventoryCapability> {
        public NBTBase writeNBT(Capability<IExtendedInventoryCapability> capability, IExtendedInventoryCapability instance, EnumFacing side) {
            return instance.writeNBT();
        }

        public void readNBT(Capability<IExtendedInventoryCapability> capability, IExtendedInventoryCapability instance, EnumFacing side, NBTBase nbt) {
            instance.readNBT((NBTTagCompound)nbt);
        }
    }

    public static class CapabilityExtendedInventoryEventHandler {
        @SubscribeEvent
        public void onAttachCapabilities(AttachCapabilitiesEvent<Entity> evt) {
            if (!(evt.getObject() instanceof EntityPlayer) || ((Entity)evt.getObject()).hasCapability(EXTENDED_INVENTORY_CAP, null)) {
                return;
            }
            evt.addCapability(new ResourceLocation("lucraftcore", "extended_inventory"), (ICapabilityProvider)new CapabilityExtendedInventoryProvider(new CapabilityExtendedInventory((EntityPlayer)evt.getObject())));
        }

        @SubscribeEvent
        public void onPlayerStartTracking(PlayerEvent.StartTracking e) {
            if (e.getTarget().hasCapability(EXTENDED_INVENTORY_CAP, null)) {
                ((IExtendedInventoryCapability)e.getTarget().getCapability(EXTENDED_INVENTORY_CAP, null)).syncToPlayer(e.getEntityPlayer());
            }
        }

        @SubscribeEvent
        public void onEntityJoinWorld(EntityJoinWorldEvent e) {
            if (e.getEntity() instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)e.getEntity();
                IExtendedInventoryCapability data = (IExtendedInventoryCapability)player.getCapability(EXTENDED_INVENTORY_CAP, null);
                data.syncToAll();
            }
        }

        @SubscribeEvent
        public void onPlayerClone(PlayerEvent.Clone e) {
            NBTTagCompound compound = new NBTTagCompound();
            compound = (NBTTagCompound)EXTENDED_INVENTORY_CAP.getStorage().writeNBT(EXTENDED_INVENTORY_CAP, e.getOriginal().getCapability(EXTENDED_INVENTORY_CAP, null), null);
            EXTENDED_INVENTORY_CAP.getStorage().readNBT(EXTENDED_INVENTORY_CAP, e.getEntityPlayer().getCapability(EXTENDED_INVENTORY_CAP, null), null, (NBTBase)compound);
        }

        @SubscribeEvent
        public void onPlayerDrops(PlayerDropsEvent e) {
            if (!e.getEntityPlayer().field_70170_p.field_72995_K && !e.getEntityPlayer().field_70170_p.func_82736_K().func_82766_b("keepInventory") && e.getEntityPlayer().hasCapability(EXTENDED_INVENTORY_CAP, null)) {
                InventoryExtendedInventory inv = ((IExtendedInventoryCapability)e.getEntityPlayer().getCapability(EXTENDED_INVENTORY_CAP, null)).getInventory();
                for (int i = 0; i < 5; ++i) {
                    if (inv.func_70301_a(i).func_190926_b()) continue;
                    EntityItem en = new EntityItem(e.getEntityPlayer().field_70170_p, e.getEntityPlayer().field_70165_t, e.getEntityPlayer().field_70163_u + (double)e.getEntityPlayer().eyeHeight, e.getEntityPlayer().field_70161_v, inv.func_70301_a(i).func_77946_l());
                    en.func_174867_a(40);
                    float f1 = e.getEntityPlayer().field_70170_p.field_73012_v.nextFloat() * 0.5f;
                    float f2 = e.getEntityPlayer().field_70170_p.field_73012_v.nextFloat() * (float)Math.PI * 2.0f;
                    en.field_70159_w = -MathHelper.func_76126_a((float)f2) * f1;
                    en.field_70179_y = MathHelper.func_76134_b((float)f2) * f1;
                    en.field_70181_x = 0.2f;
                    e.getDrops().add(en);
                    inv.func_70299_a(i, ItemStack.field_190927_a);
                }
            }
        }

        @SubscribeEvent
        public void playerTick(LivingEvent.LivingUpdateEvent e) {
            EntityPlayer player;
            if (e.getEntity() instanceof EntityPlayer && (player = (EntityPlayer)e.getEntity()).hasCapability(EXTENDED_INVENTORY_CAP, null)) {
                InventoryExtendedInventory inv = ((IExtendedInventoryCapability)player.getCapability(EXTENDED_INVENTORY_CAP, null)).getInventory();
                for (int i = 0; i < inv.func_70302_i_(); ++i) {
                    ItemStack stack = inv.func_70301_a(i);
                    if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IItemExtendedInventory)) continue;
                    ((IItemExtendedInventory)stack.func_77973_b()).onWornTick(stack, player);
                }
            }
        }

        @SideOnly(value=Side.CLIENT)
        @SubscribeEvent
        public void onGuiOpen(GuiScreenEvent.InitGuiEvent.Post e) {
            if (e.getGui() instanceof GuiContainerCreative) {
                int k = (e.getGui().field_146294_l - 195) / 2;
                int l = (e.getGui().field_146295_m - 136) / 2;
                e.getButtonList().add(new GuiButton10x(52, k + 151, l + 142, "+"));
            }
        }

        @SideOnly(value=Side.CLIENT)
        @SubscribeEvent
        public void onButtonPressPre(GuiScreenEvent.ActionPerformedEvent.Post e) {
            if (e.getGui() instanceof GuiContainerCreative && e.getButton().field_146127_k == 52 && TabRegistry.getTabList().size() > 1) {
                LCPacketDispatcher.sendToServer(new MessageOpenExtendedInventory());
            }
        }
    }
}

