/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.infinity.items;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import lucraft.mods.lucraftcore.LucraftCore;
import lucraft.mods.lucraftcore.infinity.EntityItemIndestructible;
import lucraft.mods.lucraftcore.infinity.ModuleInfinity;
import lucraft.mods.lucraftcore.infinity.items.InventoryInfinityGauntlet;
import lucraft.mods.lucraftcore.infinity.items.ItemIndestructible;
import lucraft.mods.lucraftcore.infinity.items.ItemInfinityStone;
import lucraft.mods.lucraftcore.superpowers.abilities.Ability;
import lucraft.mods.lucraftcore.superpowers.abilities.supplier.IAbilityProvider;
import lucraft.mods.lucraftcore.util.helper.StringHelper;
import lucraft.mods.lucraftcore.util.items.ExtendedTooltip;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ItemInfinityGauntlet
extends ItemIndestructible
implements ExtendedTooltip.IExtendedItemToolTip,
IAbilityProvider {
    public float attackDamage = 5.0f;

    public ItemInfinityGauntlet(String name) {
        this.func_77655_b(name);
        this.setRegistryName(StringHelper.unlocalizedToResourceName(name));
        this.func_77625_d(1);
        this.func_77637_a(ModuleInfinity.TAB);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            ItemStack stack = new ItemStack((Item)this);
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74757_a("Fist", true);
            stack.func_77982_d(nbt);
            items.add((Object)stack);
        }
    }

    public boolean onDroppedByPlayer(ItemStack item, EntityPlayer player) {
        if (!item.func_77942_o()) {
            item.func_77982_d(new NBTTagCompound());
        }
        item.func_77978_p().func_74757_a("Fist", false);
        return super.onDroppedByPlayer(item, player);
    }

    @Override
    public boolean onItemPickUp(World world, EntityPlayer player, ItemStack stack, EntityItemIndestructible entity) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74757_a("Fist", true);
        return super.onItemPickUp(world, player, stack, entity);
    }

    public void func_77622_d(ItemStack stack, World worldIn, EntityPlayer playerIn) {
        stack.func_77982_d(new NBTTagCompound());
        stack.func_77978_p().func_74757_a("Fist", true);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        if (handIn == EnumHand.MAIN_HAND) {
            if (!playerIn.func_184586_b(handIn).func_77942_o()) {
                playerIn.func_184586_b(handIn).func_77982_d(new NBTTagCompound());
            }
            playerIn.openGui((Object)LucraftCore.INSTANCE, 50, worldIn, (int)playerIn.field_70165_t, (int)playerIn.field_70163_u, (int)playerIn.field_70161_v);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(handIn));
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (stack.func_77942_o()) {
            if (isSelected) {
                InventoryInfinityGauntlet inv = new InventoryInfinityGauntlet(stack);
                for (int i = 0; i < inv.func_70302_i_(); ++i) {
                    ItemStack s = inv.func_70301_a(i);
                    if (s.func_190926_b() || !(s.func_77973_b() instanceof ItemInfinityStone)) continue;
                    ((ItemInfinityStone)s.func_77973_b()).onGauntletTick(entityIn, worldIn, stack);
                }
            } else if (stack.func_77978_p().func_74762_e("GrabbedEntity") != 0) {
                stack.func_77978_p().func_74768_a("GrabbedEntity", 0);
            }
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.func_77973_b() != newStack.func_77973_b();
    }

    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot equipmentSlot) {
        Multimap multimap = super.func_111205_h(equipmentSlot);
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.attackDamage, 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)-2.4f, 0));
        }
        return multimap;
    }

    @Override
    public boolean shouldShiftTooltipAppear(ItemStack stack, EntityPlayer player) {
        return stack.func_77942_o() && !new InventoryInfinityGauntlet(stack).func_191420_l();
    }

    @Override
    public List<String> getShiftToolTip(ItemStack stack, EntityPlayer player) {
        ArrayList<String> list = new ArrayList<String>();
        if (stack.func_77942_o()) {
            InventoryInfinityGauntlet inv = new InventoryInfinityGauntlet(stack);
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack s = inv.func_70301_a(i);
                if (s.func_190926_b()) continue;
                list.add(TextFormatting.GRAY + " - " + ((ItemInfinityStone)s.func_77973_b()).getType().getTextColor() + s.func_82833_r());
            }
        }
        return list;
    }

    @Override
    public boolean shouldCtrlTooltipAppear(ItemStack stack, EntityPlayer player) {
        return false;
    }

    @Override
    public List<String> getCtrlToolTip(ItemStack stack, EntityPlayer player) {
        return null;
    }

    @Override
    public Ability.AbilityMap addDefaultAbilities(EntityLivingBase player, Ability.AbilityMap abilities, Ability.EnumAbilityContext context) {
        ItemStack stack;
        ItemStack itemStack = context == Ability.EnumAbilityContext.MAIN_HAND ? player.func_184614_ca() : (stack = context == Ability.EnumAbilityContext.OFF_HAND ? player.func_184592_cb() : ItemStack.field_190927_a);
        if (stack.func_77942_o()) {
            InventoryInfinityGauntlet inv = new InventoryInfinityGauntlet(stack);
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack s = inv.func_70301_a(i);
                if (!(s.func_77973_b() instanceof ItemInfinityStone)) continue;
                ((ItemInfinityStone)s.func_77973_b()).addStoneAbilities(player, abilities, context);
            }
        }
        return abilities;
    }
}

