/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.infinity.render;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import lucraft.mods.lucraftcore.infinity.EnumInfinityStone;
import lucraft.mods.lucraftcore.infinity.items.InventoryInfinityGauntlet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.BakedItemModel;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;

public class ItemModelInfinityGauntlet
implements IModel {
    public static final ModelResourceLocation LOCATION = new ModelResourceLocation(new ResourceLocation("lucraftcore", "infinity_gauntlet_state"), "inventory");
    public static final ModelResourceLocation LOCATION_3D = new ModelResourceLocation(new ResourceLocation("lucraftcore", "infinity_gauntlet_3d"), "inventory");
    public static final IModel MODEL = new ItemModelInfinityGauntlet();
    private final ResourceLocation baseLocation;
    private final ResourceLocation spaceLocation;
    private final ResourceLocation realityLocation;
    private final ResourceLocation powerLocation;
    private final ResourceLocation soulLocation;
    private final ResourceLocation mindLocation;
    private final ResourceLocation timeLocation;
    private final boolean[] stones;

    public ItemModelInfinityGauntlet() {
        this(null, null, null, null, null, null, null, new EnumInfinityStone[0]);
    }

    public ItemModelInfinityGauntlet(ResourceLocation baseLocation, ResourceLocation spaceLocation, ResourceLocation realityLocation, ResourceLocation powerLocation, ResourceLocation soulLocation, ResourceLocation mindLocation, ResourceLocation timeLocation, boolean[] stones) {
        this.baseLocation = baseLocation;
        this.spaceLocation = spaceLocation;
        this.realityLocation = realityLocation;
        this.powerLocation = powerLocation;
        this.soulLocation = soulLocation;
        this.mindLocation = mindLocation;
        this.timeLocation = timeLocation;
        this.stones = stones;
    }

    public ItemModelInfinityGauntlet(ResourceLocation baseLocation, ResourceLocation spaceLocation, ResourceLocation realityLocation, ResourceLocation powerLocation, ResourceLocation soulLocation, ResourceLocation mindLocation, ResourceLocation timeLocation, EnumInfinityStone ... stones) {
        this.baseLocation = baseLocation;
        this.spaceLocation = spaceLocation;
        this.realityLocation = realityLocation;
        this.powerLocation = powerLocation;
        this.soulLocation = soulLocation;
        this.mindLocation = mindLocation;
        this.timeLocation = timeLocation;
        this.stones = new boolean[EnumInfinityStone.values().length];
        for (EnumInfinityStone types : stones) {
            this.stones[types.ordinal()] = true;
        }
    }

    public Collection<ResourceLocation> getTextures() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        if (this.baseLocation != null) {
            builder.add((Object)this.baseLocation);
        }
        if (this.spaceLocation != null) {
            builder.add((Object)this.spaceLocation);
        }
        if (this.realityLocation != null) {
            builder.add((Object)this.realityLocation);
        }
        if (this.powerLocation != null) {
            builder.add((Object)this.powerLocation);
        }
        if (this.soulLocation != null) {
            builder.add((Object)this.soulLocation);
        }
        if (this.mindLocation != null) {
            builder.add((Object)this.mindLocation);
        }
        if (this.timeLocation != null) {
            builder.add((Object)this.timeLocation);
        }
        return builder.build();
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        IBakedModel model;
        ImmutableMap transformMap = PerspectiveMapWrapper.getTransforms((IModelState)state);
        TRSRTransformation transform = state.apply(Optional.empty()).orElse(TRSRTransformation.identity());
        TextureAtlasSprite particleSprite = null;
        ImmutableList.Builder builder = ImmutableList.builder();
        if (this.baseLocation != null) {
            model = new ItemLayerModel(ImmutableList.of((Object)this.baseLocation)).bake(state, format, bakedTextureGetter);
            builder.addAll((Iterable)model.func_188616_a(null, null, 0L));
        }
        if (this.spaceLocation != null && this.stones[EnumInfinityStone.SPACE.ordinal()]) {
            model = new ItemLayerModel(ImmutableList.of((Object)this.spaceLocation)).bake(state, format, bakedTextureGetter);
            builder.addAll((Iterable)model.func_188616_a(null, null, 0L));
        }
        if (this.realityLocation != null && this.stones[EnumInfinityStone.REALITY.ordinal()]) {
            model = new ItemLayerModel(ImmutableList.of((Object)this.realityLocation)).bake(state, format, bakedTextureGetter);
            builder.addAll((Iterable)model.func_188616_a(null, null, 0L));
        }
        if (this.powerLocation != null && this.stones[EnumInfinityStone.POWER.ordinal()]) {
            model = new ItemLayerModel(ImmutableList.of((Object)this.powerLocation)).bake(state, format, bakedTextureGetter);
            builder.addAll((Iterable)model.func_188616_a(null, null, 0L));
        }
        if (this.soulLocation != null && this.stones[EnumInfinityStone.SOUL.ordinal()]) {
            model = new ItemLayerModel(ImmutableList.of((Object)this.soulLocation)).bake(state, format, bakedTextureGetter);
            builder.addAll((Iterable)model.func_188616_a(null, null, 0L));
        }
        if (this.mindLocation != null && this.stones[EnumInfinityStone.MIND.ordinal()]) {
            model = new ItemLayerModel(ImmutableList.of((Object)this.mindLocation)).bake(state, format, bakedTextureGetter);
            builder.addAll((Iterable)model.func_188616_a(null, null, 0L));
        }
        if (this.timeLocation != null && this.stones[EnumInfinityStone.TIME.ordinal()]) {
            model = new ItemLayerModel(ImmutableList.of((Object)this.timeLocation)).bake(state, format, bakedTextureGetter);
            builder.addAll((Iterable)model.func_188616_a(null, null, 0L));
        }
        return new BakedInfinityGauntletModel(this, (ImmutableList<BakedQuad>)builder.build(), particleSprite, format, (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)Maps.immutableEnumMap((Map)transformMap), Maps.newHashMap(), transform.isIdentity());
    }

    public ItemModelInfinityGauntlet process(ImmutableMap<String, String> customData) {
        boolean[] stones = new boolean[EnumInfinityStone.values().length];
        for (EnumInfinityStone types : EnumInfinityStone.values()) {
            if (!customData.containsKey((Object)types.toString().toLowerCase())) continue;
            stones[types.ordinal()] = ((String)customData.get((Object)types.toString().toLowerCase())).equals("true");
        }
        return new ItemModelInfinityGauntlet(this.baseLocation, this.spaceLocation, this.realityLocation, this.powerLocation, this.soulLocation, this.mindLocation, this.timeLocation, stones);
    }

    public ItemModelInfinityGauntlet retexture(ImmutableMap<String, String> textures) {
        ResourceLocation base = this.baseLocation;
        ResourceLocation space = this.spaceLocation;
        ResourceLocation reality = this.realityLocation;
        ResourceLocation power = this.powerLocation;
        ResourceLocation soul = this.soulLocation;
        ResourceLocation mind = this.mindLocation;
        ResourceLocation time = this.timeLocation;
        if (textures.containsKey((Object)"base")) {
            base = new ResourceLocation((String)textures.get((Object)"base"));
        }
        if (textures.containsKey((Object)"space")) {
            space = new ResourceLocation((String)textures.get((Object)"space"));
        }
        if (textures.containsKey((Object)"reality")) {
            reality = new ResourceLocation((String)textures.get((Object)"reality"));
        }
        if (textures.containsKey((Object)"power")) {
            power = new ResourceLocation((String)textures.get((Object)"power"));
        }
        if (textures.containsKey((Object)"soul")) {
            soul = new ResourceLocation((String)textures.get((Object)"soul"));
        }
        if (textures.containsKey((Object)"mind")) {
            mind = new ResourceLocation((String)textures.get((Object)"mind"));
        }
        if (textures.containsKey((Object)"time")) {
            time = new ResourceLocation((String)textures.get((Object)"time"));
        }
        return new ItemModelInfinityGauntlet(base, space, reality, power, soul, mind, time, this.stones);
    }

    public static final class BakedInfinityGauntletModel
    extends BakedItemModel {
        private final ItemModelInfinityGauntlet parent;
        private final Map<String, IBakedModel> cache;
        private final VertexFormat format;
        public final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms_;
        public static IBakedModel model3d;

        BakedInfinityGauntletModel(ItemModelInfinityGauntlet parent, ImmutableList<BakedQuad> quads, TextureAtlasSprite particle, VertexFormat format, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms, Map<String, IBakedModel> cache, boolean untransformed) {
            super(quads, particle, transforms, (ItemOverrideList)BakedInfinityGauntletOverrideHandler.INSTANCE, untransformed);
            this.format = format;
            this.parent = parent;
            this.cache = cache;
            this.transforms_ = transforms;
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType type) {
            if (model3d == null || type == ItemCameraTransforms.TransformType.GUI || type == ItemCameraTransforms.TransformType.FIXED) {
                return super.handlePerspective(type);
            }
            return model3d.handlePerspective(type);
        }
    }

    private static final class BakedInfinityGauntletOverrideHandler
    extends ItemOverrideList {
        public static final BakedInfinityGauntletOverrideHandler INSTANCE = new BakedInfinityGauntletOverrideHandler();

        private BakedInfinityGauntletOverrideHandler() {
            super((List)ImmutableList.of());
        }

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
            if (!stack.func_77942_o()) {
                return originalModel;
            }
            InventoryInfinityGauntlet inv = new InventoryInfinityGauntlet(stack);
            HashMap stones = Maps.newHashMap();
            StringBuilder key = new StringBuilder();
            for (int i = 0; i < InventoryInfinityGauntlet.SLOTS.length; ++i) {
                EnumInfinityStone type = InventoryInfinityGauntlet.SLOTS[i];
                if (inv.func_70301_a(i).func_190926_b()) continue;
                stones.put(type.toString().toLowerCase(), "true");
                key.append(type.toString()).append(',');
            }
            BakedInfinityGauntletModel model = (BakedInfinityGauntletModel)originalModel;
            if (!model.cache.containsKey(key.toString())) {
                IModel parent = model.parent.process(ImmutableMap.copyOf((Map)stones));
                Function<ResourceLocation, TextureAtlasSprite> textureGetter = location -> Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
                IBakedModel bakedModel = parent.bake((IModelState)new SimpleModelState(model.transforms_), model.format, textureGetter);
                model.cache.put(key.toString(), bakedModel);
                return bakedModel;
            }
            return (IBakedModel)model.cache.get(key.toString());
        }
    }

    public static enum LoaderInfinityGauntlet implements ICustomModelLoader
    {
        INSTANCE;


        public boolean accepts(ResourceLocation modelLocation) {
            return modelLocation.func_110624_b().equals("lucraftcore") && modelLocation.func_110623_a().contains("infinity_gauntlet_model");
        }

        public IModel loadModel(ResourceLocation modelLocation) {
            return MODEL;
        }

        public void func_110549_a(IResourceManager resourceManager) {
        }
    }
}

