/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.infinity.render;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import lucraft.mods.lucraftcore.LCConfig;
import lucraft.mods.lucraftcore.infinity.EnumInfinityStone;
import lucraft.mods.lucraftcore.infinity.blocks.TileEntityInfinityGenerator;
import lucraft.mods.lucraftcore.infinity.items.ItemInfinityStone;
import lucraft.mods.lucraftcore.util.helper.LCRenderHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntityBeaconRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.tileentity.TileEntityBeacon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TESRInfinityGenerator
extends TileEntitySpecialRenderer<TileEntityInfinityGenerator> {
    public static ResourceLocation SPACE = new ResourceLocation("lucraftcore", "textures/blocks/infinity_generator_overlay_space.png");
    public static ResourceLocation TIME = new ResourceLocation("lucraftcore", "textures/blocks/infinity_generator_overlay_time.png");
    public static ResourceLocation SOUL = new ResourceLocation("lucraftcore", "textures/blocks/infinity_generator_overlay_soul.png");
    public static ResourceLocation REALITY = new ResourceLocation("lucraftcore", "textures/blocks/infinity_generator_overlay_reality.png");
    public static ResourceLocation POWER = new ResourceLocation("lucraftcore", "textures/blocks/infinity_generator_overlay_power.png");
    public static ResourceLocation MIND = new ResourceLocation("lucraftcore", "textures/blocks/infinity_generator_overlay_mind.png");

    public boolean isGlobalRenderer(TileEntityInfinityGenerator te) {
        return true;
    }

    public void render(TileEntityInfinityGenerator te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        IItemHandler itemHandler = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (!itemHandler.getStackInSlot(0).func_190926_b() && itemHandler.getStackInSlot(0).func_77973_b() instanceof ItemInfinityStone) {
            EnumInfinityStone type = ((ItemInfinityStone)itemHandler.getStackInSlot(0).func_77973_b()).getType();
            if (LCConfig.infinity.renderInfinityGeneratorBeam) {
                this.renderBeacon(x, y, z, partialTicks, 1.0, this.getBeamSegments(type), te.func_145831_w().func_82737_E());
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)x, (double)y, (double)z);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            GlStateManager.func_179140_f();
            LCRenderHelper.setLightmapTextureCoords(240.0f, 240.0f);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TESRInfinityGenerator.getOverlayTexture(type));
            GlStateManager.func_179129_p();
            float f = 0.001f;
            float f1 = 0.0625f;
            buffer.func_181668_a(9, DefaultVertexFormats.field_181707_g);
            buffer.func_181662_b(0.0, 0.0, (double)(-f)).func_187315_a(0.0, 1.0).func_181675_d();
            buffer.func_181662_b(1.0, 0.0, (double)(-f)).func_187315_a(1.0, 1.0).func_181675_d();
            buffer.func_181662_b(1.0, 1.0, (double)(-f)).func_187315_a(1.0, 0.0).func_181675_d();
            buffer.func_181662_b(0.0, 1.0, (double)(-f)).func_187315_a(0.0, 0.0).func_181675_d();
            tessellator.func_78381_a();
            buffer.func_181668_a(9, DefaultVertexFormats.field_181707_g);
            buffer.func_181662_b(0.0, 0.0, (double)(1.0f + f)).func_187315_a(0.0, 1.0).func_181675_d();
            buffer.func_181662_b(1.0, 0.0, (double)(1.0f + f)).func_187315_a(1.0, 1.0).func_181675_d();
            buffer.func_181662_b(1.0, 1.0, (double)(1.0f + f)).func_187315_a(1.0, 0.0).func_181675_d();
            buffer.func_181662_b(0.0, 1.0, (double)(1.0f + f)).func_187315_a(0.0, 0.0).func_181675_d();
            tessellator.func_78381_a();
            buffer.func_181668_a(9, DefaultVertexFormats.field_181707_g);
            buffer.func_181662_b((double)(-f), 0.0, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
            buffer.func_181662_b((double)(-f), 0.0, 1.0).func_187315_a(1.0, 1.0).func_181675_d();
            buffer.func_181662_b((double)(-f), 1.0, 1.0).func_187315_a(1.0, 0.0).func_181675_d();
            buffer.func_181662_b((double)(-f), 1.0, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
            tessellator.func_78381_a();
            buffer.func_181668_a(9, DefaultVertexFormats.field_181707_g);
            buffer.func_181662_b((double)(1.0f + f), 0.0, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
            buffer.func_181662_b((double)(1.0f + f), 0.0, 1.0).func_187315_a(1.0, 1.0).func_181675_d();
            buffer.func_181662_b((double)(1.0f + f), 1.0, 1.0).func_187315_a(1.0, 0.0).func_181675_d();
            buffer.func_181662_b((double)(1.0f + f), 1.0, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
            tessellator.func_78381_a();
            buffer.func_181668_a(9, DefaultVertexFormats.field_181707_g);
            buffer.func_181662_b(0.0, (double)(1.0f + f), 0.0).func_187315_a(0.0, 1.0).func_181675_d();
            buffer.func_181662_b(0.0, (double)(1.0f + f), 1.0).func_187315_a(1.0, 1.0).func_181675_d();
            buffer.func_181662_b(1.0, (double)(1.0f + f), 1.0).func_187315_a(1.0, 0.0).func_181675_d();
            buffer.func_181662_b(1.0, (double)(1.0f + f), 0.0).func_187315_a(0.0, 0.0).func_181675_d();
            tessellator.func_78381_a();
            buffer.func_181668_a(9, DefaultVertexFormats.field_181707_g);
            buffer.func_181662_b(0.0, (double)(-f), 0.0).func_187315_a(0.0, 1.0).func_181675_d();
            buffer.func_181662_b(0.0, (double)(-f), 1.0).func_187315_a(1.0, 1.0).func_181675_d();
            buffer.func_181662_b(1.0, (double)(-f), 1.0).func_187315_a(1.0, 0.0).func_181675_d();
            buffer.func_181662_b(1.0, (double)(-f), 0.0).func_187315_a(0.0, 0.0).func_181675_d();
            tessellator.func_78381_a();
            LCRenderHelper.setupRenderLightning();
            AxisAlignedBB box = new AxisAlignedBB((double)(f1 * 4.0f), (double)(f1 * 4.0f), (double)(f1 * 4.0f), (double)(f1 * 12.0f), (double)(f1 * 12.0f), (double)(f1 * 12.0f));
            float thickness = 1.0E-5f;
            LCRenderHelper.drawRandomLightningCoordsInAABB(thickness, TESRInfinityGenerator.getLightningColor(type), box, new Random(te.func_145831_w().func_82737_E() / 2L));
            LCRenderHelper.finishRenderLightning();
            GlStateManager.func_179109_b((float)0.5f, (float)0.5f, (float)0.5f);
            GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
            GlStateManager.func_179114_b((float)((float)Minecraft.func_71410_x().field_71439_g.field_70173_aa + partialTicks), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(MathHelper.func_76126_a((float)(((float)Minecraft.func_71410_x().field_71439_g.field_70173_aa + partialTicks) / 10.0f)) * 10.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            Minecraft.func_71410_x().func_175599_af().func_181564_a(itemHandler.getStackInSlot(0), ItemCameraTransforms.TransformType.FIXED);
            LCRenderHelper.restoreLightmapTextureCoords();
            GlStateManager.func_179145_e();
            GlStateManager.func_179121_F();
        }
    }

    public static ResourceLocation getOverlayTexture(EnumInfinityStone type) {
        switch (type) {
            case SPACE: {
                return SPACE;
            }
            case MIND: {
                return MIND;
            }
            case POWER: {
                return POWER;
            }
            case REALITY: {
                return REALITY;
            }
            case SOUL: {
                return SOUL;
            }
            case TIME: {
                return TIME;
            }
        }
        return null;
    }

    public static Color getLightningColor(EnumInfinityStone type) {
        switch (type) {
            case SPACE: {
                return new Color(2, 85, 255);
            }
            case MIND: {
                return Color.YELLOW;
            }
            case POWER: {
                return new Color(1.0f, 0.0f, 1.0f);
            }
            case REALITY: {
                return Color.RED;
            }
            case SOUL: {
                return new Color(1.0f, 0.6f, 0.0f);
            }
            case TIME: {
                return new Color(0.6f, 1.0f, 0.0f);
            }
        }
        return null;
    }

    public void renderBeacon(double x, double y, double z, double partialTicks, double textureScale, List<TileEntityBeacon.BeamSegment> beamSegments, double totalWorldTime) {
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        this.func_147499_a(TileEntityBeaconRenderer.field_147523_b);
        if (textureScale > 0.0) {
            GlStateManager.func_179106_n();
            int i = 0;
            for (int j = 0; j < beamSegments.size(); ++j) {
                TileEntityBeacon.BeamSegment tileentitybeacon$beamsegment = beamSegments.get(j);
                TESRInfinityGenerator.renderBeamSegment(x, y, z, partialTicks, textureScale, totalWorldTime, i, tileentitybeacon$beamsegment.func_177264_c(), tileentitybeacon$beamsegment.func_177263_b());
                i += tileentitybeacon$beamsegment.func_177264_c();
            }
            GlStateManager.func_179127_m();
        }
    }

    public static void renderBeamSegment(double x, double y, double z, double partialTicks, double textureScale, double totalWorldTime, int yOffset, int height, float[] colors) {
        TESRInfinityGenerator.renderBeamSegment(x, y, z, partialTicks, textureScale, totalWorldTime, yOffset, height, colors, 0.2, 0.25);
    }

    public static void renderBeamSegment(double x, double y, double z, double partialTicks, double textureScale, double totalWorldTime, int yOffset, int height, float[] colors, double beamRadius, double glowRadius) {
        int i = yOffset + height;
        GlStateManager.func_187421_b((int)3553, (int)10242, (int)10497);
        GlStateManager.func_187421_b((int)3553, (int)10243, (int)10497);
        GlStateManager.func_179140_f();
        GlStateManager.func_179129_p();
        GlStateManager.func_179084_k();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        double d0 = totalWorldTime + partialTicks;
        double d1 = height < 0 ? d0 : -d0;
        double d2 = MathHelper.func_181162_h((double)(d1 * 0.2 - (double)MathHelper.func_76128_c((double)(d1 * 0.1))));
        float f = colors[0];
        float f1 = colors[1];
        float f2 = colors[2];
        double d3 = d0 * 0.025 * -1.5;
        double d4 = 0.5 + Math.cos(d3 + 2.356194490192345) * beamRadius;
        double d5 = 0.5 + Math.sin(d3 + 2.356194490192345) * beamRadius;
        double d6 = 0.5 + Math.cos(d3 + 0.7853981633974483) * beamRadius;
        double d7 = 0.5 + Math.sin(d3 + 0.7853981633974483) * beamRadius;
        double d8 = 0.5 + Math.cos(d3 + 3.9269908169872414) * beamRadius;
        double d9 = 0.5 + Math.sin(d3 + 3.9269908169872414) * beamRadius;
        double d10 = 0.5 + Math.cos(d3 + 5.497787143782138) * beamRadius;
        double d11 = 0.5 + Math.sin(d3 + 5.497787143782138) * beamRadius;
        double d12 = 0.0;
        double d13 = 1.0;
        double d14 = -1.0 + d2;
        double d15 = (double)height * textureScale * (0.5 / beamRadius) + d14;
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        bufferbuilder.func_181662_b(x + d4, y + (double)i, z + d5).func_187315_a(1.0, d15).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(x + d4, y + (double)yOffset, z + d5).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(x + d6, y + (double)yOffset, z + d7).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(x + d6, y + (double)i, z + d7).func_187315_a(0.0, d15).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(x + d10, y + (double)i, z + d11).func_187315_a(1.0, d15).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(x + d10, y + (double)yOffset, z + d11).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(x + d8, y + (double)yOffset, z + d9).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(x + d8, y + (double)i, z + d9).func_187315_a(0.0, d15).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(x + d6, y + (double)i, z + d7).func_187315_a(1.0, d15).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(x + d6, y + (double)yOffset, z + d7).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(x + d10, y + (double)yOffset, z + d11).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(x + d10, y + (double)i, z + d11).func_187315_a(0.0, d15).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(x + d8, y + (double)i, z + d9).func_187315_a(1.0, d15).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(x + d8, y + (double)yOffset, z + d9).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(x + d4, y + (double)yOffset, z + d5).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(x + d4, y + (double)i, z + d5).func_187315_a(0.0, d15).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179132_a((boolean)false);
        d3 = 0.5 - glowRadius;
        d4 = 0.5 - glowRadius;
        d5 = 0.5 + glowRadius;
        d6 = 0.5 - glowRadius;
        d7 = 0.5 - glowRadius;
        d8 = 0.5 + glowRadius;
        d9 = 0.5 + glowRadius;
        d10 = 0.5 + glowRadius;
        d11 = 0.0;
        d12 = 1.0;
        d13 = -1.0 + d2;
        d14 = (double)height * textureScale + d13;
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        bufferbuilder.func_181662_b(x + d3, y + (double)i, z + d4).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
        bufferbuilder.func_181662_b(x + d3, y + (double)yOffset, z + d4).func_187315_a(1.0, d13).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
        bufferbuilder.func_181662_b(x + d5, y + (double)yOffset, z + d6).func_187315_a(0.0, d13).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
        bufferbuilder.func_181662_b(x + d5, y + (double)i, z + d6).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
        bufferbuilder.func_181662_b(x + d9, y + (double)i, z + d10).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
        bufferbuilder.func_181662_b(x + d9, y + (double)yOffset, z + d10).func_187315_a(1.0, d13).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
        bufferbuilder.func_181662_b(x + d7, y + (double)yOffset, z + d8).func_187315_a(0.0, d13).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
        bufferbuilder.func_181662_b(x + d7, y + (double)i, z + d8).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
        bufferbuilder.func_181662_b(x + d5, y + (double)i, z + d6).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
        bufferbuilder.func_181662_b(x + d5, y + (double)yOffset, z + d6).func_187315_a(1.0, d13).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
        bufferbuilder.func_181662_b(x + d9, y + (double)yOffset, z + d10).func_187315_a(0.0, d13).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
        bufferbuilder.func_181662_b(x + d9, y + (double)i, z + d10).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
        bufferbuilder.func_181662_b(x + d7, y + (double)i, z + d8).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
        bufferbuilder.func_181662_b(x + d7, y + (double)yOffset, z + d8).func_187315_a(1.0, d13).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
        bufferbuilder.func_181662_b(x + d3, y + (double)yOffset, z + d4).func_187315_a(0.0, d13).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
        bufferbuilder.func_181662_b(x + d3, y + (double)i, z + d4).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179145_e();
        GlStateManager.func_179098_w();
        GlStateManager.func_179132_a((boolean)true);
    }

    public List<TileEntityBeacon.BeamSegment> getBeamSegments(EnumInfinityStone stone) {
        ArrayList<TileEntityBeacon.BeamSegment> list = new ArrayList<TileEntityBeacon.BeamSegment>();
        for (int i = 0; i < 256; ++i) {
            list.add(new TileEntityBeacon.BeamSegment(TESRInfinityGenerator.getLightningColor(stone).getRGBComponents(null)));
        }
        return list;
    }
}

