/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.karma;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lucraft.mods.lucraftcore.karma.KarmaHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryInternal;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryManager;

public class KarmaStat
extends IForgeRegistryEntry.Impl<KarmaStat> {
    public static IForgeRegistry<KarmaStat> KARMA_STAT_REGISTRY;
    public static KarmaStat MONSTER_KILL;
    public static KarmaStat GOOD_PLAYER_KILL;
    public static KarmaStat BAD_PLAYER_KILL;
    public static KarmaStat GOOD_KNOCKOUT;
    public static KarmaStat BAD_KNOCKOUT;
    public static KarmaStat TAMING;
    public static KarmaStat SAVES;
    public static KarmaStat THEFTS;
    public static KarmaStat MODIFIED;
    private String name;
    private int amount;

    public static List<KarmaStat> getKarmaStats() {
        ArrayList<KarmaStat> list = new ArrayList<KarmaStat>();
        for (KarmaStat stat : KARMA_STAT_REGISTRY.getValues()) {
            list.add(stat);
        }
        list.sort(new KarmaStatComparator());
        return list;
    }

    public KarmaStat(String name) {
        this(name, 0);
    }

    public KarmaStat(String name, int amount) {
        this.name = name;
        this.amount = amount;
    }

    public String getName() {
        return this.name;
    }

    public String getUnlocalizedName() {
        return "karma.karmastats." + this.getName();
    }

    public String getUnlocalizedDescription() {
        return "karma.karmastats." + this.getName() + ".desc";
    }

    public int getAmount() {
        return this.amount;
    }

    public int getMin() {
        if (this == MODIFIED) {
            return Integer.MIN_VALUE;
        }
        return 0;
    }

    public int getMax() {
        return Integer.MAX_VALUE;
    }

    public static enum KarmaClass {
        TYRANT("tyrant", Integer.MIN_VALUE, -501),
        SUPERVILLAIN("superVillain", -500, -201),
        VILLAIN("villain", -200, -101),
        THUG("thug", -100, -26),
        NEUTRAL("neutral", -25, 25),
        VIGILANTE("vigilante", 26, 100),
        HERO("hero", 101, 200),
        SUPERHERO("superHero", 201, 500),
        LEGEND("legend", 501, Integer.MAX_VALUE);

        private String name;
        private int min;
        private int max;

        private KarmaClass(String name, int min, int max) {
            this.name = name;
            this.min = min;
            this.max = max;
        }

        public String getName() {
            return this.name;
        }

        public String getUnlocalizedName() {
            return "karma.karmaclass." + this.getName();
        }

        public int getMinKarma() {
            return this.min;
        }

        public int getMaxKarma() {
            return this.max;
        }

        public boolean hasPlayerThisClass(EntityPlayer player) {
            int karma = KarmaHandler.getKarma(player);
            return karma <= this.getMaxKarma() && karma >= this.getMinKarma();
        }
    }

    public static enum KarmaPlayerType {
        BAD(Integer.MIN_VALUE, -26),
        NEUTRAL(-25, 25),
        GOOD(26, Integer.MAX_VALUE);

        private int min;
        private int max;

        private KarmaPlayerType(int min, int max) {
            this.min = min;
            this.max = max;
        }

        public int getMinKarma() {
            return this.min;
        }

        public int getMaxKarma() {
            return this.max;
        }

        public boolean hasPlayerThisType(EntityPlayer player) {
            int karma = KarmaHandler.getKarma(player);
            return karma <= this.getMaxKarma() && karma >= this.getMinKarma();
        }
    }

    public static class KarmaStatRegistryCallback
    implements IForgeRegistry.AddCallback<KarmaStat> {
        public static Map<Integer, ResourceLocation> SORTING_IDS_BY_ID = new HashMap<Integer, ResourceLocation>();
        public static Map<ResourceLocation, Integer> SORTING_IDS_BY_ENTRY = new HashMap<ResourceLocation, Integer>();
        public static int id = 0;

        public void onAdd(IForgeRegistryInternal<KarmaStat> owner, RegistryManager stage, int id, KarmaStat obj, KarmaStat oldObj) {
            if (!SORTING_IDS_BY_ENTRY.containsKey(obj.getRegistryName())) {
                SORTING_IDS_BY_ID.put(KarmaStatRegistryCallback.id, obj.getRegistryName());
                SORTING_IDS_BY_ENTRY.put(obj.getRegistryName(), KarmaStatRegistryCallback.id);
                ++KarmaStatRegistryCallback.id;
            }
        }
    }

    public static class KarmaStatComparator
    implements Comparator<KarmaStat> {
        @Override
        public int compare(KarmaStat ks1, KarmaStat ks2) {
            int id2;
            int id1 = KarmaStatRegistryCallback.SORTING_IDS_BY_ENTRY.get(ks1.getRegistryName());
            if (id1 > (id2 = KarmaStatRegistryCallback.SORTING_IDS_BY_ENTRY.get(ks2.getRegistryName()).intValue())) {
                return 1;
            }
            if (id1 < id2) {
                return -1;
            }
            return 0;
        }
    }

    @Mod.EventBusSubscriber(modid="lucraftcore")
    public static class EventHandler {
        @SubscribeEvent
        public static void onRegisterNewRegistries(RegistryEvent.NewRegistry e) {
            KARMA_STAT_REGISTRY = new RegistryBuilder().setName(new ResourceLocation("lucraftcore", "karma_stats")).setType(KarmaStat.class).setIDRange(0, 512).add((IForgeRegistry.AddCallback)new KarmaStatRegistryCallback()).create();
        }

        @SubscribeEvent
        public static void onRegisterKarmaStats(RegistryEvent.Register<KarmaStat> e) {
            MONSTER_KILL = (KarmaStat)new KarmaStat("monster_kill", 2).setRegistryName("lucraftcore", "monster_kill");
            e.getRegistry().register((IForgeRegistryEntry)MONSTER_KILL);
            GOOD_PLAYER_KILL = (KarmaStat)new KarmaStat("good_player_kill", -3).setRegistryName("lucraftcore", "good_player_kill");
            e.getRegistry().register((IForgeRegistryEntry)GOOD_PLAYER_KILL);
            BAD_PLAYER_KILL = (KarmaStat)new KarmaStat("bad_player_kill", 2).setRegistryName("lucraftcore", "bad_player_kill");
            e.getRegistry().register((IForgeRegistryEntry)BAD_PLAYER_KILL);
            GOOD_KNOCKOUT = (KarmaStat)new KarmaStat("good_knockout", -1).setRegistryName("lucraftcore", "good_knockout");
            e.getRegistry().register((IForgeRegistryEntry)GOOD_KNOCKOUT);
            BAD_KNOCKOUT = (KarmaStat)new KarmaStat("bad_knockout", 3).setRegistryName("lucraftcore", "bad_knockout");
            e.getRegistry().register((IForgeRegistryEntry)BAD_KNOCKOUT);
            TAMING = (KarmaStat)new KarmaStat("taming", 1).setRegistryName("lucraftcore", "taming");
            e.getRegistry().register((IForgeRegistryEntry)TAMING);
            SAVES = (KarmaStat)new KarmaStat("saves", 3).setRegistryName("lucraftcore", "saves");
            e.getRegistry().register((IForgeRegistryEntry)SAVES);
            THEFTS = (KarmaStat)new KarmaStat("thefts", -2).setRegistryName("lucraftcore", "thefts");
            e.getRegistry().register((IForgeRegistryEntry)THEFTS);
            MODIFIED = (KarmaStat)new KarmaStat("modified", 1).setRegistryName("lucraftcore", "modified");
            e.getRegistry().register((IForgeRegistryEntry)MODIFIED);
        }
    }
}

