/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.materials.items;

import java.util.HashMap;
import java.util.Map;
import lucraft.mods.lucraftcore.materials.Material;
import lucraft.mods.lucraftcore.materials.items.ItemLCMaterial;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class MaterialsItems {
    public static Map<Material, ItemLCMaterial> INGOTS = new HashMap<Material, ItemLCMaterial>();
    public static Map<Material, ItemLCMaterial> DUSTS = new HashMap<Material, ItemLCMaterial>();
    public static Map<Material, ItemLCMaterial> NUGGETS = new HashMap<Material, ItemLCMaterial>();
    public static Map<Material, ItemLCMaterial> PLATES = new HashMap<Material, ItemLCMaterial>();
    public static Map<Material, ItemLCMaterial> WIRINGS = new HashMap<Material, ItemLCMaterial>();

    @SubscribeEvent
    public void onRegisterItems(RegistryEvent.Register<Item> e) {
        for (Material m : Material.getMaterials()) {
            ItemLCMaterial item;
            if (m.autoGenerateComponent(Material.MaterialComponent.INGOT)) {
                item = new ItemLCMaterial(m, Material.MaterialComponent.INGOT);
                INGOTS.put(m, item);
                e.getRegistry().register((IForgeRegistryEntry)item);
            }
            if (m.autoGenerateComponent(Material.MaterialComponent.DUST)) {
                item = new ItemLCMaterial(m, Material.MaterialComponent.DUST);
                DUSTS.put(m, item);
                e.getRegistry().register((IForgeRegistryEntry)item);
            }
            if (m.autoGenerateComponent(Material.MaterialComponent.NUGGET)) {
                item = new ItemLCMaterial(m, Material.MaterialComponent.NUGGET);
                NUGGETS.put(m, item);
                e.getRegistry().register((IForgeRegistryEntry)item);
            }
            if (m.autoGenerateComponent(Material.MaterialComponent.PLATE)) {
                item = new ItemLCMaterial(m, Material.MaterialComponent.PLATE);
                PLATES.put(m, item);
                e.getRegistry().register((IForgeRegistryEntry)item);
            }
            if (!m.autoGenerateComponent(Material.MaterialComponent.WIRING)) continue;
            item = new ItemLCMaterial(m, Material.MaterialComponent.WIRING);
            WIRINGS.put(m, item);
            e.getRegistry().register((IForgeRegistryEntry)item);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onRegisterModels(ModelRegistryEvent e) {
        for (Material m : Material.getMaterials()) {
            if (m.autoGenerateComponent(Material.MaterialComponent.INGOT)) {
                ModelLoader.setCustomModelResourceLocation((Item)INGOTS.get(m), (int)0, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("lucraftcore", "ingot"), m.getResourceName()));
            }
            if (m.autoGenerateComponent(Material.MaterialComponent.DUST)) {
                ModelLoader.setCustomModelResourceLocation((Item)DUSTS.get(m), (int)0, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("lucraftcore", "dust"), m.getResourceName()));
            }
            if (m.autoGenerateComponent(Material.MaterialComponent.NUGGET)) {
                ModelLoader.setCustomModelResourceLocation((Item)NUGGETS.get(m), (int)0, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("lucraftcore", "nugget"), m.getResourceName()));
            }
            if (m.autoGenerateComponent(Material.MaterialComponent.PLATE)) {
                ModelLoader.setCustomModelResourceLocation((Item)PLATES.get(m), (int)0, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("lucraftcore", "plate"), m.getResourceName()));
            }
            if (!m.autoGenerateComponent(Material.MaterialComponent.WIRING)) continue;
            ModelLoader.setCustomModelResourceLocation((Item)WIRINGS.get(m), (int)0, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("lucraftcore", "wiring"), m.getResourceName()));
        }
    }
}

