/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.materials.worldgen;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import lucraft.mods.lucraftcore.materials.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGeneratorMeteorite
extends WorldGenerator {
    public int size;

    public WorldGeneratorMeteorite(int size) {
        this.size = size;
    }

    public boolean func_180709_b(World world, Random random, BlockPos position) {
        this.generateCrater(world, random, position);
        int i = position.func_177958_n();
        int j = position.func_177952_p();
        for (int k = position.func_177956_o(); !world.func_180495_p(new BlockPos(i, k, j)).func_185915_l() && k > 0; --k) {
        }
        this.generateMeteorBlocks(world, random, new BlockPos(i, k += this.size / 2, j));
        return true;
    }

    public List<IBlockState> getBlocksForCrater(World world, Random random, BlockPos position) {
        return Arrays.asList(Blocks.field_150424_aL.func_176223_P(), Blocks.field_150347_e.func_176223_P(), Blocks.field_150347_e.func_176223_P(), Blocks.field_150347_e.func_176223_P(), Blocks.field_189877_df.func_176223_P());
    }

    public void generateCrater(World world, Random random, BlockPos position) {
        Explosion explosion = new Explosion(world, null, (double)position.func_177958_n(), (double)position.func_177956_o(), (double)position.func_177952_p(), (float)(this.size * 4), true, true);
        explosion.func_77278_a();
        List<IBlockState> explosionBlocks = this.getBlocksForCrater(world, random, position);
        for (BlockPos pos : explosion.func_180343_e()) {
            world.func_175698_g(pos);
            if (!world.func_180495_p(pos.func_177977_b()).func_185915_l() || random.nextInt(3) != 0) continue;
            IBlockState state = explosionBlocks.get(random.nextInt(explosionBlocks.size()));
            world.func_175656_a(pos.func_177977_b(), state);
            if (state != Blocks.field_150424_aL.func_176223_P() || random.nextInt(3) != 0) continue;
            world.func_175656_a(pos, Blocks.field_150480_ab.func_176223_P());
        }
    }

    public List<IBlockState> getBlocksForMeteor(World world, Random random, BlockPos position) {
        return Arrays.asList(Blocks.field_150347_e.func_176223_P(), Blocks.field_150343_Z.func_176223_P(), Blocks.field_189877_df.func_176223_P(), Material.DWARF_STAR_ALLOY.getBlock(Material.MaterialComponent.ORE), Blocks.field_150343_Z.func_176223_P(), Blocks.field_150402_ci.func_176223_P());
    }

    public void generateMeteorBlocks(World world, Random random, BlockPos position) {
        this.generateSphere(world, position.func_177958_n(), position.func_177956_o(), position.func_177952_p(), this.size, this.getBlocksForMeteor(world, random, position), random);
    }

    public void generateSphere(World world, int posX, int posY, int posZ, int radius, List<IBlockState> blocks, Random rand) {
        BlockPos origin = new BlockPos(posX, posY, posZ);
        for (int x = posX - radius; x <= posX + radius; ++x) {
            for (int y = posY - radius; y <= posY + radius; ++y) {
                for (int z = posZ - radius; z <= posZ + radius; ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    if (!(pos.func_185332_f(origin.func_177958_n(), origin.func_177956_o(), origin.func_177952_p()) < (double)radius)) continue;
                    world.func_175656_a(pos, blocks.get(rand.nextInt(blocks.size())));
                }
            }
        }
    }
}

