/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.superpowers;

import lucraft.mods.lucraftcore.LucraftCore;
import lucraft.mods.lucraftcore.superpowers.Superpower;
import lucraft.mods.lucraftcore.superpowers.abilities.Ability;
import lucraft.mods.lucraftcore.superpowers.abilities.AbilityCommandOnLose;
import lucraft.mods.lucraftcore.superpowers.capabilities.CapabilitySuperpower;
import lucraft.mods.lucraftcore.superpowers.capabilities.ISuperpowerCapability;
import lucraft.mods.lucraftcore.superpowers.events.LivingSuperpowerEvent;
import lucraft.mods.lucraftcore.util.triggers.LCCriteriaTriggers;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;

@Mod.EventBusSubscriber(modid="lucraftcore")
public class SuperpowerHandler {
    public static IForgeRegistry<Superpower> SUPERPOWER_REGISTRY;

    @SubscribeEvent
    public static void onRegisterNewRegistries(RegistryEvent.NewRegistry e) {
        SUPERPOWER_REGISTRY = new RegistryBuilder().setName(new ResourceLocation("lucraftcore", "superpower")).setType(Superpower.class).setIDRange(0, 512).create();
    }

    public static ISuperpowerCapability getSuperpowerCapability(EntityLivingBase entity) {
        return (ISuperpowerCapability)entity.getCapability(CapabilitySuperpower.SUPERPOWER_CAP, null);
    }

    public static void setSuperpower(EntityLivingBase entity, Superpower superpower) {
        if (superpower != null && !SUPERPOWER_REGISTRY.containsValue((IForgeRegistryEntry)superpower)) {
            LucraftCore.LOGGER.error("That superpower isn't registered!");
            return;
        }
        if (SuperpowerHandler.getSuperpowerCapability(entity) == null) {
            return;
        }
        SuperpowerHandler.getSuperpowerCapability(entity).setSuperpower(superpower);
        SuperpowerHandler.getSuperpowerCapability(entity).setSuperpowerGained(true);
        SuperpowerHandler.syncToAll(entity);
        if (entity instanceof EntityPlayerMP) {
            LCCriteriaTriggers.GET_SUPERPOWER.trigger((EntityPlayerMP)entity, superpower);
        }
    }

    public static void giveSuperpower(EntityLivingBase entity, Superpower superpower) {
        if (MinecraftForge.EVENT_BUS.post((Event)new LivingSuperpowerEvent(entity, superpower))) {
            return;
        }
        if (SuperpowerHandler.hasSuperpower(entity)) {
            return;
        }
        SuperpowerHandler.setSuperpower(entity, superpower);
    }

    public static void removeSuperpower(EntityLivingBase entity) {
        Superpower current = SuperpowerHandler.getSuperpower(entity);
        if (current != null) {
            for (AbilityCommandOnLose ability : Ability.getAbilitiesFromClass(SuperpowerHandler.getSuperpowerCapability(entity).getAbilityContainer(Ability.EnumAbilityContext.SUPERPOWER).getAbilities(), AbilityCommandOnLose.class)) {
                if (ability == null || !ability.isUnlocked()) continue;
                ability.executeCommands();
            }
            if (entity instanceof EntityPlayerMP) {
                LCCriteriaTriggers.LOSE_SUPERPOWER.trigger((EntityPlayerMP)entity, current);
            }
            SuperpowerHandler.setSuperpower(entity, null);
        }
    }

    public static Superpower getSuperpower(EntityLivingBase entity) {
        ISuperpowerCapability cap = SuperpowerHandler.getSuperpowerCapability(entity);
        return cap == null ? null : cap.getSuperpower();
    }

    public static boolean hasSuperpower(EntityLivingBase entity) {
        return SuperpowerHandler.getSuperpower(entity) != null;
    }

    public static boolean hasSuperpower(EntityLivingBase entity, Superpower superpower) {
        return SuperpowerHandler.getSuperpower(entity) == superpower;
    }

    public static void syncToPlayer(EntityLivingBase entity) {
        SuperpowerHandler.getSuperpowerCapability(entity).syncToPlayer();
    }

    public static void syncToPlayer(EntityLivingBase entity, EntityPlayer receiver) {
        SuperpowerHandler.getSuperpowerCapability(entity).syncToPlayer(receiver);
    }

    public static void syncToAll(EntityLivingBase entity) {
        SuperpowerHandler.getSuperpowerCapability(entity).syncToAll();
    }
}

