/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.superpowers.abilities;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import lucraft.mods.lucraftcore.superpowers.abilities.Ability;
import lucraft.mods.lucraftcore.superpowers.abilities.AbilityAction;
import lucraft.mods.lucraftcore.superpowers.abilities.data.AbilityData;
import lucraft.mods.lucraftcore.superpowers.abilities.data.AbilityDataCommandList;
import lucraft.mods.lucraftcore.superpowers.abilities.supplier.EnumSync;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.command.ICommandManager;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AbilityCommand
extends AbilityAction {
    public static AbilityData<CommandList> COMMANDS = new AbilityDataCommandList("commands").setSyncType(EnumSync.NONE).enableSetting("commands", "Sets the commands which get executed when using the ability");
    public AbilityCommandSender commandSender = new AbilityCommandSender(this);

    public AbilityCommand(EntityLivingBase entity) {
        super(entity);
    }

    @Override
    public void registerData() {
        super.registerData();
        this.dataManager.register(COMMANDS, new CommandList().addCommand("say Hello").addCommand("say World"));
    }

    @Override
    public void readFromAddonPack(JsonObject data, Ability.AbilityMap abilities) {
        super.readFromAddonPack(data, abilities);
        if (JsonUtils.func_151204_g((JsonObject)data, (String)"command")) {
            this.dataManager.set(COMMANDS, new CommandList(data.get("command")));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawIcon(Minecraft mc, Gui gui, int x, int y) {
        float zLevel = Minecraft.func_71410_x().func_175599_af().field_77023_b;
        Minecraft.func_71410_x().func_175599_af().field_77023_b = -100.5f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
        Minecraft.func_71410_x().func_175599_af().func_175042_a(new ItemStack(Blocks.field_150483_bI), 0, 0);
        GlStateManager.func_179121_F();
        Minecraft.func_71410_x().func_175599_af().field_77023_b = zLevel;
    }

    @Override
    public boolean action() {
        return this.dataManager.get(COMMANDS).execute(this.entity.field_70170_p.func_73046_m().func_71187_D(), this.commandSender) > 0;
    }

    public static class CommandList
    implements INBTSerializable<NBTTagList> {
        private List<String> commands;

        public CommandList() {
            this(new LinkedList<String>());
        }

        public CommandList(JsonElement jsonElement) {
            this.parseJson(jsonElement);
        }

        public CommandList(List<String> commands) {
            this.commands = commands;
        }

        public CommandList addCommand(String command) {
            this.commands.add(command);
            return this;
        }

        public List<String> getCommands() {
            return this.commands;
        }

        public int execute(ICommandManager commandManager, ICommandSender sender) {
            AtomicInteger i = new AtomicInteger();
            this.commands.forEach(s -> i.set(Math.max(i.get(), commandManager.func_71556_a(sender, s))));
            return i.get();
        }

        public NBTTagList serializeNBT() {
            NBTTagList list = new NBTTagList();
            this.commands.forEach(s -> list.func_74742_a((NBTBase)new NBTTagString(s)));
            return list;
        }

        public void deserializeNBT(NBTTagList nbt) {
            this.commands = new LinkedList<String>();
            for (int i = 0; i < nbt.func_74745_c(); ++i) {
                this.commands.add(nbt.func_150307_f(i));
            }
        }

        public void parseJson(JsonElement jsonElement) {
            this.commands = new LinkedList<String>();
            if (jsonElement.isJsonPrimitive()) {
                this.commands.add(jsonElement.getAsString());
            } else {
                JsonArray jsonArray = jsonElement.getAsJsonArray();
                for (int i = 0; i < jsonArray.size(); ++i) {
                    this.commands.add(jsonArray.get(i).getAsString());
                }
            }
        }
    }

    public static class AbilityCommandSender
    implements ICommandSender {
        public final Ability ability;

        public AbilityCommandSender(Ability ability) {
            this.ability = ability;
        }

        public String func_70005_c_() {
            return "Command Ability";
        }

        public ITextComponent func_145748_c_() {
            return new TextComponentString(this.ability.getDisplayName());
        }

        public boolean func_70003_b(int permLevel, String commandName) {
            return !commandName.equalsIgnoreCase("kick") && !commandName.equalsIgnoreCase("ban");
        }

        public BlockPos func_180425_c() {
            return this.ability.entity.func_180425_c();
        }

        public Vec3d func_174791_d() {
            return this.ability.entity.func_174791_d();
        }

        public World func_130014_f_() {
            return this.ability.entity.field_70170_p;
        }

        @Nullable
        public Entity func_174793_f() {
            return this.ability.entity;
        }

        @Nullable
        public MinecraftServer func_184102_h() {
            return this.func_130014_f_().func_73046_m();
        }
    }
}

