/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.superpowers.abilities;

import lucraft.mods.lucraftcore.LCConfig;
import lucraft.mods.lucraftcore.sizechanging.capabilities.CapabilitySizeChanging;
import lucraft.mods.lucraftcore.sizechanging.capabilities.ISizeChanging;
import lucraft.mods.lucraftcore.superpowers.ModuleSuperpowers;
import lucraft.mods.lucraftcore.superpowers.abilities.Ability;
import lucraft.mods.lucraftcore.superpowers.abilities.AbilityToggle;
import lucraft.mods.lucraftcore.superpowers.abilities.data.AbilityData;
import lucraft.mods.lucraftcore.superpowers.abilities.data.AbilityDataBoolean;
import lucraft.mods.lucraftcore.superpowers.abilities.data.AbilityDataFloat;
import lucraft.mods.lucraftcore.superpowers.abilities.supplier.EnumSync;
import lucraft.mods.lucraftcore.util.events.RenderModelEvent;
import lucraft.mods.lucraftcore.util.helper.LCRenderHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AbilityFlight
extends AbilityToggle {
    public static final AbilityData<Float> SPEED = new AbilityDataFloat("speed").disableSaving().setSyncType(EnumSync.SELF).enableSetting("speed", "Sets the speed multiplier for flying when you are NOT sprinting");
    public static final AbilityData<Float> SPRINT_SPEED = new AbilityDataFloat("sprint_speed").disableSaving().setSyncType(EnumSync.SELF).enableSetting("sprint_speed", "Sets the speed multiplier for flying when you are sprinting");
    public static final AbilityData<Boolean> ROTATE_ARMS = new AbilityDataBoolean("rotate_arms").disableSaving().enableSetting("rotate_arms", "If enabled the players arms will face in your direction (like Superman)");

    public AbilityFlight(EntityLivingBase entity) {
        super(entity);
    }

    @Override
    public void registerData() {
        super.registerData();
        this.dataManager.register(SPEED, Float.valueOf(0.1f));
        this.dataManager.register(SPRINT_SPEED, Float.valueOf(0.2f));
        this.dataManager.register(ROTATE_ARMS, true);
    }

    @Override
    public void firstTick() {
        super.firstTick();
    }

    @Override
    public void updateTick() {
        if (this.entity.field_70122_E && this.ticks > 20 || !(this.entity instanceof EntityPlayer)) {
            this.setEnabled(false);
        }
        if (this.entity.field_191988_bg > 0.0f && !this.entity.field_70122_E) {
            double speed;
            Vec3d vec = this.entity.func_70040_Z();
            double d = speed = this.entity.func_70051_ag() ? (double)this.dataManager.get(SPRINT_SPEED).floatValue() : (double)this.dataManager.get(SPEED).floatValue();
            if (LCConfig.modules.size_changing) {
                speed *= (double)((ISizeChanging)this.entity.getCapability(CapabilitySizeChanging.SIZE_CHANGING_CAP, null)).getSize();
            }
            this.entity.field_70159_w = vec.field_72450_a * speed;
            this.entity.field_70181_x = vec.field_72448_b * speed;
            this.entity.field_70179_y = vec.field_72449_c * speed;
            if (!this.entity.field_70170_p.field_72995_K) {
                this.entity.field_70143_R = 0.0f;
            }
        } else {
            float motionY = 0.0f;
            if (this.ticks < 20) {
                int lowestY;
                for (lowestY = this.entity.func_180425_c().func_177956_o(); lowestY > 0 && !this.entity.field_70170_p.func_175665_u(new BlockPos(this.entity.field_70165_t, (double)lowestY, this.entity.field_70161_v)); --lowestY) {
                }
                if (this.entity.func_180425_c().func_177956_o() - lowestY < 5) {
                    motionY += 1.0f;
                }
            }
            motionY = (float)((double)motionY + Math.sin((float)this.entity.field_70173_aa / 10.0f) / 100.0);
            this.entity.field_70143_R = 0.0f;
            this.entity.field_70181_x = motionY;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawIcon(Minecraft mc, Gui gui, int x, int y) {
        LCRenderHelper.drawIcon(mc, gui, x, y, 1, 0);
    }

    @Mod.EventBusSubscriber(modid="lucraftcore", value={Side.CLIENT})
    public static class Renderer {
        @SubscribeEvent
        public static void onRenderModel(RenderModelEvent e) {
            if (!ModuleSuperpowers.INSTANCE.isEnabled()) {
                return;
            }
            if (e.getEntityLiving() instanceof EntityPlayer) {
                for (AbilityFlight ab : Ability.getAbilitiesFromClass(Ability.getAbilities(e.getEntityLiving()), AbilityFlight.class)) {
                    if (ab == null || !ab.isUnlocked() || !ab.isEnabled()) continue;
                    EntityPlayer player = (EntityPlayer)e.getEntityLiving();
                    float speed = (float)MathHelper.func_151237_a((double)Math.sqrt((player.field_70169_q - player.field_70165_t) * (player.field_70169_q - player.field_70165_t) + (player.field_70166_s - player.field_70161_v) * (player.field_70166_s - player.field_70161_v) + (player.field_70167_r - player.field_70163_u) * (player.field_70167_r - player.field_70163_u)), (double)0.0, (double)1.0);
                    GlStateManager.func_179114_b((float)(speed * (90.0f + player.field_70125_A)), (float)1.0f, (float)0.0f, (float)0.0f);
                    break;
                }
            }
        }

        @SubscribeEvent(receiveCanceled=true)
        public static void onSetUpModel(RenderModelEvent.SetRotationAngels e) {
            if (!ModuleSuperpowers.INSTANCE.isEnabled()) {
                return;
            }
            if (e.getEntity() instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)e.getEntity();
                for (AbilityFlight ab : Ability.getAbilitiesFromClass(Ability.getAbilities((EntityLivingBase)((EntityPlayer)e.getEntity())), AbilityFlight.class)) {
                    if (ab == null || !ab.isUnlocked() || !ab.isEnabled() || !(player.field_191988_bg > 0.0f)) continue;
                    float speed = (float)MathHelper.func_151237_a((double)Math.sqrt((player.field_70169_q - player.field_70165_t) * (player.field_70169_q - player.field_70165_t) + (player.field_70166_s - player.field_70161_v) * (player.field_70166_s - player.field_70161_v) + (player.field_70167_r - player.field_70163_u) * (player.field_70167_r - player.field_70163_u)), (double)0.0, (double)1.0);
                    e.setCanceled(true);
                    float rotation = speed * (90.0f + player.field_70125_A);
                    e.model.field_178720_f.field_78795_f = e.model.field_78116_c.field_78795_f = (float)((double)e.model.field_78116_c.field_78795_f - Math.toRadians(rotation));
                    e.model.field_178723_h.field_78795_f = (float)Math.toRadians(ab.dataManager.get(ROTATE_ARMS) != false ? 180.0 : 0.0);
                    e.model.field_178724_i.field_78795_f = e.model.field_178723_h.field_78795_f;
                    e.model.field_178721_j.field_78795_f = 0.0f;
                    e.model.field_178722_k.field_78795_f = 0.0f;
                    if (!(e.model instanceof ModelPlayer)) continue;
                    ModelPlayer model = (ModelPlayer)e.model;
                    model.field_178732_b.field_78795_f = model.field_178723_h.field_78795_f;
                    model.field_178734_a.field_78795_f = model.field_178724_i.field_78795_f;
                    model.field_178731_d.field_78795_f = model.field_178721_j.field_78795_f;
                    model.field_178733_c.field_78795_f = model.field_178722_k.field_78795_f;
                }
            }
        }
    }
}

