/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.superpowers.abilities;

import java.util.Iterator;
import java.util.Random;
import lucraft.mods.lucraftcore.superpowers.abilities.AbilityAction;
import lucraft.mods.lucraftcore.superpowers.abilities.data.AbilityData;
import lucraft.mods.lucraftcore.superpowers.abilities.data.AbilityDataFloat;
import lucraft.mods.lucraftcore.superpowers.abilities.data.AbilityDataInteger;
import lucraft.mods.lucraftcore.superpowers.abilities.supplier.EnumSync;
import lucraft.mods.lucraftcore.util.helper.LCRenderHelper;
import lucraft.mods.lucraftcore.util.helper.PlayerHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AbilitySetPunch
extends AbilityAction {
    public static final AbilityData<Integer> ARM = new AbilityDataInteger("arm").setSyncType(EnumSync.NONE).enableSetting("arm", "The arm that will be used for this. 0 - main hand. 1 - off hand. 2 - both arms. 3 - random arm");
    public static final AbilityData<Float> REACH_DISTANCE = new AbilityDataFloat("reach_distance").setSyncType(EnumSync.NONE).enableSetting("reach_distance", "The maximum distance you can hit entities at");
    public static final AbilityData<Float> DAMAGE = new AbilityDataFloat("damage").setSyncType(EnumSync.NONE).enableSetting("damage", "The amount of damage dealt with each hit. If you set it to -1 it will use the current attack stat of the player");

    public AbilitySetPunch(EntityLivingBase entity) {
        super(entity);
    }

    @Override
    public void registerData() {
        super.registerData();
        this.dataManager.register(ARM, 0);
        this.dataManager.register(REACH_DISTANCE, Float.valueOf(5.0f));
        this.dataManager.register(DAMAGE, Float.valueOf(-1.0f));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawIcon(Minecraft mc, Gui gui, int x, int y) {
        LCRenderHelper.drawIcon(mc, gui, x, y, 0, 2);
    }

    @Override
    public boolean action() {
        RayTraceResult rtr;
        float dmg;
        if (this.entity instanceof EntityPlayer) {
            int armMode = this.dataManager.get(ARM);
            if (armMode == 0 || armMode == 2) {
                PlayerHelper.swingPlayerArm((EntityPlayer)this.entity, EnumHand.MAIN_HAND);
            }
            if (armMode == 1 || armMode == 2) {
                PlayerHelper.swingPlayerArm((EntityPlayer)this.entity, EnumHand.OFF_HAND);
            }
            if (armMode > 2) {
                PlayerHelper.swingPlayerArm((EntityPlayer)this.entity, EnumHand.values()[new Random().nextInt(2)]);
            }
        }
        if ((dmg = this.dataManager.get(DAMAGE).floatValue()) == -1.0f) {
            dmg = (float)this.entity.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        }
        if (dmg > 0.0f && (rtr = this.getPosLookingAt(this.dataManager.get(REACH_DISTANCE).floatValue())) != null && rtr.field_72308_g != null) {
            if (this.entity instanceof EntityPlayer) {
                rtr.field_72308_g.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)this.entity)), dmg);
            } else {
                rtr.field_72308_g.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this.entity), dmg);
            }
        }
        return true;
    }

    public RayTraceResult getPosLookingAt(double distance) {
        Vec3d lookVec = this.entity.func_70040_Z();
        int i = 0;
        while ((double)i < distance * 2.0) {
            float scale = (float)i / 2.0f;
            Vec3d pos = this.entity.func_174791_d().func_72441_c(0.0, (double)this.entity.func_70047_e(), 0.0).func_178787_e(lookVec.func_186678_a((double)scale));
            if (!this.entity.field_70170_p.func_175623_d(new BlockPos(pos))) {
                return new RayTraceResult(pos, null);
            }
            Vec3d min = pos.func_72441_c(0.25, 0.25, 0.25);
            Vec3d max = pos.func_72441_c(-0.25, -0.25, -0.25);
            Iterator iterator = this.entity.field_70170_p.func_72839_b((Entity)this.entity, new AxisAlignedBB(min.field_72450_a, min.field_72448_b, min.field_72449_c, max.field_72450_a, max.field_72448_b, max.field_72449_c)).iterator();
            if (iterator.hasNext()) {
                Entity entity = (Entity)iterator.next();
                return new RayTraceResult(entity);
            }
            ++i;
        }
        return new RayTraceResult(this.entity.func_174791_d().func_72441_c(0.0, (double)this.entity.func_70047_e(), 0.0).func_178787_e(lookVec.func_186678_a(distance)), null);
    }
}

