/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.superpowers.abilities;

import lucraft.mods.lucraftcore.superpowers.abilities.Ability;
import lucraft.mods.lucraftcore.superpowers.abilities.supplier.EnumSync;
import lucraft.mods.lucraftcore.util.triggers.LCCriteriaTriggers;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;

public abstract class AbilityToggle
extends Ability {
    public AbilityToggle(EntityLivingBase entity) {
        super(entity);
    }

    @Override
    public void onUpdate() {
        this.updateConditions();
        if (this.isUnlocked()) {
            if (this.isEnabled()) {
                if (this.ticks == 0) {
                    this.firstTick();
                }
                ++this.ticks;
                this.updateTick();
                if (this.hasCooldown()) {
                    if (this.getCooldown() >= this.getMaxCooldown()) {
                        this.setEnabled(false);
                    } else {
                        this.setCooldown(this.getCooldown() + 1);
                    }
                }
            } else {
                if (this.ticks != 0) {
                    this.lastTick();
                    this.ticks = 0;
                }
                if (this.hasCooldown() && this.getCooldown() > 0) {
                    this.setCooldown(this.getCooldown() - 1);
                }
            }
        } else if (this.ticks != 0) {
            this.lastTick();
            this.ticks = 0;
        }
        if (this.dataManager.sync != null) {
            this.sync = this.sync.add(this.dataManager.sync);
            this.dataManager.sync = EnumSync.NONE;
        }
    }

    @Override
    public void onKeyPressed() {
        if (this.isUnlocked()) {
            this.action();
            for (Ability ability2 : (Ability[])AbilityToggle.getAbilities(this.entity).stream().filter(ability -> ability.getParentAbility() == this).toArray(Ability[]::new)) {
                ability2.onKeyPressed();
            }
            if (this.entity instanceof EntityPlayerMP) {
                LCCriteriaTriggers.EXECUTE_ABILITY.trigger((EntityPlayerMP)this.entity, this.getAbilityEntry());
            }
        }
    }

    @Override
    public void onKeyReleased() {
    }

    @Override
    public Ability.AbilityType getAbilityType() {
        return Ability.AbilityType.TOGGLE;
    }

    @Override
    public abstract void updateTick();

    @Override
    public boolean action() {
        this.setEnabled(!this.isEnabled());
        return true;
    }
}

