/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.superpowers.abilities.data;

import com.google.common.reflect.TypeToken;
import com.google.gson.JsonObject;
import java.lang.reflect.Type;
import lucraft.mods.lucraftcore.superpowers.abilities.supplier.EnumSync;
import net.minecraft.nbt.NBTTagCompound;

public abstract class AbilityData<T> {
    protected final String key;
    protected String jsonKey;
    protected String description;
    protected EnumSync syncType = EnumSync.EVERYONE;
    protected boolean write = true;
    private final TypeToken<T> typeToken = new TypeToken<T>(this.getClass()){};
    private final Type type = this.typeToken.getType();

    public AbilityData(String key) {
        this.key = key;
    }

    public Type getType() {
        return this.type;
    }

    public String getKey() {
        return this.key;
    }

    public String getJsonKey() {
        return this.jsonKey;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isUserSetting() {
        return this.jsonKey != null && !this.jsonKey.isEmpty();
    }

    public AbilityData<T> enableSetting(String jsonKey, String desc) {
        this.jsonKey = jsonKey;
        this.description = desc;
        return this;
    }

    public AbilityData<T> setSyncType(EnumSync syncType) {
        this.syncType = syncType;
        return this;
    }

    public AbilityData<T> disableSaving() {
        this.write = false;
        return this;
    }

    public boolean canBeSaved() {
        return this.write;
    }

    public abstract T parseValue(JsonObject var1, T var2);

    public abstract void writeToNBT(NBTTagCompound var1, T var2);

    public abstract T readFromNBT(NBTTagCompound var1, T var2);

    public String getDisplay(T value) {
        return value.toString();
    }

    public boolean displayAsString(T value) {
        return false;
    }
}

