/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.superpowers.abilities.predicates;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import lucraft.mods.lucraftcore.superpowers.Superpower;
import lucraft.mods.lucraftcore.superpowers.SuperpowerHandler;
import lucraft.mods.lucraftcore.superpowers.abilities.Ability;
import lucraft.mods.lucraftcore.superpowers.abilities.predicates.AbilityConditionAbility;
import lucraft.mods.lucraftcore.superpowers.abilities.predicates.AbilityConditionHeldItem;
import lucraft.mods.lucraftcore.superpowers.abilities.predicates.AbilityConditionLevel;
import lucraft.mods.lucraftcore.superpowers.abilities.predicates.AbilityConditionNot;
import lucraft.mods.lucraftcore.superpowers.abilities.predicates.AbilityConditionOpenArmor;
import lucraft.mods.lucraftcore.superpowers.abilities.predicates.AbilityConditionOr;
import lucraft.mods.lucraftcore.superpowers.abilities.predicates.AbilityConditionPotionWeakness;
import lucraft.mods.lucraftcore.superpowers.abilities.predicates.AbilityConditionScoreboardTag;
import lucraft.mods.lucraftcore.superpowers.abilities.predicates.AbilityConditionSuperpower;
import lucraft.mods.lucraftcore.superpowers.abilities.predicates.IAbilityConditionFactory;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.potion.Potion;
import net.minecraft.util.EnumHand;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;

public class AbilityCondition {
    protected Predicate<Ability> predicate;
    protected ITextComponent displayText;

    public AbilityCondition(Predicate<Ability> predicate, ITextComponent displayText) {
        this.predicate = predicate;
        this.displayText = displayText;
    }

    public boolean test(Ability ability) {
        return this.predicate.test(ability);
    }

    public ITextComponent getDisplayText() {
        return this.displayText;
    }

    @Mod.EventBusSubscriber
    public static class ConditionEntry
    extends IForgeRegistryEntry.Impl<ConditionEntry> {
        public static IForgeRegistry<ConditionEntry> CONDITION_REGISTRY;
        private Class<? extends AbilityCondition> clazz;

        public ConditionEntry(Class<? extends AbilityCondition> clazz, ResourceLocation registryName) {
            this.clazz = clazz;
            this.setRegistryName(registryName);
        }

        public Class<? extends AbilityCondition> getConditionClass() {
            return this.clazz;
        }

        @SubscribeEvent
        public static void onNewRegistry(RegistryEvent.NewRegistry event) {
            CONDITION_REGISTRY = new RegistryBuilder().setName(new ResourceLocation("lucraftcore", "ability_condition")).setType(ConditionEntry.class).setIDRange(0, 512).create();
        }

        @SubscribeEvent
        public static void registerConditions(RegistryEvent.Register<ConditionEntry> e) {
            ConditionEntry.register((IForgeRegistry<ConditionEntry>)e.getRegistry(), AbilityConditionAbility.class, new ResourceLocation("lucraftcore", "ability"), (j, a, l) -> {
                Ability ab = (Ability)l.get(JsonUtils.func_151200_h((JsonObject)j, (String)"ability"));
                return ab != null ? new AbilityConditionAbility(ab) : null;
            });
            ConditionEntry.register((IForgeRegistry<ConditionEntry>)e.getRegistry(), AbilityConditionSuperpower.class, new ResourceLocation("lucraftcore", "has_superpower"), (j, a, l) -> {
                Superpower superpower = (Superpower)SuperpowerHandler.SUPERPOWER_REGISTRY.getValue(new ResourceLocation(JsonUtils.func_151200_h((JsonObject)j, (String)"superpower")));
                return superpower != null ? new AbilityConditionSuperpower(superpower) : null;
            });
            ConditionEntry.register((IForgeRegistry<ConditionEntry>)e.getRegistry(), AbilityConditionLevel.class, new ResourceLocation("lucraftcore", "level"), (j, a, l) -> new AbilityConditionLevel(JsonUtils.func_151203_m((JsonObject)j, (String)"level")));
            ConditionEntry.register((IForgeRegistry<ConditionEntry>)e.getRegistry(), AbilityConditionOr.class, new ResourceLocation("lucraftcore", "or"), (j, a, l) -> {
                JsonArray jsonArray = JsonUtils.func_151214_t((JsonObject)j, (String)"conditions");
                AbilityCondition[] conditions = new AbilityCondition[jsonArray.size()];
                for (int i = 0; i < jsonArray.size(); ++i) {
                    conditions[i] = ConditionFactory.parseCondition(jsonArray.get(i).getAsJsonObject(), a, l);
                }
                return new AbilityConditionOr(conditions);
            });
            ConditionEntry.register((IForgeRegistry<ConditionEntry>)e.getRegistry(), AbilityConditionNot.class, new ResourceLocation("lucraftcore", "not"), (j, a, l) -> {
                JsonArray jsonArray = JsonUtils.func_151214_t((JsonObject)j, (String)"conditions");
                AbilityCondition[] conditions = new AbilityCondition[jsonArray.size()];
                for (int i = 0; i < jsonArray.size(); ++i) {
                    conditions[i] = ConditionFactory.parseCondition(jsonArray.get(i).getAsJsonObject(), a, l);
                }
                return new AbilityConditionNot(conditions);
            });
            ConditionEntry.register((IForgeRegistry<ConditionEntry>)e.getRegistry(), AbilityConditionHeldItem.class, new ResourceLocation("lucraftcore", "held_item"), (j, a, l) -> {
                Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(JsonUtils.func_151200_h((JsonObject)j, (String)"item")));
                String handString = JsonUtils.func_151200_h((JsonObject)j, (String)"hand");
                EnumHand hand = handString.equals("main_hand") ? EnumHand.MAIN_HAND : (handString.equals("off_hand") ? EnumHand.OFF_HAND : null);
                return item == null || hand == null ? null : new AbilityConditionHeldItem(item, hand);
            });
            ConditionEntry.register((IForgeRegistry<ConditionEntry>)e.getRegistry(), AbilityConditionOpenArmor.class, new ResourceLocation("lucraftcore", "open_armor"), (j, a, l) -> {
                EntityEquipmentSlot slot = EntityEquipmentSlot.func_188451_a((String)JsonUtils.func_151200_h((JsonObject)j, (String)"slot"));
                return slot == null ? null : new AbilityConditionOpenArmor(slot);
            });
            ConditionEntry.register((IForgeRegistry<ConditionEntry>)e.getRegistry(), AbilityConditionPotionWeakness.class, new ResourceLocation("lucraftcore", "potion_weakness"), (j, a, l) -> {
                Potion potion = (Potion)Potion.field_188414_b.func_82594_a((Object)new ResourceLocation(JsonUtils.func_151200_h((JsonObject)j, (String)"potion")));
                return potion == null ? null : new AbilityConditionPotionWeakness(potion);
            });
            ConditionEntry.register((IForgeRegistry<ConditionEntry>)e.getRegistry(), AbilityConditionScoreboardTag.class, new ResourceLocation("lucraftcore", "scoreboard_tag"), (j, a, l) -> {
                String tag = JsonUtils.func_151200_h((JsonObject)j, (String)"tag");
                return new AbilityConditionScoreboardTag(tag);
            });
        }

        public static void register(IForgeRegistry<ConditionEntry> registry, Class<? extends AbilityCondition> clazz, ResourceLocation loc, IAbilityConditionFactory factory) {
            registry.register((IForgeRegistryEntry)new ConditionEntry(clazz, loc));
            ConditionFactory.register(loc, factory);
        }
    }

    public static class ConditionFactory {
        private static Map<ResourceLocation, IAbilityConditionFactory> FACTORIES = new HashMap<ResourceLocation, IAbilityConditionFactory>();

        public static void register(ResourceLocation key, IAbilityConditionFactory factory) {
            if (FACTORIES.containsKey(key)) {
                throw new IllegalStateException("Duplicate ability condition factory: " + key);
            }
            FACTORIES.put(key, factory);
        }

        public static AbilityCondition parseCondition(JsonObject json, Ability ability, Ability.AbilityMap abilities) {
            IAbilityConditionFactory factory = FACTORIES.get(new ResourceLocation(JsonUtils.func_151200_h((JsonObject)json, (String)"type")));
            if (factory != null) {
                return factory.parse(json, ability, abilities);
            }
            return null;
        }
    }
}

