/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.superpowers.abilities.supplier;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import lucraft.mods.lucraftcore.network.LCPacketDispatcher;
import lucraft.mods.lucraftcore.superpowers.SuperpowerHandler;
import lucraft.mods.lucraftcore.superpowers.abilities.Ability;
import lucraft.mods.lucraftcore.superpowers.abilities.AbilityCommandOnGain;
import lucraft.mods.lucraftcore.superpowers.abilities.supplier.EnumSync;
import lucraft.mods.lucraftcore.superpowers.abilities.supplier.IAbilityProvider;
import lucraft.mods.lucraftcore.superpowers.capabilities.CapabilitySuperpower;
import lucraft.mods.lucraftcore.superpowers.capabilities.ISuperpowerCapability;
import lucraft.mods.lucraftcore.superpowers.events.InitAbilitiesEvent;
import lucraft.mods.lucraftcore.superpowers.network.MessageSyncAbilityContainer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.common.eventhandler.Event;

public class AbilityContainer
implements INBTSerializable<NBTTagCompound> {
    public final EntityLivingBase entity;
    public final Ability.EnumAbilityContext context;
    public IAbilityProvider provider;
    protected Ability.AbilityMap abilities;
    public EnumSync sync = EnumSync.NONE;

    public AbilityContainer(EntityLivingBase entity, Ability.EnumAbilityContext context) {
        this.entity = entity;
        this.context = context;
        this.abilities = new Ability.AbilityMap();
    }

    public Collection<Ability> getAbilities() {
        return this.abilities.values();
    }

    public Ability getAbility(String key) {
        return (Ability)this.abilities.get(key);
    }

    public String getKeyForAbility(Ability ability) {
        for (String s : this.abilities.keySet()) {
            if (this.abilities.get(s) != ability) continue;
            return s;
        }
        return null;
    }

    public void onUpdate() {
        IAbilityProvider currentProvider = Ability.getAbilityProvider(this.entity, this.context);
        if (currentProvider != this.provider) {
            this.switchProvider(currentProvider);
        }
        for (Ability ab : this.getAbilities()) {
            ab.onUpdate();
            if (ab.sync == null || ab.sync == EnumSync.NONE) continue;
            this.sync = this.sync.add(ab.sync);
            ab.sync = EnumSync.NONE;
        }
        if (this.sync != EnumSync.NONE) {
            this.sync();
            this.sync = EnumSync.NONE;
        }
    }

    public void switchProvider(IAbilityProvider provider) {
        for (Ability ab : this.getAbilities()) {
            if (!ab.isUnlocked()) continue;
            ab.lastTick();
        }
        if (this.provider != null) {
            this.save();
        }
        this.provider = provider;
        if (this.provider != null) {
            this.abilities = this.filterAbilities(provider.addDefaultAbilities(this.entity, new Ability.AbilityMap(), this.context));
            this.load();
        } else {
            this.abilities.clear();
        }
        if (this.context == Ability.EnumAbilityContext.SUPERPOWER && SuperpowerHandler.getSuperpowerCapability(this.entity).hasGainedSuperpower()) {
            for (AbilityCommandOnGain ability : Ability.getAbilitiesFromClass(this.getAbilities(), AbilityCommandOnGain.class)) {
                if (ability == null || !ability.isUnlocked()) continue;
                ability.executeCommands();
            }
            SuperpowerHandler.getSuperpowerCapability(this.entity).setSuperpowerGained(false);
        }
        this.sync = this.sync.add(EnumSync.EVERYONE);
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.abilities.forEach((s, a) -> nbt.func_74782_a(s, (NBTBase)a.serializeNBT()));
        return nbt;
    }

    public NBTTagCompound serializeNBTSync() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.abilities.forEach((s, a) -> nbt.func_74782_a(s, (NBTBase)a.serializeNBTSync()));
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        if (this.provider == null) {
            this.abilities = new Ability.AbilityMap();
            return;
        }
        this.abilities = this.provider.addDefaultAbilities(this.entity, new Ability.AbilityMap(), this.context);
        this.abilities.forEach((s, ability) -> {
            if (nbt.func_74764_b(s)) {
                ability.deserializeNBT(nbt.func_74775_l(s));
            }
        });
        this.abilities = this.filterAbilities(this.abilities);
    }

    public void deserializeNBTSync(NBTTagCompound nbt) {
        if (this.provider == null) {
            this.abilities = new Ability.AbilityMap();
            return;
        }
        this.abilities = this.provider.addDefaultAbilities(this.entity, new Ability.AbilityMap(), this.context);
        this.abilities.forEach((s, ability) -> {
            if (nbt.func_74764_b(s)) {
                ability.deserializeNBTSync(nbt.func_74775_l(s));
            }
        });
        this.abilities = this.filterAbilities(this.abilities);
    }

    public Ability.AbilityMap filterAbilities(Ability.AbilityMap abilityList) {
        Ability.AbilityMap l = new Ability.AbilityMap();
        abilityList.forEach((s, a) -> l.put((String)s, (Ability)a));
        for (Ability ab : l.values()) {
            ab.context = this.context;
        }
        MinecraftForge.EVENT_BUS.post((Event)new InitAbilitiesEvent.Pre(this.entity, l, this.context));
        for (Ability ab : l.values()) {
            ab.init((Map<String, Ability>)ImmutableMap.copyOf((Map)l));
        }
        MinecraftForge.EVENT_BUS.post((Event)new InitAbilitiesEvent.Post(this.entity, l, this.context));
        return l;
    }

    public void save() {
        if (this.entity != null && this.entity.field_70170_p != null && !this.entity.field_70170_p.field_72995_K && this.entity.hasCapability(CapabilitySuperpower.SUPERPOWER_CAP, null)) {
            ((ISuperpowerCapability)this.entity.getCapability(CapabilitySuperpower.SUPERPOWER_CAP, null)).getData().func_74782_a(this.context.toString(), (NBTBase)this.serializeNBT());
        }
    }

    public void load() {
        this.deserializeNBT(((ISuperpowerCapability)this.entity.getCapability(CapabilitySuperpower.SUPERPOWER_CAP, null)).getData().func_74775_l(this.context.toString()));
        for (Ability ability : this.getAbilities()) {
            ability.updateConditions();
        }
    }

    public void sync() {
        if (this.entity.field_70170_p.field_72995_K) {
            return;
        }
        if ((this.sync == EnumSync.SELF || this.sync == EnumSync.EVERYONE) && this.entity instanceof EntityPlayerMP) {
            LCPacketDispatcher.sendTo(new MessageSyncAbilityContainer(this.entity, this), (EntityPlayerMP)this.entity);
        }
        if (this.sync == EnumSync.EVERYONE) {
            ((WorldServer)this.entity.field_70170_p).func_73039_n().getTrackingPlayers((Entity)this.entity).forEach(p -> LCPacketDispatcher.sendTo(new MessageSyncAbilityContainer(this.entity, this), (EntityPlayerMP)p));
        }
    }
}

