/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.superpowers.abilities.supplier;

import lucraft.mods.lucraftcore.superpowers.Superpower;
import lucraft.mods.lucraftcore.superpowers.abilities.Ability;
import lucraft.mods.lucraftcore.superpowers.abilities.supplier.AbilityContainer;
import lucraft.mods.lucraftcore.superpowers.abilities.supplier.EnumSync;
import lucraft.mods.lucraftcore.superpowers.toasts.SuperpowerLevelUpToast;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.toasts.IToast;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AbilityContainerSuperpower
extends AbilityContainer {
    private int xp;
    private int level;
    private Superpower superpower;

    public AbilityContainerSuperpower(EntityLivingBase entity) {
        super(entity, Ability.EnumAbilityContext.SUPERPOWER);
    }

    @Override
    public void onUpdate() {
        this.superpower = this.provider == null ? null : (this.provider instanceof Superpower ? (Superpower)this.provider : null);
        super.onUpdate();
    }

    public int getLevel() {
        if (this.superpower != null && this.superpower.canLevelUp()) {
            return MathHelper.func_76125_a((int)this.level, (int)1, (int)this.superpower.getMaxLevel());
        }
        return 0;
    }

    public void setLevel(int level) {
        if (this.superpower != null && this.superpower.canLevelUp()) {
            this.level = MathHelper.func_76125_a((int)level, (int)1, (int)this.superpower.getMaxLevel());
            this.sync = this.sync.add(EnumSync.SELF);
        }
    }

    public int getXP() {
        if (this.superpower != null && this.superpower.canLevelUp()) {
            return MathHelper.func_76125_a((int)this.xp, (int)0, (int)this.superpower.getXPForLevel(this.getLevel() + 1));
        }
        return 0;
    }

    public void setXP(int xp) {
        if (this.superpower != null && this.superpower.canLevelUp()) {
            this.xp = MathHelper.func_76125_a((int)xp, (int)0, (int)this.superpower.getXPForLevel(this.getLevel() + 1));
            this.sync = this.sync.add(EnumSync.SELF);
        }
    }

    public void addXP(int xp) {
        this.addXP(xp, true);
    }

    public void addXP(int xp, boolean showMessage) {
        if (xp > 0 && this.superpower != null && this.superpower.canLevelUp() && this.level < this.superpower.getMaxLevel()) {
            int max = this.superpower.getXPForLevel(this.level + 1);
            this.setXP(this.getXP() + xp);
            int tB = this.getXP();
            if (this.getXP() >= max) {
                this.levelUp();
                this.addXP(tB - max, false);
            }
        }
    }

    public void levelUp() {
        if (this.superpower != null && this.superpower.canLevelUp() && this.level < this.superpower.getMaxLevel()) {
            this.setLevel(this.getLevel() + 1);
            this.setXP(0);
            if (this.entity.field_70170_p.field_72995_K) {
                this.sendLevelUpMessage(this.getLevel());
            }
            this.sync = this.sync.add(EnumSync.SELF);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void sendLevelUpMessage(int level) {
        Minecraft.func_71410_x().func_193033_an().func_192988_a((IToast)new SuperpowerLevelUpToast());
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = super.serializeNBT();
        nbt.func_74768_a("Level", this.level);
        nbt.func_74768_a("XP", this.xp);
        return nbt;
    }

    @Override
    public NBTTagCompound serializeNBTSync() {
        NBTTagCompound nbt = super.serializeNBTSync();
        nbt.func_74768_a("Level", this.level);
        nbt.func_74768_a("XP", this.xp);
        return nbt;
    }

    @Override
    public void deserializeNBT(NBTTagCompound nbt) {
        super.deserializeNBT(nbt);
        this.level = nbt.func_74762_e("Level");
        this.xp = nbt.func_74762_e("XP");
    }

    @Override
    public void deserializeNBTSync(NBTTagCompound nbt) {
        super.deserializeNBTSync(nbt);
        this.level = nbt.func_74762_e("Level");
        this.xp = nbt.func_74762_e("XP");
    }
}

