/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.superpowers.effects;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lucraft.mods.lucraftcore.superpowers.Superpower;
import lucraft.mods.lucraftcore.superpowers.SuperpowerHandler;
import lucraft.mods.lucraftcore.superpowers.effects.Effect;
import lucraft.mods.lucraftcore.superpowers.effects.EffectCondition;
import lucraft.mods.lucraftcore.superpowers.effects.EffectConditionAbilityEnabled;
import lucraft.mods.lucraftcore.superpowers.effects.EffectConditionAbilityUnlocked;
import lucraft.mods.lucraftcore.superpowers.effects.EffectConditionAlways;
import lucraft.mods.lucraftcore.superpowers.effects.EffectConditionMoving;
import lucraft.mods.lucraftcore.superpowers.effects.EffectConditionNot;
import lucraft.mods.lucraftcore.superpowers.effects.EffectConditionOpenArmor;
import lucraft.mods.lucraftcore.superpowers.effects.EffectFlickering;
import lucraft.mods.lucraftcore.superpowers.effects.EffectGlow;
import lucraft.mods.lucraftcore.superpowers.effects.EffectGlowingHand;
import lucraft.mods.lucraftcore.superpowers.effects.EffectHUD;
import lucraft.mods.lucraftcore.superpowers.effects.EffectNameChange;
import lucraft.mods.lucraftcore.superpowers.effects.EffectSkinChange;
import lucraft.mods.lucraftcore.superpowers.effects.EffectSkinOverlay;
import lucraft.mods.lucraftcore.superpowers.effects.EffectTrail;
import lucraft.mods.lucraftcore.superpowers.effects.EffectVibrating;
import lucraft.mods.lucraftcore.superpowers.suitsets.SuitSet;
import lucraft.mods.lucraftcore.util.render.LayerRendererAprilFools;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.JsonUtils;
import net.minecraftforge.common.MinecraftForge;

public class EffectHandler {
    public static Map<String, Class<? extends Effect>> TYPES = new HashMap<String, Class<? extends Effect>>();
    public static Map<String, Class<? extends EffectCondition>> CONDITIONS = new HashMap<String, Class<? extends EffectCondition>>();
    private static final EffectTrail FLASH_TRAIL = new EffectTrail();

    public static Effect makeEffect(JsonObject json) throws Exception {
        String type = JsonUtils.func_151200_h((JsonObject)json, (String)"type");
        if (!TYPES.containsKey(type)) {
            throw new Exception("The effect type '" + type + "' doesn't exist!");
        }
        Effect effect = TYPES.get(type).newInstance();
        effect.readSettings(json);
        if (JsonUtils.func_151204_g((JsonObject)json, (String)"conditions")) {
            JsonArray conArray = JsonUtils.func_151214_t((JsonObject)json, (String)"conditions");
            for (int i = 0; i < conArray.size(); ++i) {
                JsonObject condition = conArray.get(i).getAsJsonObject();
                String conType = JsonUtils.func_151200_h((JsonObject)condition, (String)"type");
                if (!CONDITIONS.containsKey(conType)) {
                    throw new Exception("The effect condition '" + conType + "' doesn't exist!");
                }
                EffectCondition c = CONDITIONS.get(conType).newInstance();
                c.readSettings(condition);
                effect.conditions.add(c);
            }
        } else {
            effect.conditions.add(new EffectConditionAlways());
        }
        return effect;
    }

    public static <T extends Effect> T makeEffect(Class<T> effect, EffectCondition ... conditions) {
        try {
            Effect e = (Effect)effect.newInstance();
            e.conditions.addAll(Arrays.asList(conditions));
            return (T)e;
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T extends Effect> List<T> getEffectsByClass(EntityPlayer player, Class<T> effect) {
        ArrayList<Effect> effects = new ArrayList<Effect>();
        Superpower superpower = SuperpowerHandler.getSuperpower((EntityLivingBase)player);
        SuitSet suitSet = SuitSet.getSuitSet((EntityLivingBase)player);
        if (superpower != null && superpower.getEffects() != null) {
            for (Effect e : superpower.getEffects()) {
                if (e.getClass() != effect) continue;
                effects.add(e);
            }
        }
        if (suitSet != null && suitSet.getEffects() != null) {
            for (Effect e : suitSet.getEffects()) {
                if (e.getClass() != effect) continue;
                effects.add(e);
            }
        }
        if (effect == EffectTrail.class && LayerRendererAprilFools.isAprilFoolsDay()) {
            effects.add(FLASH_TRAIL);
        }
        return effects;
    }

    public static boolean canEffectBeDisplayed(Effect effect, EntityPlayer player) {
        for (EffectCondition con : effect.conditions) {
            if (con.isFulFilled((EntityLivingBase)player)) continue;
            return false;
        }
        return true;
    }

    static {
        TYPES.put("glow", EffectGlow.class);
        TYPES.put("skin_change", EffectSkinChange.class);
        TYPES.put("skin_overlay", EffectSkinOverlay.class);
        TYPES.put("vibrating", EffectVibrating.class);
        TYPES.put("flickering", EffectFlickering.class);
        TYPES.put("trail", EffectTrail.class);
        TYPES.put("glowing_hand", EffectGlowingHand.class);
        TYPES.put("name_change", EffectNameChange.class);
        TYPES.put("hud", EffectHUD.class);
        CONDITIONS.put("not", EffectConditionNot.class);
        CONDITIONS.put("always", EffectConditionAlways.class);
        CONDITIONS.put("ability_enabled", EffectConditionAbilityEnabled.class);
        CONDITIONS.put("ability_unlocked", EffectConditionAbilityUnlocked.class);
        CONDITIONS.put("moving", EffectConditionMoving.class);
        CONDITIONS.put("open_armor", EffectConditionOpenArmor.class);
        MinecraftForge.EVENT_BUS.register((Object)new EffectNameChange.EventHandler());
        EffectHandler.FLASH_TRAIL.type = EffectTrail.TrailType.LIGHTNINGS;
        EffectHandler.FLASH_TRAIL.color = new Color(1.0f, 0.2f, 0.0f);
    }
}

