/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.superpowers.effects;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.awt.Color;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Random;
import lucraft.mods.lucraftcore.superpowers.SuperpowerHandler;
import lucraft.mods.lucraftcore.superpowers.effects.Effect;
import lucraft.mods.lucraftcore.superpowers.effects.EffectHandler;
import lucraft.mods.lucraftcore.superpowers.suitsets.SuitSet;
import lucraft.mods.lucraftcore.util.helper.LCRenderHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class EffectTrail
extends Effect {
    public TrailType type;
    public Color color;
    public boolean useSuitTrails;

    @Override
    public void readSettings(JsonObject json) {
        this.type = TrailType.getTrailTypeFromName(JsonUtils.func_151200_h((JsonObject)json, (String)"trail_type"));
        if (this.type == null) {
            try {
                throw new Exception("The trail type '" + JsonUtils.func_151200_h((JsonObject)json, (String)"trail_type") + "' doesn't exist!");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        JsonArray array = JsonUtils.func_151214_t((JsonObject)json, (String)"color");
        this.color = new Color(array.get(0).getAsFloat(), array.get(1).getAsFloat(), array.get(2).getAsFloat());
        this.useSuitTrails = JsonUtils.func_151209_a((JsonObject)json, (String)"use_suit_trails", (boolean)false);
    }

    public Color getColor(EntityPlayer player) {
        if (!this.useSuitTrails) {
            return this.color;
        }
        SuitSet suitSet = SuitSet.getSuitSet((EntityLivingBase)player);
        if (suitSet != null && suitSet.getData() != null && suitSet.getData().func_74764_b("trail")) {
            NBTTagCompound data = suitSet.getData().func_74775_l("trail");
            return new Color(data.func_74760_g("red"), data.func_74760_g("green"), data.func_74760_g("blue"));
        }
        return this.color;
    }

    public static boolean hasTrail(EntityPlayer player) {
        for (EffectTrail trails : EffectHandler.getEffectsByClass(player, EffectTrail.class)) {
            if (!EffectHandler.canEffectBeDisplayed(trails, player)) continue;
            return true;
        }
        return false;
    }

    public static float median(double currentPos, double prevPos, float renderTick) {
        return (float)(prevPos + (currentPos - prevPos) * (double)renderTick);
    }

    public static void translateRendering(EntityPlayer player, Entity entity, float renderTick) {
        double x = -EffectTrail.median(entity.field_70165_t, entity.field_70169_q, renderTick) - (EffectTrail.median(player.field_70165_t, player.field_70169_q, renderTick) - EffectTrail.median(entity.field_70165_t, entity.field_70169_q, renderTick));
        double y = -EffectTrail.median(entity.field_70163_u, entity.field_70167_r, renderTick) - (EffectTrail.median(player.field_70163_u, player.field_70167_r, renderTick) - EffectTrail.median(entity.field_70163_u, entity.field_70167_r, renderTick));
        double z = -EffectTrail.median(entity.field_70161_v, entity.field_70166_s, renderTick) - (EffectTrail.median(player.field_70161_v, player.field_70166_s, renderTick) - EffectTrail.median(entity.field_70161_v, entity.field_70166_s, renderTick));
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
    }

    public static class TrailRendererRandomLightnings
    extends TrailRendererLightnings {
        @Override
        public void renderTrail(EntityPlayer en, EffectTrail trail, LinkedList<EntityTrail> list, float partialRenderTicks) {
            if (Minecraft.func_71410_x().field_71474_y.field_74320_O == 0 && en == Minecraft.func_71410_x().field_71439_g) {
                return;
            }
            Color c = trail.color;
            Random rand = new Random();
            GlStateManager.func_179094_E();
            GlStateManager.func_179090_x();
            GlStateManager.func_179140_f();
            GlStateManager.func_179147_l();
            GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
            GlStateManager.func_179112_b((int)770, (int)1);
            float lastBrightnessX = OpenGlHelper.lastBrightnessX;
            float lastBrightnessY = OpenGlHelper.lastBrightnessY;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            this.translateRendering((EntityPlayer)player, (Entity)en);
            int radius = 6;
            float f = player.field_70130_N / 2.0f;
            for (int i = 0; i < 20; ++i) {
                boolean isBlock;
                if (i >= list.size() - 1) continue;
                EntityTrail mirage = list.get(i);
                Vec3d start = en.func_174791_d().func_72441_c((double)(mirage.lightningFactor[0] * en.field_70130_N - f), (double)(mirage.lightningFactor[0] * en.field_70131_O), (double)(mirage.lightningFactor[0] * en.field_70130_N - f));
                Vec3d end = new Vec3d(en.field_70165_t + (double)f + (double)rand.nextInt(radius) - (double)(radius / 2), en.field_70163_u + (double)(rand.nextFloat() * en.field_70131_O), en.field_70161_v + (double)f + (double)rand.nextInt(radius) - (double)(radius / 2));
                Vec3d middle = new Vec3d((start.field_72450_a + end.field_72450_a) / 2.0 + (double)rand.nextFloat() - 0.5, (start.field_72448_b + end.field_72448_b) / 2.0 + (double)rand.nextFloat() - 0.5, (start.field_72449_c + end.field_72449_c) / 2.0 + (double)rand.nextFloat() - 0.5);
                Vec3d quarter = new Vec3d((start.field_72450_a + middle.field_72450_a) / 2.0 + (double)rand.nextFloat() - 0.5, (start.field_72448_b + middle.field_72448_b) / 2.0 + (double)rand.nextFloat() - 0.5, (start.field_72449_c + middle.field_72449_c) / 2.0 + (double)rand.nextFloat() - 0.5);
                Vec3d thirdQuarter = new Vec3d((end.field_72450_a + middle.field_72450_a) / 2.0 + (double)rand.nextFloat() - 0.5, (end.field_72448_b + middle.field_72448_b) / 2.0 + (double)rand.nextFloat() - 0.5, (end.field_72449_c + middle.field_72449_c) / 2.0 + (double)rand.nextFloat() - 0.5);
                BlockPos posEnd = new BlockPos(end.field_72450_a, end.field_72448_b, end.field_72449_c);
                boolean bl = isBlock = !player.field_70170_p.func_175623_d(posEnd);
                if (!isBlock) continue;
                LCRenderHelper.drawLine(start, quarter, lineWidth, innerLineWidth, c, 1.0f);
                LCRenderHelper.drawLine(quarter, middle, lineWidth, innerLineWidth, c, 1.0f);
                LCRenderHelper.drawLine(middle, thirdQuarter, lineWidth, innerLineWidth, c, 1.0f);
                LCRenderHelper.drawLine(thirdQuarter, end, lineWidth, innerLineWidth, c, 1.0f);
                LCRenderHelper.drawLine(middle, new Vec3d(middle.field_72450_a + (double)(rand.nextFloat() - 0.5f), middle.field_72448_b + (double)(rand.nextFloat() - 0.5f), middle.field_72449_c + (double)(rand.nextFloat() - 0.5f)), lineWidth, innerLineWidth, c, 1.0f);
                LCRenderHelper.drawLine(quarter, new Vec3d(quarter.field_72450_a + (double)(rand.nextFloat() - 0.5f), quarter.field_72448_b + (double)(rand.nextFloat() - 0.5f), quarter.field_72449_c + (double)(rand.nextFloat() - 0.5f)), lineWidth, innerLineWidth, c, 1.0f);
                LCRenderHelper.drawLine(thirdQuarter, new Vec3d(thirdQuarter.field_72450_a + (double)(rand.nextFloat() - 0.5f), thirdQuarter.field_72448_b + (double)(rand.nextFloat() - 0.5f), thirdQuarter.field_72449_c + (double)(rand.nextFloat() - 0.5f)), lineWidth, innerLineWidth, c, 1.0f);
                player.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, end.field_72450_a, end.field_72448_b, end.field_72449_c, 0.0, (double)0.01f, 0.0, new int[0]);
                player.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, end.field_72450_a, end.field_72448_b, end.field_72449_c, 0.0, (double)0.1f, 0.0, new int[0]);
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lastBrightnessX, (float)lastBrightnessY);
            GlStateManager.func_179084_k();
            GlStateManager.func_179145_e();
            GlStateManager.func_179098_w();
            GlStateManager.func_179121_F();
        }
    }

    public static class TrailRendererParticles
    extends TrailRenderer {
        @Override
        public boolean preRenderSpeedMirage(EntityTrail entity, EffectTrail trail, float partialRenderTicks) {
            Color c = trail.getColor(entity.owner);
            float progress = MathHelper.func_76131_a((float)(1.0f - ((float)entity.field_70173_aa + partialRenderTicks) / 10.0f), (float)0.0f, (float)0.2f);
            float translate = -MathHelper.func_76131_a((float)(1.0f - (float)entity.field_70173_aa / 10.0f), (float)0.0f, (float)0.5f) / 15.0f;
            float scale = entity.field_70131_O / 1.8f;
            GlStateManager.func_179109_b((float)0.0f, (float)(translate * scale), (float)0.0f);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glAlphaFunc((int)516, (float)0.003921569f);
            GlStateManager.func_179131_c((float)((float)c.getRed() / 255.0f), (float)((float)c.getGreen() / 255.0f), (float)((float)c.getBlue() / 255.0f), (float)progress);
            entity.alpha = progress;
            return true;
        }

        @SideOnly(value=Side.CLIENT)
        public void drawInnerLight(Vec3d start, Vec3d end, float height, Color c, float alpha) {
            Tessellator tes = Tessellator.func_178181_a();
            BufferBuilder wr = tes.func_178180_c();
            float a = MathHelper.func_76131_a((float)alpha, (float)0.0f, (float)0.25f);
            GlStateManager.func_179131_c((float)((float)c.getRed() / 255.0f), (float)((float)c.getGreen() / 255.0f), (float)((float)c.getBlue() / 255.0f), (float)a);
            wr.func_181668_a(9, DefaultVertexFormats.field_181705_e);
            wr.func_181662_b(start.field_72450_a, start.field_72448_b, start.field_72449_c).func_181675_d();
            wr.func_181662_b(start.field_72450_a, start.field_72448_b + (double)height, start.field_72449_c).func_181675_d();
            wr.func_181662_b(end.field_72450_a, end.field_72448_b + (double)height, end.field_72449_c).func_181675_d();
            wr.func_181662_b(end.field_72450_a, end.field_72448_b, end.field_72449_c).func_181675_d();
            wr.func_181662_b(end.field_72450_a, end.field_72448_b, end.field_72449_c).func_181675_d();
            wr.func_181662_b(end.field_72450_a, end.field_72448_b + (double)height, end.field_72449_c).func_181675_d();
            wr.func_181662_b(start.field_72450_a, start.field_72448_b + (double)height, start.field_72449_c).func_181675_d();
            wr.func_181662_b(start.field_72450_a, start.field_72448_b, start.field_72449_c).func_181675_d();
            tes.func_78381_a();
        }

        @Override
        public void renderTrail(EntityPlayer player, EffectTrail trail, LinkedList<EntityTrail> list, float partialRenderTicks) {
            if (Minecraft.func_71410_x().field_71474_y.field_74320_O == 0 && player == Minecraft.func_71410_x().field_71439_g) {
                return;
            }
            Color c = trail.color;
            GlStateManager.func_179094_E();
            GlStateManager.func_179090_x();
            GlStateManager.func_179140_f();
            GlStateManager.func_179147_l();
            GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
            GlStateManager.func_179112_b((int)770, (int)1);
            EffectTrail.translateRendering((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (Entity)player, partialRenderTicks);
            int amountOfLightnings = 7;
            float lightningSpace = player.field_70131_O / (float)amountOfLightnings;
            if (list.size() > 0) {
                for (int j = 0; j < amountOfLightnings; ++j) {
                    Vec3d add = new Vec3d(0.0, (double)((float)j * lightningSpace), 0.0);
                    Vec3d firstStart = list.getLast().getLightningPosVector(j).func_178788_d(list.getLast().func_174824_e(partialRenderTicks)).func_178787_e(player.func_174824_e(partialRenderTicks).func_72441_c(0.0, (double)(-1.62f * (player.field_70131_O / 1.8f)), 0.0));
                    Vec3d firstEnd = list.getLast().getLightningPosVector(j);
                    float a = 1.0f - ((float)list.getLast().field_70173_aa + partialRenderTicks) / 10.0f;
                    LCRenderHelper.drawLine(firstStart.func_178787_e(add.func_72441_c(0.0, (double)player.field_70131_O, 0.0)), firstEnd.func_178787_e(add), 2.0f, 1.0f, list.getLast().lightningFactor[j] < 0.5f ? c : new Color(153.0f, 153.0f, 153.0f), a);
                    for (int i = 0; i < list.size(); ++i) {
                        if (i >= list.size() - 1) continue;
                        EntityTrail speedMirage = list.get(i);
                        EntityTrail speedMirage2 = list.get(i + 1);
                        Vec3d start = speedMirage.getLightningPosVector(j);
                        Vec3d end = speedMirage2.getLightningPosVector(j);
                        float progress = 1.0f - ((float)speedMirage.field_70173_aa + partialRenderTicks) / 10.0f;
                        LCRenderHelper.drawLine(start.func_178787_e(add), end.func_178787_e(add), 2.0f, 1.0f, speedMirage.lightningFactor[j] < 0.5f ? c : new Color(153.0f, 153.0f, 153.0f), progress);
                    }
                }
                float a = 1.0f - ((float)list.getLast().field_70173_aa + partialRenderTicks) / 10.0f;
                Vec3d firstStart = list.getLast().func_174824_e(partialRenderTicks).func_178788_d(list.getLast().getLightningPosVector(0)).func_178787_e(player.func_174824_e(partialRenderTicks).func_72441_c(0.0, (double)(-1.62f * (player.field_70131_O / 1.8f)), 0.0));
                for (int i = 0; i < list.size(); ++i) {
                    if (i >= list.size() - 1) continue;
                    EntityTrail speedMirage = list.get(i);
                    EntityTrail speedMirage2 = list.get(i + 1);
                    float progress = 1.0f - ((float)speedMirage.field_70173_aa + partialRenderTicks) / 10.0f;
                    this.drawInnerLight(speedMirage.func_174791_d(), speedMirage2.func_174791_d(), speedMirage.field_70131_O, c, progress);
                }
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179084_k();
            GlStateManager.func_179145_e();
            GlStateManager.func_179098_w();
            GlStateManager.func_179121_F();
        }
    }

    public static class TrailRendererNormal
    extends TrailRenderer {
        @Override
        public void renderTrail(EntityPlayer player, EffectTrail trail, LinkedList<EntityTrail> trailEntities, float partialRenderTicks) {
        }

        @Override
        public boolean preRenderSpeedMirage(EntityTrail entity, EffectTrail trail, float partialRenderTicks) {
            Color c = trail.getColor(entity.owner);
            float progress = MathHelper.func_76131_a((float)(1.0f - ((float)entity.field_70173_aa + partialRenderTicks) / 10.0f), (float)0.0f, (float)0.5f);
            float translate = -MathHelper.func_76131_a((float)(1.0f - (float)entity.field_70173_aa / 10.0f), (float)0.0f, (float)0.5f) / 15.0f;
            GlStateManager.func_179109_b((float)0.0f, (float)(translate * (entity.field_70131_O / 1.8f)), (float)0.0f);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glAlphaFunc((int)516, (float)0.003921569f);
            GlStateManager.func_179131_c((float)((float)c.getRed() / 255.0f), (float)((float)c.getGreen() / 255.0f), (float)((float)c.getBlue() / 255.0f), (float)progress);
            entity.alpha = progress;
            return true;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class TrailRendererLightnings
    extends TrailRenderer {
        public static int lineWidth = 5;
        public static int innerLineWidth = 1;

        @Override
        public void renderTrail(EntityPlayer player, EffectTrail trail, LinkedList<EntityTrail> trailEntities, float partialRenderTicks) {
            if (Minecraft.func_71410_x().field_71474_y.field_74320_O == 0 && player == Minecraft.func_71410_x().field_71439_g) {
                return;
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179090_x();
            GlStateManager.func_179140_f();
            GlStateManager.func_179147_l();
            GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
            GlStateManager.func_179112_b((int)770, (int)1);
            LCRenderHelper.setLightmapTextureCoords(240.0f, 240.0f);
            EntityPlayerSP mcPlayer = Minecraft.func_71410_x().field_71439_g;
            this.translateRendering((EntityPlayer)mcPlayer, (Entity)player);
            int amountOfLightnings = 6;
            float lightningSpace = player.field_70131_O / (float)amountOfLightnings;
            for (int j = 0; j < amountOfLightnings; ++j) {
                Vec3d add = new Vec3d(0.0, (double)((float)j * lightningSpace), 0.0);
                float differ = 0.425f * (player.field_70131_O / 1.8f);
                if (trailEntities.size() <= 0) continue;
                Vec3d firstStart = trailEntities.getLast().getLightningPosVector(j).func_178788_d(trailEntities.getLast().func_174824_e(LCRenderHelper.renderTick)).func_178787_e(player.func_174824_e(LCRenderHelper.renderTick).func_72441_c(0.0, (double)(-1.62f * (player.field_70131_O / 1.8f)), 0.0));
                Vec3d firstEnd = trailEntities.getLast().getLightningPosVector(j);
                float a = 1.0f - ((float)trailEntities.getLast().field_70173_aa + LCRenderHelper.renderTick) / 10.0f;
                LCRenderHelper.drawLine(firstStart.func_178787_e(add).func_72441_c(0.0, (double)player.field_70131_O, 0.0), firstEnd.func_178787_e(add.func_72441_c(0.0, (double)(trailEntities.getLast().lightningFactor[j] * differ), 0.0)), lineWidth, innerLineWidth, trail.getColor(player), a);
                for (int i = 0; i < trailEntities.size(); ++i) {
                    if (i >= trailEntities.size() - 1) continue;
                    EntityTrail speedMirage = trailEntities.get(i);
                    EntityTrail speedMirage2 = trailEntities.get(i + 1);
                    Vec3d start = speedMirage.getLightningPosVector(j);
                    Vec3d end = speedMirage2.getLightningPosVector(j);
                    float progress = 1.0f - ((float)speedMirage.field_70173_aa + LCRenderHelper.renderTick) / 10.0f;
                    LCRenderHelper.drawLine(start.func_178787_e(add.func_72441_c(0.0, (double)(speedMirage.lightningFactor[j] * differ), 0.0)), end.func_178787_e(add.func_72441_c(0.0, (double)(speedMirage2.lightningFactor[j] * differ), 0.0)), 5.0f, 1.0f, trail.getColor(player), progress);
                }
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            LCRenderHelper.restoreLightmapTextureCoords();
            GlStateManager.func_179084_k();
            GlStateManager.func_179145_e();
            GlStateManager.func_179098_w();
            GlStateManager.func_179121_F();
        }

        @SideOnly(value=Side.CLIENT)
        public float median(double currentPos, double prevPos) {
            return (float)(prevPos + (currentPos - prevPos) * (double)LCRenderHelper.renderTick);
        }

        @SideOnly(value=Side.CLIENT)
        public void translateRendering(EntityPlayer player, Entity entity) {
            double x = -this.median(entity.field_70165_t, entity.field_70169_q) - (this.median(player.field_70165_t, player.field_70169_q) - this.median(entity.field_70165_t, entity.field_70169_q));
            double y = -this.median(entity.field_70163_u, entity.field_70167_r) - (this.median(player.field_70163_u, player.field_70167_r) - this.median(entity.field_70163_u, entity.field_70167_r));
            double z = -this.median(entity.field_70161_v, entity.field_70166_s) - (this.median(player.field_70161_v, player.field_70166_s) - this.median(entity.field_70161_v, entity.field_70166_s));
            GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static abstract class TrailRenderer {
        @SideOnly(value=Side.CLIENT)
        public abstract void renderTrail(EntityPlayer var1, EffectTrail var2, LinkedList<EntityTrail> var3, float var4);

        public boolean preRenderSpeedMirage(EntityTrail entity, EffectTrail trail, float partialRenderTicks) {
            return false;
        }
    }

    public static class EntityTrail
    extends EntityLivingBase {
        public EntityPlayer owner;
        public EffectTrail[] effects;
        public float[] lightningFactor;
        public float alpha = 1.0f;

        public EntityTrail(World worldIn) {
            super(worldIn);
            this.field_70145_X = true;
            this.field_70158_ak = true;
        }

        public EntityTrail(World world, EntityPlayer owner, EffectTrail ... effects) {
            this(world);
            this.owner = owner;
            this.effects = effects;
            this.func_70105_a(owner.field_70130_N, owner.field_70131_O);
            this.func_70012_b(owner.field_70165_t, owner.field_70163_u, owner.field_70161_v, owner.field_70177_z, owner.field_70125_A);
            this.field_70733_aJ = owner.field_70733_aJ;
            this.field_70732_aI = owner.field_70733_aJ;
            this.field_70760_ar = owner.field_70761_aq;
            this.field_70761_aq = owner.field_70761_aq;
            this.field_70758_at = owner.field_70759_as;
            this.field_70759_as = owner.field_70759_as;
            this.field_70127_C = owner.field_70125_A;
            this.field_70125_A = owner.field_70125_A;
            this.field_70721_aZ = owner.field_70721_aZ;
            this.field_184618_aE = owner.field_70721_aZ;
            this.field_184619_aG = owner.field_184619_aG;
            this.lightningFactor = new float[20];
            for (int i = 0; i < 20; ++i) {
                this.lightningFactor[i] = this.field_70146_Z.nextFloat();
            }
        }

        public Random getRandom() {
            return new Random(this.func_145782_y());
        }

        public Vec3d getLightningPosVector(int i) {
            float halfWidth = this.field_70130_N / 2.0f;
            return new Vec3d(this.field_70165_t - (double)halfWidth + (double)(this.lightningFactor[i] * this.field_70130_N), this.field_70163_u, this.field_70161_v - (double)halfWidth + (double)(this.lightningFactor[10 + i] * this.field_70130_N));
        }

        public void func_70071_h_() {
            super.func_70071_h_();
            if (this.field_70173_aa >= 11) {
                this.func_70106_y();
                SuperpowerHandler.getSuperpowerCapability((EntityLivingBase)this.owner).removeTrailEntity((Entity)this);
            }
        }

        public void func_70636_d() {
        }

        public boolean shouldRenderInPass(int pass) {
            return pass == 1;
        }

        public boolean func_70067_L() {
            return false;
        }

        public boolean func_70104_M() {
            return false;
        }

        public boolean func_70039_c(NBTTagCompound par1NBTTagCompound) {
            return false;
        }

        public void func_70037_a(NBTTagCompound nbttagcompound) {
        }

        public void func_70014_b(NBTTagCompound nbttagcompound) {
        }

        public Iterable<ItemStack> func_184193_aE() {
            return Arrays.asList(new ItemStack[0]);
        }

        public ItemStack func_184582_a(EntityEquipmentSlot slotIn) {
            return ItemStack.field_190927_a;
        }

        public void func_184201_a(EntityEquipmentSlot slotIn, ItemStack stack) {
        }

        public EnumHandSide func_184591_cq() {
            return this.owner.func_184591_cq();
        }
    }

    public static enum TrailType {
        LIGHTNINGS,
        NORMAL,
        PARTICLES,
        ELECTRICITY;


        @SideOnly(value=Side.CLIENT)
        public TrailRenderer getTrailRenderer() {
            if (this == LIGHTNINGS) {
                return new TrailRendererLightnings();
            }
            if (this == NORMAL) {
                return new TrailRendererNormal();
            }
            if (this == PARTICLES) {
                return new TrailRendererParticles();
            }
            if (this == ELECTRICITY) {
                return new TrailRendererRandomLightnings();
            }
            return null;
        }

        public static TrailType getTrailTypeFromName(String name) {
            for (TrailType types : TrailType.values()) {
                if (!types.toString().equalsIgnoreCase(name)) continue;
                return types;
            }
            return null;
        }
    }
}

